/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.HighlighterList;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelEvent;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MarkupModelImpl
extends UserDataHolderBase
implements MarkupModelEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.MarkupModelImpl");
    private final DocumentImpl myDocument;
    private final HighlighterList myHighlighterList;
    private final Collection<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();
    private RangeHighlighter[] myCachedHighlighters;
    private final List<MarkupModelListener> myListeners = new ArrayList<MarkupModelListener>();
    private MarkupModelListener[] myCachedListeners;

    MarkupModelImpl(DocumentImpl document) {
        this.myDocument = document;
        this.myHighlighterList = new HighlighterList(document){

            @Override
            protected void assertDispatchThread() {
                MarkupModelImpl.this.assertDispatchThread();
            }
        };
    }

    protected void assertDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @Override
    public void dispose() {
        this.myHighlighterList.dispose();
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int lineNumber, int layer, TextAttributes textAttributes) {
        if (lineNumber >= this.getDocument().getLineCount() || lineNumber < 0) {
            throw new IndexOutOfBoundsException("lineNumber:" + lineNumber + ". Shold be in [0, " + (this.getDocument().getLineCount() - 1) + "]");
        }
        int offset = MarkupModelImpl.getFirstNonspaceCharOffset(this.getDocument(), lineNumber);
        RangeHighlighter rangeHighlighter = this.addRangeHighlighter(offset, offset, layer, textAttributes, HighlighterTargetArea.LINES_IN_RANGE);
        if (rangeHighlighter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/MarkupModelImpl.addLineHighlighter must not return null");
        }
        return rangeHighlighter;
    }

    @Override
    public RangeHighlighter addPersistentLineHighlighter(int lineNumber, int layer, TextAttributes textAttributes) {
        if (lineNumber >= this.getDocument().getLineCount() || lineNumber < 0) {
            return null;
        }
        int offset = MarkupModelImpl.getFirstNonspaceCharOffset(this.getDocument(), lineNumber);
        return this.addRangeHighlighter(offset, offset, layer, textAttributes, HighlighterTargetArea.LINES_IN_RANGE, true);
    }

    static int getFirstNonspaceCharOffset(Document doc, int lineNumber) {
        int lineStart = doc.getLineStartOffset(lineNumber);
        int lineEnd = doc.getLineEndOffset(lineNumber);
        CharSequence text = doc.getCharsSequence();
        int offset = lineStart;
        for (int i = lineStart; i < lineEnd; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t') continue;
            offset = i;
            break;
        }
        return offset;
    }

    @NotNull
    public RangeHighlighter[] getAllHighlighters() {
        if (this.myCachedHighlighters == null) {
            this.myCachedHighlighters = this.myHighlighters.toArray(new RangeHighlighter[this.myHighlighters.size()]);
        }
        if (this.myCachedHighlighters == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/MarkupModelImpl.getAllHighlighters must not return null");
        }
        return this.myCachedHighlighters;
    }

    private RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, TextAttributes textAttributes, HighlighterTargetArea targetArea, boolean isPersistent) {
        RangeHighlighterImpl segmentHighlighter = new RangeHighlighterImpl(this, startOffset, endOffset, layer, targetArea, textAttributes, isPersistent);
        this.myHighlighters.add(segmentHighlighter);
        this.myCachedHighlighters = null;
        this.myHighlighterList.addSegmentHighlighter(segmentHighlighter);
        this.fireSegmentHighlighterChanged(segmentHighlighter);
        return segmentHighlighter;
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/openapi/editor/impl/MarkupModelImpl.addRangeHighlighter must not be null");
        }
        RangeHighlighter rangeHighlighter = this.addRangeHighlighter(startOffset, endOffset, layer, textAttributes, targetArea, false);
        if (rangeHighlighter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/MarkupModelImpl.addRangeHighlighter must not return null");
        }
        return rangeHighlighter;
    }

    public void removeHighlighter(RangeHighlighter segmentHighlighter) {
        boolean removed = this.myHighlighters.remove(segmentHighlighter);
        LOG.assertTrue(removed);
        this.myCachedHighlighters = null;
        this.myHighlighterList.removeSegmentHighlighter(segmentHighlighter);
        this.fireSegmentHighlighterChanged(segmentHighlighter);
    }

    public void removeAllHighlighters() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            this.fireSegmentHighlighterChanged(highlighter);
            this.myHighlighterList.removeSegmentHighlighter(highlighter);
        }
        this.myHighlighters.clear();
        this.myCachedHighlighters = null;
    }

    @NotNull
    public Document getDocument() {
        DocumentImpl documentImpl = this.myDocument;
        if (documentImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/MarkupModelImpl.getDocument must not return null");
        }
        return documentImpl;
    }

    @Override
    public void addMarkupModelListener(MarkupModelListener listener) {
        this.myListeners.add(listener);
        this.myCachedListeners = null;
    }

    @Override
    public void removeMarkupModelListener(MarkupModelListener listener) {
        boolean success = this.myListeners.remove(listener);
        LOG.assertTrue(success);
        this.myCachedListeners = null;
    }

    @Override
    public void setRangeHighlighterAttributes(RangeHighlighter highlighter, TextAttributes textAttributes) {
        ((RangeHighlighterImpl)highlighter).setTextAttributes(textAttributes);
    }

    private MarkupModelListener[] getCachedListeners() {
        if (this.myCachedListeners == null) {
            this.myCachedListeners = this.myListeners.isEmpty() ? MarkupModelListener.EMPTY_ARRAY : this.myListeners.toArray(new MarkupModelListener[this.myListeners.size()]);
        }
        return this.myCachedListeners;
    }

    protected void fireSegmentHighlighterChanged(RangeHighlighter segmentHighlighter) {
        MarkupModelListener[] listeners;
        MarkupModelEvent event = new MarkupModelEvent(this, segmentHighlighter);
        for (MarkupModelListener listener : listeners = this.getCachedListeners()) {
            listener.rangeHighlighterChanged(event);
        }
    }

    @Override
    public HighlighterList getHighlighterList() {
        return this.myHighlighterList;
    }

    @Override
    public boolean containsHighlighter(RangeHighlighter highlighter) {
        return this.myHighlighters.contains(highlighter);
    }
}

