/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.http;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.impl.http.HttpFileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class HttpFileEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.accept must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.accept must not be null");
        }
        return file instanceof HttpVirtualFile && !file.isDirectory();
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.createEditor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.createEditor must not be null");
        }
        HttpFileEditor httpFileEditor = new HttpFileEditor(project, (HttpVirtualFile)file);
        if (httpFileEditor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.createEditor must not return null");
        }
        return httpFileEditor;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.disposeEditor must not be null");
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.readState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.readState must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.readState must not be null");
        }
        TextEditorState textEditorState = new TextEditorState();
        if (textEditorState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.readState must not return null");
        }
        return textEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.writeState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.writeState must not be null");
        }
        if (targetElement == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.writeState must not be null");
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if ("httpFileEditor" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.getEditorTypeId must not return null");
        }
        return "httpFileEditor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/http/HttpFileEditorProvider.getPolicy must not return null");
        }
        return fileEditorPolicy;
    }
}

