/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionProcessor;
import com.intellij.openapi.keymap.impl.KeyProcessorContext;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.keymap.impl.keyGestures.KeyboardGestureProcessor;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextField;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.util.Alarm;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeKeyEventDispatcher
implements Disposable {
    @NonNls
    private static final String GET_CACHED_STROKE_METHOD_NAME = "getCachedStroke";
    private KeyStroke myFirstKeyStroke;
    private boolean myPressedWasProcessed;
    private KeyState myState = KeyState.STATE_INIT;
    private final PresentationFactory myPresentationFactory = new PresentationFactory();
    private boolean myDisposed = false;
    private boolean myLeftCtrlPressed = false;
    private boolean myRightAltPressed = false;
    private final KeyboardGestureProcessor myKeyGestureProcessor = new KeyboardGestureProcessor(this);
    private final KeyProcessorContext myContext = new KeyProcessorContext();
    private IdeEventQueue myQueue;
    private Alarm mySecondStrokeTimeout = new Alarm();
    private Runnable mySecondStrokeTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            if (IdeKeyEventDispatcher.this.myState == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE) {
                StatusBar status;
                Project project;
                IdeKeyEventDispatcher.this.resetState();
                if (IdeKeyEventDispatcher.this.myContext != null && (project = (Project)PlatformDataKeys.PROJECT.getData(IdeKeyEventDispatcher.this.myContext.getDataContext())) != null && (status = WindowManager.getInstance().getStatusBar(project)) != null) {
                    status.setInfo(null);
                }
            }
        }
    };
    private final ActionProcessor myActionProcessor = new ActionProcessor(){

        @Override
        public AnActionEvent createEvent(InputEvent inputEvent, DataContext context, String place, Presentation presentation, ActionManager manager) {
            return new AnActionEvent(inputEvent, context, place, presentation, manager, 0);
        }

        @Override
        public void onUpdatePassed(InputEvent inputEvent, AnAction action, AnActionEvent actionEvent) {
            IdeKeyEventDispatcher.this.setState(KeyState.STATE_PROCESSED);
            IdeKeyEventDispatcher.this.setPressedWasProcessed(inputEvent.getID() == 401);
        }

        @Override
        public void performAction(InputEvent e, AnAction action, AnActionEvent actionEvent) {
            e.consume();
            action.actionPerformed(actionEvent);
        }
    };

    public IdeKeyEventDispatcher(IdeEventQueue queue) {
        this.myQueue = queue;
        Application parent = ApplicationManager.getApplication();
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
    }

    public boolean isWaitingForSecondKeyStroke() {
        return this.getState() == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE || this.isPressedWasProcessed();
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.myDisposed) {
            return false;
        }
        if (e.isConsumed()) {
            return false;
        }
        if (e.getKeyCode() == 17) {
            if (e.getID() == 401) {
                this.myLeftCtrlPressed = e.getKeyLocation() == 2;
            } else if (e.getID() == 402) {
                this.myLeftCtrlPressed = false;
            }
        } else if (e.getKeyCode() == 18) {
            if (e.getID() == 401) {
                this.myRightAltPressed = e.getKeyLocation() == 3;
            } else if (e.getID() == 402) {
                this.myRightAltPressed = false;
            }
        }
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        if (focusOwner instanceof ShortcutTextField) {
            return false;
        }
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
        if (selectedPath.length > 0 && !(selectedPath[0] instanceof ComboPopup)) {
            this.setState(KeyState.STATE_PROCESSED);
            this.setPressedWasProcessed(true);
            return false;
        }
        Window focusedWindow = focusManager.getFocusedWindow();
        boolean isModalContext = focusedWindow != null && IdeKeyEventDispatcher.isModalContext(focusedWindow);
        DataManager dataManager = DataManager.getInstance();
        if (dataManager == null) {
            return false;
        }
        DataContext dataContext = dataManager.getDataContext();
        this.myContext.setDataContext(dataContext);
        this.myContext.setFocusOwner(focusOwner);
        this.myContext.setModalContext(isModalContext);
        this.myContext.setInputEvent(e);
        if (this.getState() == KeyState.STATE_INIT) {
            return this.inInitState();
        }
        if (this.getState() == KeyState.STATE_PROCESSED) {
            return this.inProcessedState();
        }
        if (this.getState() == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE) {
            return this.inWaitForSecondStrokeState();
        }
        if (this.getState() == KeyState.STATE_SECOND_STROKE_IN_PROGRESS) {
            return this.inSecondStrokeInProgressState();
        }
        if (this.getState() == KeyState.STATE_KEY_GESTURE_PROCESSOR) {
            return this.myKeyGestureProcessor.process();
        }
        throw new IllegalStateException("state = " + (Object)((Object)this.getState()));
    }

    public static boolean isModalContext(@NotNull Component component) {
        JBPopup popup;
        boolean isPopup;
        JDialog dialog;
        Component pane;
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher.isModalContext must not be null");
        }
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (window instanceof IdeFrameImpl && (pane = ((IdeFrameImpl)window).getGlassPane()) instanceof IdeGlassPaneEx) {
            return ((IdeGlassPaneEx)((Object)pane)).isInModalContext();
        }
        if (window instanceof JDialog && !(dialog = (JDialog)window).isModal()) {
            return IdeKeyEventDispatcher.isModalContext(dialog.getOwner());
        }
        boolean isMainFrame = window instanceof IdeFrameImpl;
        boolean isFloatingDecorator = window instanceof FloatingDecorator;
        boolean bl = isPopup = !(component instanceof JFrame) && !(component instanceof JDialog);
        if (isPopup && component instanceof JWindow && (popup = (JBPopup)((JWindow)component).getRootPane().getClientProperty("JBPopup")) != null) {
            return popup.isModalContext();
        }
        return !isMainFrame && !isFloatingDecorator;
    }

    private boolean inWaitForSecondStrokeState() {
        if (401 == this.myContext.getInputEvent().getID()) {
            this.setState(KeyState.STATE_SECOND_STROKE_IN_PROGRESS);
            return this.inSecondStrokeInProgressState();
        }
        return true;
    }

    private static KeyStroke getKeyStrokeWithoutMouseModifiers(KeyStroke originalKeyStroke) {
        int modifier = originalKeyStroke.getModifiers() & 0xFFFFFBFF & 0xFFFFFFEF & 0xFFFFF7FF & 0xFFFFFFF7 & 0xFFFFEFFF & 0xFFFFFFFB;
        try {
            Method[] methods = AWTKeyStroke.class.getDeclaredMethods();
            Method getCachedStrokeMethod = null;
            for (Method method : methods) {
                if (!GET_CACHED_STROKE_METHOD_NAME.equals(method.getName())) continue;
                getCachedStrokeMethod = method;
                getCachedStrokeMethod.setAccessible(true);
                break;
            }
            if (getCachedStrokeMethod == null) {
                throw new IllegalStateException("not found method with name getCachedStrokeMethod");
            }
            Object[] getCachedStrokeMethodArgs = new Object[]{Character.valueOf(originalKeyStroke.getKeyChar()), originalKeyStroke.getKeyCode(), modifier, originalKeyStroke.isOnKeyRelease()};
            return (KeyStroke)getCachedStrokeMethod.invoke((Object)originalKeyStroke, getCachedStrokeMethodArgs);
        }
        catch (Exception exc) {
            throw new IllegalStateException(exc.getMessage());
        }
    }

    private boolean inSecondStrokeInProgressState() {
        KeyEvent e = this.myContext.getInputEvent();
        if (402 == e.getID()) {
            this.myFirstKeyStroke = null;
            this.setState(KeyState.STATE_INIT);
            Project project = (Project)PlatformDataKeys.PROJECT.getData(this.myContext.getDataContext());
            StatusBar bar = WindowManager.getInstance().getStatusBar(project);
            if (bar != null) {
                bar.setInfo(null);
            }
            return false;
        }
        KeyStroke originalKeyStroke = KeyStroke.getKeyStrokeForEvent(e);
        KeyStroke keyStroke = IdeKeyEventDispatcher.getKeyStrokeWithoutMouseModifiers(originalKeyStroke);
        this.updateCurrentContext(this.myContext.getFoundComponent(), (Shortcut)new KeyboardShortcut(this.myFirstKeyStroke, keyStroke), this.myContext.isModalContext());
        if (this.myContext.getActions().isEmpty()) {
            return true;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(this.myContext.getDataContext());
        StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(project);
        if (this.processAction(e, this.myActionProcessor)) {
            if (statusBar != null) {
                statusBar.setInfo(null);
            }
            return true;
        }
        return false;
    }

    private boolean inProcessedState() {
        KeyEvent e = this.myContext.getInputEvent();
        if (400 == e.getID() && this.isPressedWasProcessed()) {
            return true;
        }
        if (402 == e.getID() && 18 == e.getKeyCode() && this.isPressedWasProcessed()) {
            return true;
        }
        this.setState(KeyState.STATE_INIT);
        this.setPressedWasProcessed(false);
        return this.inInitState();
    }

    private boolean inInitState() {
        String language;
        InputContext inputContext;
        Component focusOwner = this.myContext.getFocusOwner();
        boolean isModalContext = this.myContext.isModalContext();
        DataContext dataContext = this.myContext.getDataContext();
        KeyEvent e = this.myContext.getInputEvent();
        if (this.myLeftCtrlPressed && this.myRightAltPressed && focusOwner != null && e.getModifiers() == 10 && (inputContext = focusOwner.getInputContext()) != null && ((language = inputContext.getLocale().getLanguage()).equals("pl") || language.equals("de") || language.equals("fi") || language.equals("fr") || language.equals("no") || language.equals("da") || language.equals("se") || language.equals("pt") || language.equals("nl") || language.equals("tr") || language.equals("sl") || language.equals("hu"))) {
            return false;
        }
        KeyStroke originalKeyStroke = KeyStroke.getKeyStrokeForEvent(e);
        KeyStroke keyStroke = IdeKeyEventDispatcher.getKeyStrokeWithoutMouseModifiers(originalKeyStroke);
        if (this.myKeyGestureProcessor.processInitState()) {
            return true;
        }
        if (SystemInfo.isMac && e.getModifiersEx() == 512 && (e.getID() == 401 && IdeKeyEventDispatcher.hasMnemonicInWindow(focusOwner, e.getKeyCode()) || e.getID() == 400 && IdeKeyEventDispatcher.hasMnemonicInWindow(focusOwner, e.getKeyChar()))) {
            this.setPressedWasProcessed(true);
            this.setState(KeyState.STATE_PROCESSED);
            return false;
        }
        this.updateCurrentContext(focusOwner, (Shortcut)new KeyboardShortcut(keyStroke, null), isModalContext);
        if (this.myContext.getActions().isEmpty()) {
            return false;
        }
        if (this.myContext.isHasSecondStroke()) {
            this.myFirstKeyStroke = keyStroke;
            ArrayList<Pair> secondKeyStorkes = new ArrayList<Pair>();
            for (AnAction action : this.myContext.getActions()) {
                Shortcut[] shortcuts;
                for (Shortcut shortcut : shortcuts = action.getShortcutSet().getShortcuts()) {
                    KeyboardShortcut keyShortcut;
                    if (!(shortcut instanceof KeyboardShortcut) || !(keyShortcut = (KeyboardShortcut)shortcut).getFirstKeyStroke().equals(this.myFirstKeyStroke)) continue;
                    secondKeyStorkes.add(new Pair((Object)action, (Object)keyShortcut.getSecondKeyStroke()));
                }
            }
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            StringBuilder message = new StringBuilder();
            message.append(KeyMapBundle.message((String)"prefix.key.pressed.message", (Object[])new Object[0]));
            message.append(' ');
            for (int i = 0; i < secondKeyStorkes.size(); ++i) {
                Pair pair = (Pair)secondKeyStorkes.get(i);
                if (i > 0) {
                    message.append(", ");
                }
                message.append(((AnAction)pair.getFirst()).getTemplatePresentation().getText());
                message.append(" (");
                message.append(KeymapUtil.getKeystrokeText((KeyStroke)((KeyStroke)pair.getSecond())));
                message.append(")");
            }
            StatusBar bar = WindowManager.getInstance().getStatusBar(project);
            if (bar != null) {
                bar.setInfo(message.toString());
            }
            this.mySecondStrokeTimeout.cancelAllRequests();
            this.mySecondStrokeTimeout.addRequest(this.mySecondStrokeTimeoutRunnable, Registry.intValue((String)"actionSystem.secondKeystrokeTimout"));
            this.setState(KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE);
            return true;
        }
        return this.processAction(e, this.myActionProcessor);
    }

    private static boolean hasMnemonicInWindow(Component focusOwner, int keyCode) {
        if (keyCode == 18 || keyCode == 0) {
            return false;
        }
        Container container = IdeKeyEventDispatcher.getContainer(focusOwner);
        return IdeKeyEventDispatcher.hasMnemonic(container, keyCode);
    }

    @Nullable
    private static Container getContainer(@Nullable Component focusOwner) {
        if (focusOwner == null) {
            return null;
        }
        if (focusOwner.isLightweight()) {
            Container parent;
            Container container = focusOwner.getParent();
            while (container != null && !((parent = container.getParent()) instanceof JLayeredPane) && parent != null && parent.isLightweight()) {
                container = parent;
            }
            return container;
        }
        return SwingUtilities.windowForComponent(focusOwner);
    }

    private static boolean hasMnemonic(Container container, int keyCode) {
        Component[] components;
        if (container == null) {
            return false;
        }
        for (Component component : components = container.getComponents()) {
            JLabel label;
            AbstractButton button;
            if (component instanceof AbstractButton && (button = (AbstractButton)component).getMnemonic() == keyCode) {
                return true;
            }
            if (component instanceof JLabel && (label = (JLabel)component).getDisplayedMnemonic() == keyCode) {
                return true;
            }
            if (!(component instanceof Container) || !IdeKeyEventDispatcher.hasMnemonic((Container)component, keyCode)) continue;
            return true;
        }
        return false;
    }

    public boolean processAction(InputEvent e, ActionProcessor processor) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(this.myContext.getDataContext());
        boolean dumb = project != null && DumbService.getInstance((Project)project).isDumb();
        ArrayList<AnActionEvent> nonDumbAwareAction = new ArrayList<AnActionEvent>();
        for (AnAction action : this.myContext.getActions()) {
            Presentation presentation = this.myPresentationFactory.getPresentation(action);
            AnActionEvent actionEvent = processor.createEvent(e, this.myContext.getDataContext(), "MainMenu", presentation, ActionManager.getInstance());
            ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)actionEvent, (boolean)true);
            if (dumb && !(action instanceof DumbAware)) {
                if (Boolean.FALSE.equals(presentation.getClientProperty("WOULD_BE_ENABLED_IF_NOT_DUMB_MODE"))) continue;
                nonDumbAwareAction.add(actionEvent);
                continue;
            }
            if (!presentation.isEnabled()) continue;
            processor.onUpdatePassed(e, action, actionEvent);
            ((DataManagerImpl.MyDataContext)this.myContext.getDataContext()).setEventCount(IdeEventQueue.getInstance().getEventCount());
            actionManager.fireBeforeActionPerformed(action, actionEvent.getDataContext(), actionEvent);
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(actionEvent.getDataContext());
            if (component != null && !component.isShowing()) {
                return true;
            }
            processor.performAction(e, action, actionEvent);
            return true;
        }
        if (!nonDumbAwareAction.isEmpty()) {
            IdeKeyEventDispatcher.showDumbModeWarningLaterIfNobodyConsumesEvent(e, nonDumbAwareAction.toArray(new AnActionEvent[nonDumbAwareAction.size()]));
        }
        return false;
    }

    private static void showDumbModeWarningLaterIfNobodyConsumesEvent(final InputEvent e, final AnActionEvent ... actionEvents) {
        if (ModalityState.current() == ModalityState.NON_MODAL) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (e.isConsumed()) {
                        return;
                    }
                    ActionUtil.showDumbModeWarning((AnActionEvent[])actionEvents);
                }
            });
        }
    }

    public KeyProcessorContext updateCurrentContext(Component component, Shortcut sc, boolean isModalContext) {
        this.myContext.setFoundComponent(null);
        this.myContext.getActions().clear();
        boolean hasSecondStroke = false;
        while (component != null) {
            ArrayList listOfActions;
            if (component instanceof JComponent && (listOfActions = (ArrayList)((JComponent)component).getClientProperty("AnAction.shortcutSet")) != null) {
                for (Object listOfAction : listOfActions) {
                    if (!(listOfAction instanceof AnAction)) continue;
                    AnAction action = (AnAction)listOfAction;
                    hasSecondStroke |= this.addAction(action, sc);
                }
                if (!this.myContext.getActions().isEmpty()) {
                    this.myContext.setFoundComponent((JComponent)component);
                    break;
                }
            }
            component = component.getParent();
        }
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        String[] actionIds = keymap.getActionIds(sc);
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : actionIds) {
            AnAction action = actionManager.getAction(actionId);
            if (action == null || isModalContext && !action.isEnabledInModalContext()) continue;
            hasSecondStroke |= this.addAction(action, sc);
        }
        this.myContext.setHasSecondStroke(hasSecondStroke);
        return this.myContext;
    }

    private boolean addAction(AnAction action, Shortcut sc) {
        Shortcut[] shortcuts;
        boolean hasSecondStroke = false;
        for (Shortcut each : shortcuts = action.getShortcutSet().getShortcuts()) {
            if (!each.isKeyboard() || !each.startsWith(sc)) continue;
            if (!this.myContext.getActions().contains(action)) {
                this.myContext.getActions().add(action);
            }
            if (!(each instanceof KeyboardShortcut)) continue;
            hasSecondStroke |= ((KeyboardShortcut)each).getSecondKeyStroke() != null;
        }
        return hasSecondStroke;
    }

    public KeyProcessorContext getContext() {
        return this.myContext;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public KeyState getState() {
        return this.myState;
    }

    public void setState(KeyState state) {
        this.myState = state;
        if (this.myQueue != null) {
            this.myQueue.maybeReady();
        }
    }

    public void resetState() {
        this.setState(KeyState.STATE_INIT);
        this.setPressedWasProcessed(false);
    }

    public boolean isPressedWasProcessed() {
        return this.myPressedWasProcessed;
    }

    public void setPressedWasProcessed(boolean pressedWasProcessed) {
        this.myPressedWasProcessed = pressedWasProcessed;
    }

    public boolean isReady() {
        return this.myState == KeyState.STATE_INIT || this.myState == KeyState.STATE_PROCESSED;
    }
}

