/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.paths.DynamicContextProvider;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PathReferenceProviderBase
implements PathReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.paths.PathReferenceProviderBase");

    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceProviderBase.createReferences must not be null");
        }
        if (references == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceProviderBase.createReferences must not be null");
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
        assert (manipulator != null);
        TextRange range = manipulator.getRangeInElement(psiElement);
        int offset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        boolean dynamicContext = false;
        String elementText = psiElement.getText();
        for (DynamicContextProvider provider : (DynamicContextProvider[])Extensions.getExtensions(DynamicContextProvider.EP_NAME)) {
            int dynamicOffset = provider.getOffset(psiElement, offset, elementText);
            if (dynamicOffset == -1) {
                return false;
            }
            if (dynamicOffset == offset) continue;
            dynamicContext = true;
            offset = dynamicOffset;
        }
        int pos = PathReferenceProviderBase.getLastPosOfURL(offset, elementText);
        if (pos != -1 && pos < endOffset) {
            endOffset = pos;
        }
        try {
            String text = elementText.substring(offset, endOffset);
            return this.createReferences(psiElement, offset, text, references, soft || dynamicContext);
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Cannot process string: '" + psiElement.getParent().getParent().getText() + "'", (Throwable)e);
            return false;
        }
    }

    public abstract boolean createReferences(@NotNull PsiElement var1, int var2, String var3, @NotNull List<PsiReference> var4, boolean var5);

    public static int getLastPosOfURL(int offset, @NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceProviderBase.getLastPosOfURL must not be null");
        }
        for (int i = offset; i < url.length(); ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '?': {
                    return i;
                }
            }
        }
        return -1;
    }
}

