/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SdkConfigurationUtil {
    private SdkConfigurationUtil() {
    }

    @Nullable
    public static Sdk addSdk(Project project, SdkType ... sdkTypes) {
        String suggestedPath;
        VirtualFile suggestedDir;
        if (sdkTypes.length == 0) {
            return null;
        }
        FileChooserDescriptor descriptor = SdkConfigurationUtil.createCompositeDescriptor(sdkTypes);
        FileChooserDialog dialog = FileChooserFactory.getInstance().createFileChooser(descriptor, project);
        VirtualFile[] selection = dialog.choose(suggestedDir = (suggestedPath = sdkTypes[0].suggestHomePath()) == null ? null : LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)suggestedPath)), project);
        if (selection.length > 0) {
            for (SdkType sdkType : sdkTypes) {
                if (!sdkType.isValidSdkHome(selection[0].getPath())) continue;
                return SdkConfigurationUtil.setupSdk(selection[0], sdkType, false);
            }
        }
        return null;
    }

    private static FileChooserDescriptor createCompositeDescriptor(final SdkType ... sdkTypes) {
        FileChooserDescriptor descriptor0 = sdkTypes[0].getHomeChooserDescriptor();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(descriptor0.isChooseFiles(), descriptor0.isChooseFolders(), descriptor0.isChooseJars(), descriptor0.isChooseJarsAsFiles(), descriptor0.isChooseJarContents(), descriptor0.isChooseMultiple()){

            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                if (files.length > 0) {
                    for (SdkType type : sdkTypes) {
                        if (!type.isValidSdkHome(files[0].getPath())) continue;
                        return;
                    }
                }
                String message = files.length > 0 && files[0].isDirectory() ? ProjectBundle.message((String)"sdk.configure.home.invalid.error", (Object[])new Object[]{sdkTypes[0].getPresentableName()}) : ProjectBundle.message((String)"sdk.configure.home.file.invalid.error", (Object[])new Object[]{sdkTypes[0].getPresentableName()});
                throw new Exception(message);
            }
        };
        descriptor.setTitle(descriptor0.getTitle());
        return descriptor;
    }

    public static void removeSdk(final Sdk sdk) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
        });
    }

    @Nullable
    public static Sdk setupSdk(VirtualFile homeDir, SdkType sdkType, boolean silent) {
        return SdkConfigurationUtil.setupSdk(homeDir, sdkType, silent, null, null);
    }

    @Nullable
    public static Sdk setupSdk(VirtualFile homeDir, SdkType sdkType, boolean silent, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        ProjectJdkImpl projectJdk;
        Sdk[] sdks = ProjectJdkTable.getInstance().getAllJdks();
        List<Sdk> sdksList = Arrays.asList(sdks);
        try {
            String sdkName = customSdkSuggestedName == null ? SdkConfigurationUtil.createUniqueSdkName(sdkType, homeDir.getPath(), sdksList) : SdkConfigurationUtil.createUniqueSdkName(customSdkSuggestedName, sdksList);
            projectJdk = new ProjectJdkImpl(sdkName, sdkType);
            if (additionalData != null) {
                projectJdk.setSdkAdditionalData(additionalData);
            }
            projectJdk.setHomePath(homeDir.getPath());
            sdkType.setupSdkPaths((Sdk)projectJdk);
        }
        catch (Exception e) {
            if (!silent) {
                Messages.showErrorDialog((String)("Error configuring SDK: " + e.getMessage() + ".\nPlease make sure that " + FileUtil.toSystemDependentName((String)homeDir.getPath()) + " is a valid home path for this SDK type."), (String)"Error configuring SDK");
            }
            return null;
        }
        return (Sdk)ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<Sdk>(){

            public Sdk compute() {
                ProjectJdkTable.getInstance().addJdk((Sdk)projectJdk);
                return projectJdk;
            }
        });
    }

    @Nullable
    public static Sdk setupSdk(VirtualFile homeDir, SdkType sdkType) {
        return SdkConfigurationUtil.setupSdk(homeDir, sdkType, true);
    }

    public static void setDirectoryProjectSdk(final Project project, final Sdk sdk) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectRootManager.getInstance((Project)project).setProjectJdk(sdk);
                Module[] modules = ModuleManager.getInstance((Project)project).getModules();
                if (modules.length > 0) {
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)modules[0]).getModifiableModel();
                    model.inheritSdk();
                    model.commit();
                }
            }
        });
    }

    public static void configureDirectoryProjectSdk(Project project, SdkType ... sdkTypes) {
        Sdk existingSdk = ProjectRootManager.getInstance((Project)project).getProjectJdk();
        if (existingSdk != null && ArrayUtil.contains((Object)existingSdk.getSdkType(), (Object[])sdkTypes)) {
            return;
        }
        Sdk sdk = SdkConfigurationUtil.findOrCreateSdk(sdkTypes);
        if (sdk != null) {
            SdkConfigurationUtil.setDirectoryProjectSdk(project, sdk);
        }
    }

    @Nullable
    public static Sdk findOrCreateSdk(SdkType ... sdkTypes) {
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        Sdk sdk = ProjectRootManager.getInstance((Project)defaultProject).getProjectJdk();
        if (sdk != null) {
            for (SdkType type : sdkTypes) {
                if (sdk.getSdkType() != type) continue;
                return sdk;
            }
        }
        for (SdkType type : sdkTypes) {
            List sdks = ProjectJdkTable.getInstance().getSdksOfType(type);
            if (sdks.size() <= 0) continue;
            return (Sdk)sdks.get(0);
        }
        for (SdkType sdkType : sdkTypes) {
            VirtualFile sdkHome;
            final String suggestedHomePath = sdkType.suggestHomePath();
            if (suggestedHomePath == null || !sdkType.isValidSdkHome(suggestedHomePath) || (sdkHome = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

                public VirtualFile compute() {
                    return LocalFileSystem.getInstance().refreshAndFindFileByPath(suggestedHomePath);
                }
            })) == null) continue;
            return SdkConfigurationUtil.setupSdk(sdkHome, sdkType, true);
        }
        return null;
    }

    public static String createUniqueSdkName(SdkType type, String home, Collection<Sdk> sdks) {
        return SdkConfigurationUtil.createUniqueSdkName(type.suggestSdkName(null, home), sdks);
    }

    public static String createUniqueSdkName(String suggestedName, Collection<Sdk> sdks) {
        HashSet<String> names = new HashSet<String>();
        for (Sdk jdk : sdks) {
            names.add(jdk.getName());
        }
        String newSdkName = suggestedName;
        int i = 0;
        while (names.contains(newSdkName)) {
            newSdkName = suggestedName + " (" + ++i + ")";
        }
        return newSdkName;
    }
}

