/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationEditorProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ModuleLevelConfigurablesEditorProvider
implements ModuleConfigurationEditorProvider,
ModuleComponent {
    public static final ExtensionPointName<Configurable> MODULE_CONFIGURABLES = ExtensionPointName.create((String)"com.intellij.moduleConfigurable");
    private final Module myModule;

    public ModuleLevelConfigurablesEditorProvider(Module module) {
        this.myModule = module;
    }

    public ModuleConfigurationEditor[] createEditors(ModuleConfigurationState state) {
        Configurable[] moduleConfigurables;
        ArrayList<ConfigurableWrapper> result = new ArrayList<ConfigurableWrapper>();
        for (Configurable moduleConfigurable : moduleConfigurables = (Configurable[])this.myModule.getComponents(Configurable.class)) {
            result.add(new ConfigurableWrapper(moduleConfigurable));
        }
        for (Configurable configurable : (Configurable[])Extensions.getExtensions(MODULE_CONFIGURABLES, (AreaInstance)this.myModule)) {
            result.add(new ConfigurableWrapper(configurable));
        }
        return result.toArray(new ModuleConfigurationEditor[result.size()]);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void moduleAdded() {
    }

    public String getComponentName() {
        return "ModuleLevelConfigurablesEditorProvider";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private static class ConfigurableWrapper
    implements ModuleConfigurationEditor {
        private final Configurable myModuleConfigurable;

        public ConfigurableWrapper(Configurable moduleConfigurable) {
            this.myModuleConfigurable = moduleConfigurable;
        }

        public void saveData() {
        }

        public void moduleStateChanged() {
        }

        public String getDisplayName() {
            return this.myModuleConfigurable.getDisplayName();
        }

        public Icon getIcon() {
            return this.myModuleConfigurable.getIcon();
        }

        public String getHelpTopic() {
            return this.myModuleConfigurable.getHelpTopic();
        }

        public JComponent createComponent() {
            return this.myModuleConfigurable.createComponent();
        }

        public boolean isModified() {
            return this.myModuleConfigurable.isModified();
        }

        public void apply() throws ConfigurationException {
            this.myModuleConfigurable.apply();
        }

        public void reset() {
            this.myModuleConfigurable.reset();
        }

        public void disposeUIResources() {
            this.myModuleConfigurable.disposeUIResources();
        }
    }
}

