/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.IconLoader;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactProblemQuickFix;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ArtifactErrorPanel {
    private JPanel myMainPanel;
    private JButton myFixButton;
    private JLabel myErrorLabel;
    private List<ArtifactProblemQuickFix> myCurrentQuickFixes;

    public ArtifactErrorPanel(final ArtifactEditorImpl artifactEditor) {
        this.$$$setupUI$$$();
        this.myErrorLabel.setIcon(IconLoader.getIcon((String)"/runConfigurations/configurationWarning.png"));
        this.myFixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ArtifactErrorPanel.this.myCurrentQuickFixes.isEmpty()) {
                    if (ArtifactErrorPanel.this.myCurrentQuickFixes.size() == 1) {
                        ArtifactErrorPanel.performFix((ArtifactProblemQuickFix)ContainerUtil.getFirstItem((Collection)ArtifactErrorPanel.this.myCurrentQuickFixes, null), artifactEditor);
                    } else {
                        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ArtifactProblemQuickFix>(null, ArtifactErrorPanel.this.myCurrentQuickFixes){

                            @NotNull
                            public String getTextFor(ArtifactProblemQuickFix value) {
                                String string = value.getActionName();
                                if (string == null) {
                                    throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactErrorPanel$1$1.getTextFor must not return null");
                                }
                                return string;
                            }

                            public PopupStep onChosen(ArtifactProblemQuickFix selectedValue, boolean finalChoice) {
                                ArtifactErrorPanel.performFix(selectedValue, artifactEditor);
                                return FINAL_CHOICE;
                            }
                        }).showUnderneathOf((Component)ArtifactErrorPanel.this.myFixButton);
                    }
                }
            }
        });
        this.clearError();
    }

    private static void performFix(ArtifactProblemQuickFix quickFix, ArtifactEditorImpl artifactEditor) {
        quickFix.performFix((ArtifactEditor)artifactEditor);
        artifactEditor.queueValidation();
    }

    public void showError(@NotNull String message, @NotNull List<ArtifactProblemQuickFix> quickFixes) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactErrorPanel.showError must not be null");
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactErrorPanel.showError must not be null");
        }
        this.myErrorLabel.setVisible(true);
        this.myErrorLabel.setText("<html>" + message + "</html>");
        this.myMainPanel.setVisible(true);
        this.myCurrentQuickFixes = quickFixes;
        this.myFixButton.setVisible(!quickFixes.isEmpty());
        if (!quickFixes.isEmpty()) {
            this.myFixButton.setText(quickFixes.size() == 1 ? ((ArtifactProblemQuickFix)ContainerUtil.getFirstItem(quickFixes, null)).getActionName() : "Fix...");
        }
    }

    public void clearError() {
        this.myMainPanel.setVisible(false);
        this.myErrorLabel.setVisible(false);
        this.myFixButton.setVisible(false);
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFixButton = jButton = new JButton();
        jButton.setText("Button");
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

