/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ArtifactSourceItem;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsSourceItemsProvider
extends PackagingSourceItemsProvider {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<? extends PackagingSourceItem> getSourceItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, @Nullable PackagingSourceItem parent) {
        List<Object> list;
        if (editorContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider.getSourceItems must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider.getSourceItems must not be null");
        }
        if (parent == null) {
            if (!ArtifactElementType.getAvailableArtifacts(editorContext, artifact).isEmpty()) {
                list = Collections.singletonList(new ArtifactsGroupSourceItem());
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider.getSourceItems must not return null");
                return list;
            }
        } else if (parent instanceof ArtifactsGroupSourceItem) {
            ArrayList items = new ArrayList();
            for (Artifact artifact2 : ArtifactElementType.getAvailableArtifacts(editorContext, artifact)) {
                items.add(new ArtifactSourceItem(artifact2));
            }
            list = items;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider.getSourceItems must not return null");
            return list;
        }
        if ((list = Collections.emptyList()) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider.getSourceItems must not return null");
    }

    private static class ArtifactsGroupSourceItem
    extends PackagingSourceItem {
        private ArtifactsGroupSourceItem() {
            super(false);
        }

        public boolean equals(Object obj) {
            return obj instanceof ArtifactsGroupSourceItem;
        }

        public int hashCode() {
            return 0;
        }

        public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
            if (context == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider$ArtifactsGroupSourceItem.createPresentation must not be null");
            }
            return new ArtifactsGroupPresentation();
        }

        @NotNull
        public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
            if (context == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider$ArtifactsGroupSourceItem.createElements must not be null");
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider$ArtifactsGroupSourceItem.createElements must not return null");
            }
            return list;
        }

        private static class ArtifactsGroupPresentation
        extends SourceItemPresentation {
            private ArtifactsGroupPresentation() {
            }

            public String getPresentableName() {
                return "Artifacts";
            }

            public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
                if (presentationData == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider$ArtifactsGroupSourceItem$ArtifactsGroupPresentation.render must not be null");
                }
                presentationData.setIcons(PlainArtifactType.ARTIFACT_ICON);
                presentationData.addText("Artifacts", mainAttributes);
            }

            public int getWeight() {
                return 200;
            }
        }
    }
}

