/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.vcs.actions.ActiveAnnotationGutter;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.AnnotationListener;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class AnnotationFieldGutter
implements ActiveAnnotationGutter {
    protected final FileAnnotation myAnnotation;
    private final Editor myEditor;
    protected final LineAnnotationAspect myAspect;
    private final TextAnnotationPresentation myPresentation;
    private final AnnotationListener myListener;
    private final boolean myIsGutterAction;
    private Map<String, Color> myColorScheme;
    private boolean myShowBg = true;

    AnnotationFieldGutter(FileAnnotation annotation, Editor editor, LineAnnotationAspect aspect, TextAnnotationPresentation presentation) {
        this.myAnnotation = annotation;
        this.myEditor = editor;
        this.myAspect = aspect;
        this.myPresentation = presentation;
        this.myIsGutterAction = this.myAspect instanceof EditorGutterAction;
        this.myListener = new AnnotationListener(){

            public void onAnnotationChanged() {
                AnnotationFieldGutter.this.myEditor.getGutter().closeAllAnnotations();
            }
        };
        this.myAnnotation.addListener(this.myListener);
    }

    public boolean isGutterAction() {
        return this.myIsGutterAction;
    }

    public String getLineText(int line, Editor editor) {
        return this.myAspect.getValue(line);
    }

    @Nullable
    public String getToolTip(int line, Editor editor) {
        return XmlStringUtil.escapeString((String)this.myAnnotation.getToolTip(line));
    }

    public void doAction(int line) {
        if (this.myIsGutterAction) {
            ((EditorGutterAction)this.myAspect).doAction(line);
        }
    }

    public Cursor getCursor(int line) {
        if (this.myIsGutterAction) {
            return ((EditorGutterAction)this.myAspect).getCursor(line);
        }
        return Cursor.getDefaultCursor();
    }

    public EditorFontType getStyle(int line, Editor editor) {
        return this.myPresentation.getFontType(line);
    }

    @Nullable
    public ColorKey getColor(int line, Editor editor) {
        return this.myPresentation.getColor(line);
    }

    public List<AnAction> getPopupActions(Editor editor) {
        return this.myPresentation.getActions();
    }

    public void gutterClosed() {
        this.myAnnotation.removeListener(this.myListener);
        this.myAnnotation.dispose();
        Collection gutters = (Collection)this.myEditor.getUserData(AnnotateToggleAction.KEY_IN_EDITOR);
        if (gutters != null) {
            gutters.remove(this);
        }
    }

    @Nullable
    public Color getBgColor(int line, Editor editor) {
        if (this.myColorScheme == null || !this.myShowBg) {
            return null;
        }
        String s = this.getLineText(line, editor);
        if (s == null) {
            return null;
        }
        Color bg = this.myColorScheme.get(s);
        return bg == null ? this.findBgColor(s) : bg;
    }

    @Nullable
    private Color findBgColor(String s) {
        if (this.myColorScheme != null) {
            for (String key : this.myColorScheme.keySet()) {
                if (!key.startsWith(s)) continue;
                return this.myColorScheme.get(key);
            }
        }
        return null;
    }

    public void setAspectValueToBgColorMap(Map<String, Color> colorScheme) {
        this.myColorScheme = colorScheme;
    }

    public void setShowBg(boolean show) {
        this.myShowBg = show;
    }
}

