/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsAppendableDirtyScope;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class VcsDirtyScopeImpl
extends VcsAppendableDirtyScope {
    private final Set<FilePath> myDirtyFiles = new THashSet();
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyDirectoriesRecursively = new HashMap<VirtualFile, THashSet<FilePath>>();
    private final Set<VirtualFile> myAffectedContentRoots = new THashSet();
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final AbstractVcs myVcs;

    public VcsDirtyScopeImpl(AbstractVcs vcs, Project project) {
        this.myProject = project;
        this.myVcs = vcs;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
    }

    public Collection<VirtualFile> getAffectedContentRoots() {
        return this.myAffectedContentRoots;
    }

    public Project getProject() {
        return this.myProject;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Set<FilePath> getDirtyFiles() {
        THashSet result = new THashSet(this.myDirtyFiles);
        for (FilePath filePath : this.myDirtyFiles) {
            VirtualFile vFile = filePath.getVirtualFile();
            if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
            for (VirtualFile child : vFile.getChildren()) {
                result.add((Object)new FilePathImpl(child));
            }
        }
        return result;
    }

    public Set<FilePath> getDirtyFilesNoExpand() {
        return new THashSet(this.myDirtyFiles);
    }

    public Set<FilePath> getRecursivelyDirtyDirectories() {
        THashSet result = new THashSet();
        for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            result.addAll(dirsByRoot);
        }
        return result;
    }

    public boolean isRecursivelyDirty(VirtualFile vf) {
        for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            for (FilePath dir : dirsByRoot) {
                VirtualFile dirVf = dir.getVirtualFile();
                if (dirVf == null || !VfsUtil.isAncestor((VirtualFile)dirVf, (VirtualFile)vf, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public void addDirtyDirRecursively(final FilePath newcomer) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VcsDirtyScopeImpl vcsDirtyScopeImpl = VcsDirtyScopeImpl.this;
                synchronized (vcsDirtyScopeImpl) {
                    VirtualFile vcsRoot = VcsDirtyScopeImpl.this.myVcsManager.getVcsRootFor(newcomer);
                    if (vcsRoot == null) {
                        return;
                    }
                    VcsDirtyScopeImpl.this.myAffectedContentRoots.add(vcsRoot);
                    Iterator it = VcsDirtyScopeImpl.this.myDirtyFiles.iterator();
                    while (it.hasNext()) {
                        FilePath oldBoy = (FilePath)it.next();
                        if (!oldBoy.isUnder(newcomer, false)) continue;
                        it.remove();
                    }
                    THashSet dirsByRoot = (THashSet)VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.get(vcsRoot);
                    if (dirsByRoot == null) {
                        dirsByRoot = new THashSet();
                        VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
                    } else {
                        Iterator it2 = dirsByRoot.iterator();
                        while (it2.hasNext()) {
                            FilePath oldBoy = (FilePath)it2.next();
                            if (newcomer.isUnder(oldBoy, false)) {
                                return;
                            }
                            if (!oldBoy.isUnder(newcomer, false)) continue;
                            it2.remove();
                        }
                    }
                    dirsByRoot.add((Object)newcomer);
                }
            }
        });
    }

    public void addDirtyFile(final FilePath newcomer) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VcsDirtyScopeImpl vcsDirtyScopeImpl = VcsDirtyScopeImpl.this;
                synchronized (vcsDirtyScopeImpl) {
                    VirtualFile parent;
                    VirtualFile vcsRoot = VcsDirtyScopeImpl.this.myVcsManager.getVcsRootFor(newcomer);
                    VcsDirtyScopeImpl.this.myAffectedContentRoots.add(vcsRoot);
                    THashSet dirsByRoot = (THashSet)VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.get(vcsRoot);
                    if (dirsByRoot != null) {
                        for (FilePath oldBoy : dirsByRoot) {
                            if (!newcomer.isUnder(oldBoy, false)) continue;
                            return;
                        }
                    }
                    if (newcomer.isDirectory()) {
                        ArrayList files = new ArrayList(VcsDirtyScopeImpl.this.myDirtyFiles);
                        for (FilePath oldBoy : files) {
                            if (oldBoy.isDirectory() || oldBoy.getVirtualFileParent() != newcomer.getVirtualFile()) continue;
                            VcsDirtyScopeImpl.this.myDirtyFiles.remove(oldBoy);
                        }
                    } else if (VcsDirtyScopeImpl.this.myDirtyFiles.size() > 0 && (parent = newcomer.getVirtualFileParent()) != null && VcsDirtyScopeImpl.this.myDirtyFiles.contains(new FilePathImpl(parent))) {
                        return;
                    }
                    VcsDirtyScopeImpl.this.myDirtyFiles.add(newcomer);
                }
            }
        });
    }

    public void iterate(Processor<FilePath> iterator) {
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot) {
                VirtualFile vFile = dir.getVirtualFile();
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVcsRoot(vFile, iterator);
            }
        }
        for (FilePath file : this.myDirtyFiles) {
            iterator.process((Object)file);
            VirtualFile vFile = file.getVirtualFile();
            if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
            for (VirtualFile child : vFile.getChildren()) {
                iterator.process((Object)new FilePathImpl(child));
            }
        }
    }

    public boolean belongsTo(final FilePath path) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean compute() {
                VcsDirtyScopeImpl vcsDirtyScopeImpl = VcsDirtyScopeImpl.this;
                synchronized (vcsDirtyScopeImpl) {
                    if (VcsDirtyScopeImpl.this.myProject.isDisposed()) {
                        return Boolean.FALSE;
                    }
                    if (VcsDirtyScopeImpl.this.myVcsManager.getVcsFor(path) != VcsDirtyScopeImpl.this.myVcs) {
                        return Boolean.FALSE;
                    }
                    VirtualFile vcsRoot = VcsDirtyScopeImpl.this.myVcsManager.getVcsRootFor(path);
                    if (vcsRoot != null) {
                        for (VirtualFile contentRoot : VcsDirtyScopeImpl.this.myAffectedContentRoots) {
                            THashSet dirsByRoot;
                            if (!VfsUtil.isAncestor((VirtualFile)contentRoot, (VirtualFile)vcsRoot, (boolean)false) || (dirsByRoot = (THashSet)VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.get(contentRoot)) == null) continue;
                            for (FilePath filePath : dirsByRoot) {
                                if (!path.isUnder(filePath, false)) continue;
                                return Boolean.TRUE;
                            }
                        }
                    }
                    if (VcsDirtyScopeImpl.this.myDirtyFiles.size() > 0) {
                        VirtualFile vParent = path.getVirtualFileParent();
                        FilePathImpl parent = vParent != null && vParent.isValid() ? new FilePathImpl(vParent) : FilePathImpl.create(path.getIOFile().getParentFile());
                        if (VcsDirtyScopeImpl.this.myDirtyFiles.contains(parent) || VcsDirtyScopeImpl.this.myDirtyFiles.contains(path)) {
                            return Boolean.TRUE;
                        }
                    }
                    return Boolean.FALSE;
                }
            }
        });
    }

    @NonNls
    public String toString() {
        StringBuilder result = new StringBuilder("VcsDirtyScope[");
        if (this.myDirtyFiles.size() > 0) {
            result.append(" files=");
            for (FilePath filePath : this.myDirtyFiles) {
                result.append(filePath).append(" ");
            }
        }
        if (this.myDirtyDirectoriesRecursively.size() > 0) {
            result.append(" dirs=");
            for (THashSet tHashSet : this.myDirtyDirectoriesRecursively.values()) {
                for (FilePath file : tHashSet) {
                    result.append(file).append(" ");
                }
            }
        }
        result.append("]");
        return result.toString();
    }
}

