/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;

public class LoadedChangeFilter {
    private final List<File> myRoots;

    public LoadedChangeFilter(List<File> roots) {
        this.myRoots = roots;
    }

    public boolean ok(CommittedChangeList list) {
        Collection changes = list.getChanges();
        for (Change change : changes) {
            FilePath path;
            if (change.getBeforeRevision() != null && this.ok((path = change.getBeforeRevision().getFile()).getIOFile())) {
                return true;
            }
            if (change.getAfterRevision() == null || change.getBeforeRevision() != null && change.getAfterRevision().getFile().equals(change.getBeforeRevision().getFile()) || !this.ok((path = change.getAfterRevision().getFile()).getIOFile())) continue;
            return true;
        }
        return false;
    }

    private boolean ok(File vf) {
        for (File root : this.myRoots) {
            if (!VfsUtil.isAncestor((File)root, (File)vf, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

