/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.OpenRepositoryVersionAction;
import com.intellij.openapi.vcs.changes.actions.RevertSelectedChangesAction;
import com.intellij.openapi.vcs.changes.actions.ShowDiffWithLocalAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public class RepositoryChangesBrowser
extends ChangesBrowser
implements DataProvider {
    private CommittedChangesBrowserUseCase myUseCase;

    public RepositoryChangesBrowser(Project project, List<CommittedChangeList> changeLists) {
        super(project, changeLists, Collections.<Change>emptyList(), null, false, false, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES);
    }

    public RepositoryChangesBrowser(Project project, List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection) {
        super(project, changeLists, changes, initialListSelection, false, false, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES);
    }

    @Override
    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        AnAction[] actions;
        super.buildToolBar(toolBarGroup);
        toolBarGroup.add((AnAction)new ShowDiffWithLocalAction());
        MyEditSourceAction editSourceAction = new MyEditSourceAction();
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        toolBarGroup.add((AnAction)editSourceAction);
        OpenRepositoryVersionAction action = new OpenRepositoryVersionAction();
        toolBarGroup.add((AnAction)action);
        RevertSelectedChangesAction revertSelectedChangesAction = new RevertSelectedChangesAction();
        toolBarGroup.add((AnAction)revertSelectedChangesAction);
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("RepositoryChangesBrowserToolbar");
        for (AnAction anAction : actions = group.getChildren(null)) {
            toolBarGroup.add(anAction);
        }
    }

    public void setUseCase(CommittedChangesBrowserUseCase useCase) {
        this.myUseCase = useCase;
    }

    public Object getData(@NonNls String dataId) {
        if (CommittedChangesBrowserUseCase.DATA_KEY.is(dataId)) {
            return this.myUseCase;
        }
        if (VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            List<Change> list = this.myViewer.getSelectedChanges();
            return list.toArray(new Change[list.size()]);
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            Change[] changeArray;
            Change highestSelection = (Change)this.myViewer.getHighestLeadSelection();
            if (highestSelection == null) {
                changeArray = new Change[]{};
            } else {
                Change[] changeArray2 = new Change[1];
                changeArray = changeArray2;
                changeArray2[0] = highestSelection;
            }
            return changeArray;
        }
        TypeSafeDataProviderAdapter adapter = new TypeSafeDataProviderAdapter(this);
        return adapter.getData(dataId);
    }

    private class MyEditSourceAction
    extends EditSourceAction {
        private final Icon myEditSourceIcon = IconLoader.getIcon((String)"/actions/editSource.png");

        @Override
        public void update(AnActionEvent event) {
            super.update(event);
            event.getPresentation().setIcon(this.myEditSourceIcon);
            event.getPresentation().setText("Edit Source");
            if (!ModalityState.NON_MODAL.equals(ModalityState.current()) || CommittedChangesBrowserUseCase.IN_AIR.equals(CommittedChangesBrowserUseCase.DATA_KEY.getData(event.getDataContext()))) {
                event.getPresentation().setEnabled(false);
            }
        }

        @Override
        protected Navigatable[] getNavigatables(DataContext dataContext) {
            Change[] changes = (Change[])VcsDataKeys.SELECTED_CHANGES.getData(dataContext);
            if (changes != null) {
                List<Change> changeCollection = Arrays.asList(changes);
                return ChangesUtil.getNavigatableArray((Project)RepositoryChangesBrowser.this.myProject, (VirtualFile[])ChangesUtil.getFilesFromChanges(changeCollection));
            }
            return null;
        }
    }
}

