/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.Icons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesTreeList<T>
extends JPanel {
    private final Tree myTree;
    private final JList myList;
    private final JScrollPane myTreeScrollPane;
    private final JScrollPane myListScrollPane;
    protected final Project myProject;
    private final boolean myShowCheckboxes;
    private final boolean myHighlightProblems;
    private boolean myShowFlatten;
    private final Collection<T> myIncludedChanges;
    private Runnable myDoubleClickHandler = EmptyRunnable.getInstance();
    @NonNls
    private static final String TREE_CARD = "Tree";
    @NonNls
    private static final String LIST_CARD = "List";
    @NonNls
    private static final String ROOT = "root";
    private final CardLayout myCards;
    @NonNls
    private static final String FLATTEN_OPTION_KEY = "ChangesBrowser.SHOW_FLATTEN";
    private final Runnable myInclusionListener;
    @Nullable
    private ChangeNodeDecorator myChangeDecorator;

    public ChangesTreeList(Project project, Collection<T> initiallyIncluded, boolean showCheckboxes, boolean highlightProblems, @Nullable Runnable inclusionListener, @Nullable ChangeNodeDecorator decorator) {
        this.myProject = project;
        this.myShowCheckboxes = showCheckboxes;
        this.myHighlightProblems = highlightProblems;
        this.myInclusionListener = inclusionListener;
        this.myChangeDecorator = decorator;
        this.myIncludedChanges = new HashSet<T>(initiallyIncluded);
        this.myCards = new CardLayout();
        this.setLayout(this.myCards);
        final int checkboxWidth = new JCheckBox().getPreferredSize().width;
        this.myTree = new Tree(ChangesBrowserNode.create(this.myProject, ROOT)){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension size = super.getPreferredScrollableViewportSize();
                size = new Dimension(size.width + 10, size.height);
                return size;
            }

            protected void processMouseEvent(MouseEvent e) {
                int row;
                if (e.getID() == 501 && (row = ChangesTreeList.this.myTree.getRowForLocation(e.getX(), e.getY())) >= 0) {
                    Rectangle baseRect = ChangesTreeList.this.myTree.getRowBounds(row);
                    baseRect.setSize(checkboxWidth, baseRect.height);
                    if (baseRect.contains(e.getPoint())) {
                        ChangesTreeList.this.myTree.setSelectionRow(row);
                        ChangesTreeList.this.toggleSelection();
                    }
                }
                super.processMouseEvent(e);
            }

            public int getToggleClickCount() {
                return -1;
            }
        };
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)new MyTreeCellRenderer());
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                ChangesBrowserNode node = (ChangesBrowserNode)o.getLastPathComponent();
                return node.getTextPresentation();
            }
        });
        this.myList = new JList(new DefaultListModel());
        this.myList.setVisibleRowCount(10);
        this.myListScrollPane = new JScrollPane(this.myList);
        this.add((Component)this.myListScrollPane, LIST_CARD);
        this.myTreeScrollPane = new JScrollPane((Component)this.myTree);
        this.add((Component)this.myTreeScrollPane, TREE_CARD);
        new ListSpeedSearch(this.myList){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof Change) {
                    return ChangesUtil.getFilePath((Change)((Change)element)).getName();
                }
                return super.getElementText(element);
            }
        };
        this.myList.setCellRenderer(new MyListCellRenderer());
        new MyToggleSelectionAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), this);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangesTreeList.this.includeSelection();
            }
        }, KeyStroke.getKeyStroke(155, 0), 1);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangesTreeList.this.excludeSelection();
            }
        }, KeyStroke.getKeyStroke(127, 0), 1);
        this.myList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int idx = ChangesTreeList.this.myList.locationToIndex(e.getPoint());
                if (idx >= 0) {
                    Rectangle baseRect = ChangesTreeList.this.myList.getCellBounds(idx, idx);
                    baseRect.setSize(checkboxWidth, baseRect.height);
                    if (baseRect.contains(e.getPoint())) {
                        ChangesTreeList.this.toggleSelection();
                        e.consume();
                    } else if (e.getClickCount() == 2) {
                        ChangesTreeList.this.myDoubleClickHandler.run();
                        e.consume();
                    }
                }
            }
        });
        this.myTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = ChangesTreeList.this.myTree.getRowForLocation(e.getPoint().x, e.getPoint().y);
                if (row >= 0) {
                    Rectangle baseRect = ChangesTreeList.this.myTree.getRowBounds(row);
                    baseRect.setSize(checkboxWidth, baseRect.height);
                    if (!baseRect.contains(e.getPoint()) && e.getClickCount() == 2) {
                        ChangesTreeList.this.myDoubleClickHandler.run();
                        e.consume();
                    }
                }
            }
        });
        this.setShowFlatten(PropertiesComponent.getInstance((Project)this.myProject).isTrueValue(FLATTEN_OPTION_KEY));
    }

    public void setChangeDecorator(@Nullable ChangeNodeDecorator changeDecorator) {
        this.myChangeDecorator = changeDecorator;
    }

    public void setDoubleClickHandler(Runnable doubleClickHandler) {
        this.myDoubleClickHandler = doubleClickHandler;
    }

    public void installPopupHandler(ActionGroup group) {
        PopupHandler.installUnknownPopupHandler((JComponent)this.myList, (ActionGroup)group, (ActionManager)ActionManager.getInstance());
        PopupHandler.installUnknownPopupHandler((JComponent)this.myTree, (ActionGroup)group, (ActionManager)ActionManager.getInstance());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten;
    }

    public void setScrollPaneBorder(Border border) {
        this.myListScrollPane.setBorder(border);
        this.myTreeScrollPane.setBorder(border);
    }

    public void setShowFlatten(boolean showFlatten) {
        List<T> wasSelected = this.getSelectedChanges();
        this.myShowFlatten = showFlatten;
        this.myCards.show(this, this.myShowFlatten ? LIST_CARD : TREE_CARD);
        this.select(wasSelected);
        if (this.myList.hasFocus() || this.myTree.hasFocus()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChangesTreeList.this.requestFocus();
                }
            });
        }
    }

    @Override
    public void requestFocus() {
        if (this.myShowFlatten) {
            this.myList.requestFocus();
        } else {
            this.myTree.requestFocus();
        }
    }

    public void setChangesToDisplay(final List<T> changes) {
        DefaultListModel listModel = (DefaultListModel)this.myList.getModel();
        ArrayList<T> sortedChanges = new ArrayList<T>(changes);
        Collections.sort(sortedChanges, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return TreeModelBuilder.getPathForObject(o1).getName().compareToIgnoreCase(TreeModelBuilder.getPathForObject(o2).getName());
            }
        });
        listModel.removeAllElements();
        for (Object change : sortedChanges) {
            listModel.addElement(change);
        }
        final DefaultTreeModel model = this.buildTreeModel(changes, this.myChangeDecorator);
        this.myTree.setModel((TreeModel)model);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ChangesTreeList.this.myProject.isDisposed()) {
                    return;
                }
                TreeUtil.expandAll((JTree)ChangesTreeList.this.myTree);
                if (ChangesTreeList.this.myIncludedChanges.size() > 0) {
                    int listSelection = 0;
                    int count = 0;
                    for (Object change : changes) {
                        if (ChangesTreeList.this.myIncludedChanges.contains(change)) {
                            listSelection = count;
                            break;
                        }
                        ++count;
                    }
                    ChangesBrowserNode root = (ChangesBrowserNode)model.getRoot();
                    Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
                    while (enumeration.hasMoreElements()) {
                        ChangesBrowserNode node = (ChangesBrowserNode)enumeration.nextElement();
                        CheckboxTreeBase.NodeState state = ChangesTreeList.this.getNodeStatus(node);
                        if (node == root || state != CheckboxTreeBase.NodeState.CLEAR) continue;
                        ChangesTreeList.this.myTree.collapsePath(new TreePath(node.getPath()));
                    }
                    enumeration = root.depthFirstEnumeration();
                    int scrollRow = 0;
                    while (enumeration.hasMoreElements()) {
                        ChangesBrowserNode node = (ChangesBrowserNode)enumeration.nextElement();
                        CheckboxTreeBase.NodeState state = ChangesTreeList.this.getNodeStatus(node);
                        if (state != CheckboxTreeBase.NodeState.FULL || !node.isLeaf()) continue;
                        scrollRow = ChangesTreeList.this.myTree.getRowForPath(new TreePath(node.getPath()));
                        break;
                    }
                    if (changes.size() > 0) {
                        ChangesTreeList.this.myList.setSelectedIndex(listSelection);
                        ChangesTreeList.this.myList.ensureIndexIsVisible(listSelection);
                        ChangesTreeList.this.myTree.setSelectionRow(scrollRow);
                        TreeUtil.showRowCentered((JTree)ChangesTreeList.this.myTree, (int)scrollRow, (boolean)false);
                    }
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected abstract DefaultTreeModel buildTreeModel(List<T> var1, ChangeNodeDecorator var2);

    private void toggleSelection() {
        boolean hasExcluded = false;
        for (T value : this.getSelectedChanges()) {
            if (this.myIncludedChanges.contains(value)) continue;
            hasExcluded = true;
        }
        if (hasExcluded) {
            this.includeSelection();
        } else {
            this.excludeSelection();
        }
        this.repaint();
    }

    private void includeSelection() {
        for (T change : this.getSelectedChanges()) {
            this.myIncludedChanges.add(change);
        }
        this.notifyInclusionListener();
        this.repaint();
    }

    private void excludeSelection() {
        for (T change : this.getSelectedChanges()) {
            this.myIncludedChanges.remove(change);
        }
        this.notifyInclusionListener();
        this.repaint();
    }

    public int getSelectionCount() {
        if (this.myShowFlatten) {
            return this.myList.getSelectedIndices().length;
        }
        return this.myTree.getSelectionCount();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<T> getSelectedChanges() {
        ArrayList<Object> arrayList;
        if (this.myShowFlatten) {
            Object[] o = this.myList.getSelectedValues();
            ArrayList<Object> changes = new ArrayList<Object>();
            for (Object anO : o) {
                changes.add(anO);
            }
            arrayList = changes;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ui/ChangesTreeList.getSelectedChanges must not return null");
            return arrayList;
        }
        ArrayList<T> changes = new ArrayList<T>();
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                ChangesBrowserNode node = (ChangesBrowserNode)path.getLastPathComponent();
                changes.addAll(this.getSelectedObjects(node));
            }
        }
        if ((arrayList = changes) != null) return arrayList;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ui/ChangesTreeList.getSelectedChanges must not return null");
    }

    protected abstract List<T> getSelectedObjects(ChangesBrowserNode<T> var1);

    @Nullable
    protected abstract T getLeadSelectedObject(ChangesBrowserNode var1);

    @Nullable
    public T getHighestLeadSelection() {
        if (this.myShowFlatten) {
            int index = this.myList.getLeadSelectionIndex();
            ListModel listModel = this.myList.getModel();
            if (index < 0 || index >= listModel.getSize()) {
                return null;
            }
            return (T)listModel.getElementAt(index);
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return this.getLeadSelectedObject((ChangesBrowserNode)path.getLastPathComponent());
    }

    @Nullable
    public T getLeadSelection() {
        if (this.myShowFlatten) {
            int index = this.myList.getLeadSelectionIndex();
            ListModel listModel = this.myList.getModel();
            if (index < 0 || index >= listModel.getSize()) {
                return null;
            }
            return (T)listModel.getElementAt(index);
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        List<T> changes = this.getSelectedObjects((ChangesBrowserNode)path.getLastPathComponent());
        return changes.size() > 0 ? (T)changes.get(0) : null;
    }

    private void notifyInclusionListener() {
        if (this.myInclusionListener != null) {
            this.myInclusionListener.run();
        }
    }

    public void setIncludedChanges(Collection<T> changes) {
        this.myIncludedChanges.clear();
        this.myIncludedChanges.addAll(changes);
        this.myTree.repaint();
        this.myList.repaint();
    }

    public void includeChange(T change) {
        this.myIncludedChanges.add(change);
        this.notifyInclusionListener();
        this.myTree.repaint();
        this.myList.repaint();
    }

    public void includeChanges(Collection<T> changes) {
        this.myIncludedChanges.addAll(changes);
        this.notifyInclusionListener();
        this.myTree.repaint();
        this.myList.repaint();
    }

    public void excludeChange(T change) {
        this.myIncludedChanges.remove(change);
        this.notifyInclusionListener();
        this.myTree.repaint();
        this.myList.repaint();
    }

    public void excludeChanges(Collection<T> changes) {
        this.myIncludedChanges.removeAll(changes);
        this.notifyInclusionListener();
        this.myTree.repaint();
        this.myList.repaint();
    }

    public boolean isIncluded(T change) {
        return this.myIncludedChanges.contains(change);
    }

    public Collection<T> getIncludedChanges() {
        return this.myIncludedChanges;
    }

    public void expandAll() {
        TreeUtil.expandAll((JTree)this.myTree);
    }

    public AnAction[] getTreeActions() {
        ToggleShowDirectoriesAction directoriesAction = new ToggleShowDirectoriesAction();
        ExpandAllAction expandAllAction = new ExpandAllAction((JTree)this.myTree){

            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(!ChangesTreeList.this.myShowFlatten);
            }
        };
        CollapseAllAction collapseAllAction = new CollapseAllAction((JTree)this.myTree){

            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(!ChangesTreeList.this.myShowFlatten);
            }
        };
        SelectAllAction selectAllAction = new SelectAllAction();
        AnAction[] actions = new AnAction[]{directoriesAction, expandAllAction, collapseAllAction, selectAllAction};
        directoriesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(80, SystemInfo.isMac ? 256 : 128)), this);
        expandAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("ExpandAll")), (JComponent)this.myTree);
        collapseAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CollapseAll")), (JComponent)this.myTree);
        selectAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(65, SystemInfo.isMac ? 256 : 128)), this);
        return actions;
    }

    private CheckboxTreeBase.NodeState getNodeStatus(ChangesBrowserNode node) {
        boolean hasIncluded = false;
        boolean hasExcluded = false;
        for (T change : this.getSelectedObjects(node)) {
            if (this.myIncludedChanges.contains(change)) {
                hasIncluded = true;
                continue;
            }
            hasExcluded = true;
        }
        if (hasIncluded && hasExcluded) {
            return CheckboxTreeBase.NodeState.PARTIAL;
        }
        if (hasIncluded) {
            return CheckboxTreeBase.NodeState.FULL;
        }
        return CheckboxTreeBase.NodeState.CLEAR;
    }

    public void select(final List<T> changes) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        final ArrayList treeSelection = new ArrayList(changes.size());
        TreeUtil.traverse((TreeNode)root, (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                Object change = ((DefaultMutableTreeNode)node).getUserObject();
                if (changes.contains(change)) {
                    treeSelection.add(new TreePath(((DefaultMutableTreeNode)node).getPath()));
                }
                return true;
            }
        });
        this.myTree.setSelectionPaths(treeSelection.toArray(new TreePath[treeSelection.size()]));
        ListModel model = this.myList.getModel();
        int size = model.getSize();
        ArrayList<Integer> listSelection = new ArrayList<Integer>(changes.size());
        for (int i = 0; i < size; ++i) {
            Object el = model.getElementAt(i);
            if (!changes.contains(el)) continue;
            listSelection.add(i);
        }
        this.myList.setSelectedIndices(ChangesTreeList.int2int(listSelection));
    }

    private static int[] int2int(List<Integer> treeSelection) {
        int[] toPass = new int[treeSelection.size()];
        int i = 0;
        for (Integer integer : treeSelection) {
            toPass[i] = integer;
            ++i;
        }
        return toPass;
    }

    private class SelectAllAction
    extends AnAction {
        private SelectAllAction() {
            super("Select All", "Select all items", IconLoader.getIcon((String)"/actions/selectall.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            if (ChangesTreeList.this.myShowFlatten) {
                int count = ChangesTreeList.this.myList.getModel().getSize();
                if (count > 0) {
                    ChangesTreeList.this.myList.setSelectionInterval(0, count - 1);
                }
            } else {
                int countTree = ChangesTreeList.this.myTree.getRowCount();
                if (countTree > 0) {
                    ChangesTreeList.this.myTree.setSelectionInterval(0, countTree - 1);
                }
            }
        }
    }

    public class ToggleShowDirectoriesAction
    extends ToggleAction {
        public ToggleShowDirectoriesAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), Icons.DIRECTORY_CLOSED_ICON);
        }

        public boolean isSelected(AnActionEvent e) {
            return !PropertiesComponent.getInstance((Project)ChangesTreeList.this.myProject).isTrueValue(ChangesTreeList.FLATTEN_OPTION_KEY);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            PropertiesComponent.getInstance((Project)ChangesTreeList.this.myProject).setValue(ChangesTreeList.FLATTEN_OPTION_KEY, String.valueOf(!state));
            ChangesTreeList.this.setShowFlatten(!state);
        }
    }

    private class MyToggleSelectionAction
    extends AnAction {
        private MyToggleSelectionAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            ChangesTreeList.this.toggleSelection();
        }
    }

    private class MyListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private final ColoredListCellRenderer myTextRenderer;
        public final JCheckBox myCheckbox;

        public MyListCellRenderer() {
            super(new BorderLayout());
            this.myCheckbox = new JCheckBox();
            this.myTextRenderer = new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    VirtualFile virtualFile;
                    FilePath path = TreeModelBuilder.getPathForObject(value);
                    if (path.isDirectory()) {
                        this.setIcon(Icons.DIRECTORY_CLOSED_ICON);
                    } else {
                        this.setIcon(path.getFileType().getIcon());
                    }
                    FileStatus fileStatus = value instanceof Change ? ((Change)value).getFileStatus() : ((virtualFile = path.getVirtualFile()) != null ? FileStatusManager.getInstance((Project)ChangesTreeList.this.myProject).getStatus(virtualFile) : FileStatus.NOT_CHANGED);
                    this.append(path.getName(), new SimpleTextAttributes(0, fileStatus.getColor(), null));
                    boolean applyChangeDecorator = value instanceof Change && ChangesTreeList.this.myChangeDecorator != null;
                    File parentFile = path.getIOFile().getParentFile();
                    if (parentFile != null) {
                        String parentPath = parentFile.getPath();
                        List<Pair<String, ChangeNodeDecorator.Stress>> parts = null;
                        if (applyChangeDecorator) {
                            parts = ChangesTreeList.this.myChangeDecorator.stressPartsOfFileName((Change)value, parentPath);
                        }
                        if (parts == null) {
                            parts = Collections.singletonList(new Pair((Object)parentPath, (Object)ChangeNodeDecorator.Stress.PLAIN));
                        }
                        this.append(" (");
                        for (Pair pair : parts) {
                            this.append((String)pair.getFirst(), ((ChangeNodeDecorator.Stress)((Object)pair.getSecond())).derive(SimpleTextAttributes.GRAYED_ATTRIBUTES));
                        }
                        this.append(")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    if (applyChangeDecorator) {
                        ChangesTreeList.this.myChangeDecorator.decorate((Change)value, (SimpleColoredComponent)this, ChangesTreeList.this.isShowFlatten());
                    }
                }
            };
            this.myCheckbox.setBackground(null);
            this.setBackground(null);
            if (ChangesTreeList.this.myShowCheckboxes) {
                this.add((Component)this.myCheckbox, "West");
            }
            this.add((Component)this.myTextRenderer, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.myTextRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (ChangesTreeList.this.myShowCheckboxes) {
                this.myCheckbox.setSelected(ChangesTreeList.this.myIncludedChanges.contains(value));
                return this;
            }
            return this.myTextRenderer;
        }
    }

    private class MyTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final ChangesBrowserNodeRenderer myTextRenderer;
        private final JCheckBox myCheckBox;

        public MyTreeCellRenderer() {
            super(new BorderLayout());
            this.myCheckBox = new JCheckBox();
            this.myTextRenderer = new ChangesBrowserNodeRenderer(ChangesTreeList.this.myProject, false, ChangesTreeList.this.myHighlightProblems);
            this.myCheckBox.setBackground(null);
            this.setBackground(null);
            if (ChangesTreeList.this.myShowCheckboxes) {
                this.add((Component)this.myCheckBox, "West");
            }
            this.add((Component)((Object)this.myTextRenderer), "Center");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.myTextRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (ChangesTreeList.this.myShowCheckboxes) {
                ChangesBrowserNode node = (ChangesBrowserNode)value;
                CheckboxTreeBase.NodeState state = ChangesTreeList.this.getNodeStatus(node);
                this.myCheckBox.setSelected(state != CheckboxTreeBase.NodeState.CLEAR);
                this.myCheckBox.setEnabled(state != CheckboxTreeBase.NodeState.PARTIAL);
                this.revalidate();
                return this;
            }
            return this.myTextRenderer;
        }
    }
}

