/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.MultipleChangeListBrowser;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class RollbackChangesDialog
extends DialogWrapper {
    private final Project myProject;
    private final boolean myRefreshSynchronously;
    private final Runnable myAfterVcsRefreshInAwt;
    private final MultipleChangeListBrowser myBrowser;
    @Nullable
    private JCheckBox myDeleteLocallyAddedFiles;

    public static void rollbackChanges(Project project, Collection<Change> changes) {
        RollbackChangesDialog.rollbackChanges(project, changes, true);
    }

    public static void rollbackChanges(Project project, Collection<Change> changes, boolean refreshSynchronously) {
        RollbackChangesDialog.rollbackChanges(project, changes, refreshSynchronously, null);
    }

    public static void rollbackChanges(Project project, Collection<Change> changes, boolean refreshSynchronously, Runnable afterVcsRefreshInAwt) {
        ChangeListManagerEx manager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
        if (changes.isEmpty()) {
            Messages.showWarningDialog((Project)project, (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.title", (Object[])new Object[0]));
            return;
        }
        ArrayList<Change> validChanges = new ArrayList<Change>();
        THashSet lists = new THashSet();
        lists.addAll(manager.getInvolvedListsFilterChanges(changes, validChanges));
        RollbackChangesDialog.rollback(project, new ArrayList<LocalChangeList>((Collection<LocalChangeList>)lists), validChanges, refreshSynchronously, afterVcsRefreshInAwt);
    }

    public static void rollback(Project project, List<LocalChangeList> changeLists, List<Change> changes, boolean refreshSynchronously, Runnable afterVcsRefreshInAwt) {
        new RollbackChangesDialog(project, changeLists, changes, refreshSynchronously, afterVcsRefreshInAwt).show();
    }

    public RollbackChangesDialog(Project project, List<LocalChangeList> changeLists, List<Change> changes, boolean refreshSynchronously, Runnable afterVcsRefreshInAwt) {
        super(project, true);
        AbstractVcs vcs;
        RollbackEnvironment rollbackEnvironment;
        this.myProject = project;
        this.myRefreshSynchronously = refreshSynchronously;
        this.myAfterVcsRefreshInAwt = afterVcsRefreshInAwt;
        this.myBrowser = new MultipleChangeListBrowser(project, (List<? extends ChangeList>)changeLists, changes, null, true, true, null, null);
        this.myBrowser.setToggleActionTitle("Include in rollback");
        this.setOKButtonText(VcsBundle.message((String)"changes.action.rollback.text", (Object[])new Object[0]));
        this.setTitle(VcsBundle.message((String)"changes.action.rollback.title", (Object[])new Object[0]));
        HashSet<AbstractVcs> affectedVcs = new HashSet<AbstractVcs>();
        for (Change c : changes) {
            AbstractVcs vcs2 = ChangesUtil.getVcsForChange((Change)c, (Project)project);
            if (vcs2 == null) continue;
            affectedVcs.add(vcs2);
        }
        if (affectedVcs.size() == 1 && (rollbackEnvironment = (vcs = (AbstractVcs)affectedVcs.toArray()[0]).getRollbackEnvironment()) != null) {
            String rollbackOperationName = rollbackEnvironment.getRollbackOperationName();
            int pos = rollbackOperationName.indexOf(27);
            if (pos >= 0) {
                this.setOKButtonMnemonic(Character.toUpperCase(rollbackOperationName.charAt(pos + 1)));
                rollbackOperationName = rollbackOperationName.replace(Character.toString('\u001b'), "");
            }
            this.setTitle(VcsBundle.message((String)"changes.action.rollback.custom.title", (Object[])new Object[]{rollbackOperationName}).replace("_", ""));
            this.setOKButtonText(rollbackOperationName);
        }
        for (Change c : changes) {
            if (c.getType() != Change.Type.NEW) continue;
            this.myDeleteLocallyAddedFiles = new JCheckBox(VcsBundle.message((String)"changes.checkbox.delete.locally.added.files", (Object[])new Object[0]));
            break;
        }
        this.init();
    }

    protected void dispose() {
        super.dispose();
        this.myBrowser.dispose();
    }

    protected void doOKAction() {
        super.doOKAction();
        new RollbackWorker(this.myProject, this.myRefreshSynchronously).doRollback(this.myBrowser.getCurrentIncludedChanges(), this.myDeleteLocallyAddedFiles != null && this.myDeleteLocallyAddedFiles.isSelected(), this.myAfterVcsRefreshInAwt, null);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        if (this.myDeleteLocallyAddedFiles != null) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.myBrowser, "Center");
            panel.add((Component)this.myDeleteLocallyAddedFiles, "South");
            return panel;
        }
        return this.myBrowser;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBrowser.getPrefferedFocusComponent();
    }

    protected String getDimensionServiceKey() {
        return "RollbackChangesDialog";
    }
}

