/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ui.AbstractSelectFilesDialog;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nullable;

public class SelectFilePathsDialog
extends AbstractSelectFilesDialog<FilePath> {
    public SelectFilePathsDialog(final Project project, List<FilePath> originalFiles, String prompt, VcsShowConfirmationOption confirmationOption) {
        super(project, false, confirmationOption, prompt);
        this.myFileList = new ChangesTreeList<FilePath>(project, originalFiles, true, true, null, null){

            @Override
            protected DefaultTreeModel buildTreeModel(List<FilePath> changes, ChangeNodeDecorator changeNodeDecorator) {
                return new TreeModelBuilder(project, false).buildModelFromFilePaths(changes);
            }

            @Override
            protected List<FilePath> getSelectedObjects(ChangesBrowserNode node) {
                return node.getAllFilePathsUnder();
            }

            @Override
            @Nullable
            protected FilePath getLeadSelectedObject(ChangesBrowserNode node) {
                Object userObject = node.getUserObject();
                if (userObject instanceof FilePath) {
                    return (FilePath)userObject;
                }
                return null;
            }
        };
        this.myFileList.setChangesToDisplay(originalFiles);
        this.myPanel.add((Component)this.myFileList, "Center");
        this.init();
    }

    public Collection<FilePath> getSelectedFiles() {
        return this.myFileList.getIncludedChanges();
    }
}

