/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.committed.CacheSettingsPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.Nls;

public class VcsBackgroundOperationsConfigurationPanel
implements SearchableConfigurable {
    private JPanel myPanel;
    private final Project myProject;
    Map<VcsShowOptionsSettingImpl, JCheckBox> myPromptOptions;
    private JCheckBox myCbUpdateInBackground;
    private JCheckBox myCbCommitInBackground;
    private JCheckBox myCbEditInBackground;
    private JCheckBox myCbAddRemoveInBackground;
    private JCheckBox myCbCheckoutInBackground;
    private JCheckBox myPerformRevertInBackgroundCheckBox;
    private JCheckBox myTrackChangedOnServer;
    private JCheckBox myEnableBackgroundProcesses;
    private JComponent myCachePanel;
    private JSpinner myChangedOnServerInterval;
    private JPanel myBackgroundProcesses;
    private JPanel myCachedCommittedChanges;
    private CacheSettingsPanel myCacheSettingsPanel;

    public VcsBackgroundOperationsConfigurationPanel(Project project) {
        this.$$$setupUI$$$();
        this.myPromptOptions = new LinkedHashMap<VcsShowOptionsSettingImpl, JCheckBox>();
        this.myProject = project;
        if (!this.myProject.isDefault()) {
            this.myEnableBackgroundProcesses.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean backgroundEnabled = VcsBackgroundOperationsConfigurationPanel.this.myEnableBackgroundProcesses.isSelected();
                    if (!backgroundEnabled) {
                        VcsBackgroundOperationsConfigurationPanel.this.myCacheSettingsPanel.setEnableCaching(false);
                        VcsBackgroundOperationsConfigurationPanel.this.myTrackChangedOnServer.setSelected(false);
                    }
                    VcsBackgroundOperationsConfigurationPanel.this.myTrackChangedOnServer.setEnabled(backgroundEnabled);
                    VcsBackgroundOperationsConfigurationPanel.this.myCacheSettingsPanel.setEnabled(backgroundEnabled);
                }
            });
            this.myCacheSettingsPanel.initPanel(project);
            VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.myProject);
            this.myChangedOnServerInterval.setModel(new SpinnerNumberModel(settings.CHANGED_ON_SERVER_INTERVAL, 5, 28800, 5));
        }
        this.myBackgroundProcesses.setVisible(!this.myProject.isDefault());
    }

    public void apply() throws ConfigurationException {
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.myProject);
        settings.PERFORM_COMMIT_IN_BACKGROUND = this.myCbCommitInBackground.isSelected();
        settings.PERFORM_UPDATE_IN_BACKGROUND = this.myCbUpdateInBackground.isSelected();
        settings.PERFORM_CHECKOUT_IN_BACKGROUND = this.myCbCheckoutInBackground.isSelected();
        settings.PERFORM_EDIT_IN_BACKGROUND = this.myCbEditInBackground.isSelected();
        settings.PERFORM_ADD_REMOVE_IN_BACKGROUND = this.myCbAddRemoveInBackground.isSelected();
        settings.PERFORM_ROLLBACK_IN_BACKGROUND = this.myPerformRevertInBackgroundCheckBox.isSelected();
        if (!this.myProject.isDefault()) {
            if (!settings.CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND && this.myTrackChangedOnServer.isSelected()) {
                RemoteRevisionsCache.getInstance(this.myProject).startRefreshInBackground();
            }
            settings.CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND = this.myTrackChangedOnServer.isSelected();
            settings.CHANGED_ON_SERVER_INTERVAL = ((Number)this.myChangedOnServerInterval.getValue()).intValue();
            settings.ENABLE_BACKGROUND_PROCESSES = this.myEnableBackgroundProcesses.isSelected();
            this.myCacheSettingsPanel.apply();
        }
        for (VcsShowOptionsSettingImpl setting : this.myPromptOptions.keySet()) {
            setting.setValue(this.myPromptOptions.get(setting).isSelected());
        }
    }

    public boolean isModified() {
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.myProject);
        if (settings.PERFORM_COMMIT_IN_BACKGROUND != this.myCbCommitInBackground.isSelected()) {
            return true;
        }
        if (settings.PERFORM_UPDATE_IN_BACKGROUND != this.myCbUpdateInBackground.isSelected()) {
            return true;
        }
        if (settings.PERFORM_CHECKOUT_IN_BACKGROUND != this.myCbCheckoutInBackground.isSelected()) {
            return true;
        }
        if (settings.PERFORM_EDIT_IN_BACKGROUND != this.myCbEditInBackground.isSelected()) {
            return true;
        }
        if (settings.PERFORM_ADD_REMOVE_IN_BACKGROUND != this.myCbAddRemoveInBackground.isSelected()) {
            return true;
        }
        if (settings.PERFORM_ROLLBACK_IN_BACKGROUND != this.myPerformRevertInBackgroundCheckBox.isSelected()) {
            return true;
        }
        if (!this.myProject.isDefault()) {
            if (settings.CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND != this.myTrackChangedOnServer.isSelected()) {
                return true;
            }
            if (settings.ENABLE_BACKGROUND_PROCESSES != this.myEnableBackgroundProcesses.isSelected()) {
                return true;
            }
            if (this.myCacheSettingsPanel.isModified()) {
                return true;
            }
            if (settings.CHANGED_ON_SERVER_INTERVAL != ((Number)this.myChangedOnServerInterval.getValue()).intValue()) {
                return true;
            }
        }
        return false;
    }

    public void reset() {
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.myProject);
        this.myCbCommitInBackground.setSelected(settings.PERFORM_COMMIT_IN_BACKGROUND);
        this.myCbUpdateInBackground.setSelected(settings.PERFORM_UPDATE_IN_BACKGROUND);
        this.myCbCheckoutInBackground.setSelected(settings.PERFORM_CHECKOUT_IN_BACKGROUND);
        this.myCbEditInBackground.setSelected(settings.PERFORM_EDIT_IN_BACKGROUND);
        this.myCbAddRemoveInBackground.setSelected(settings.PERFORM_ADD_REMOVE_IN_BACKGROUND);
        this.myPerformRevertInBackgroundCheckBox.setSelected(settings.PERFORM_ROLLBACK_IN_BACKGROUND);
        for (VcsShowOptionsSettingImpl setting : this.myPromptOptions.keySet()) {
            this.myPromptOptions.get(setting).setSelected(setting.getValue());
        }
        if (!this.myProject.isDefault()) {
            this.myTrackChangedOnServer.setSelected(settings.CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND);
            this.myEnableBackgroundProcesses.setSelected(settings.ENABLE_BACKGROUND_PROCESSES);
            this.myChangedOnServerInterval.setValue(settings.CHANGED_ON_SERVER_INTERVAL);
            this.myCacheSettingsPanel.reset();
        }
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    @Nls
    public String getDisplayName() {
        return "Background";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.Background";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        return this.getPanel();
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this.myCacheSettingsPanel = new CacheSettingsPanel();
        this.myCachePanel = this.myCacheSettingsPanel.createComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JSpinner jSpinner;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Font font = jPanel5.getFont();
        jPanel5.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/VcsBundle").getString("background.operations.title"), 0, 0, new Font(font.getName(), font.getStyle(), font.getSize()), null));
        this.myCbUpdateInBackground = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/VcsBundle").getString("perform.update.from.vcs.in.background"));
        jPanel5.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbCommitInBackground = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/VcsBundle").getString("perform.commit.in.bacground"));
        jPanel5.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbEditInBackground = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/VcsBundle").getString("perform.edit.in.background"));
        jPanel5.add((Component)jCheckBox6, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbAddRemoveInBackground = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/VcsBundle").getString("perform.add.remove.in.background"));
        jPanel5.add((Component)jCheckBox5, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbCheckoutInBackground = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Perform checkout from VCS in background");
        jPanel5.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPerformRevertInBackgroundCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/VcsBundle").getString("perform.rollback.in.background.option"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundProcesses = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/VcsBundle").getString("options.background.processes.title"), 0, 0, null, null));
        this.myEnableBackgroundProcesses = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/VcsBundle").getString("options.background.processes.enable"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/VcsBundle").getString("cache.settings.dialog.title"), 0, 0, null, null));
        JComponent jComponent = this.myCachePanel;
        jPanel6.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/VcsBundle").getString("options.check.changed.on.server.title"), 0, 0, null, null));
        this.myTrackChangedOnServer = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/VcsBundle").getString("vcs.config.track.changed.on.server"));
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myChangedOnServerInterval = jSpinner = new JSpinner();
        jPanel7.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("minutes");
        jPanel7.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

