/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.concurrency.JBLock;
import com.intellij.util.concurrency.JBReentrantReadWriteLock;
import com.intellij.util.concurrency.LockFactory;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class LocalFileSystemImpl
extends LocalFileSystemBase
implements ApplicationComponent {
    private final JBReentrantReadWriteLock LOCK = LockFactory.createReadWriteLock();
    final JBLock READ_LOCK = this.LOCK.readLock();
    final JBLock WRITE_LOCK = this.LOCK.writeLock();
    private final List<LocalFileSystem.WatchRequest> myRootsToWatch = new ArrayList<LocalFileSystem.WatchRequest>();
    private LocalFileSystem.WatchRequest[] myCachedNormalizedRequests = null;
    private final FileWatcher myWatcher = FileWatcher.getInstance();

    public LocalFileSystemImpl() {
        if (this.myWatcher.isOperational()) {
            new StoreRefreshStatusThread().start();
        }
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void cleanupForNextTest() throws IOException {
        VirtualFile[] roots;
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
                LocalFileSystemImpl.this.refresh(false);
            }
        });
        ((PersistentFS)ManagingFS.getInstance()).clearIdCache();
        for (VirtualFile root : roots = ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this)) {
            if (!(root instanceof VirtualDirectoryImpl)) continue;
            VirtualDirectoryImpl directory = (VirtualDirectoryImpl)root;
            directory.cleanupCachedChildren();
        }
        this.myRootsToWatch.clear();
        File file = new File(FileUtil.getTempDirectory());
        String path = file.getCanonicalPath().replace(File.separatorChar, '/');
        this.addRootToWatch(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalFileSystem.WatchRequest[] normalizeRootsForRefresh() {
        if (this.myCachedNormalizedRequests != null) {
            return this.myCachedNormalizedRequests;
        }
        ArrayList<LocalFileSystem.WatchRequest> result = new ArrayList<LocalFileSystem.WatchRequest>();
        this.WRITE_LOCK.lock();
        try {
            block3: for (LocalFileSystem.WatchRequest request : this.myRootsToWatch) {
                String rootPath = request.getRootPath();
                boolean recursively = request.isToWatchRecursively();
                Iterator iterator1 = result.iterator();
                while (iterator1.hasNext()) {
                    LocalFileSystem.WatchRequest otherRequest = (LocalFileSystem.WatchRequest)iterator1.next();
                    String otherRootPath = otherRequest.getRootPath();
                    boolean otherRecursively = otherRequest.isToWatchRecursively();
                    if (rootPath.equals(otherRootPath) && (!recursively || otherRecursively) || FileUtil.startsWith((String)rootPath, (String)otherRootPath) && otherRecursively) continue block3;
                    if (!FileUtil.startsWith((String)otherRootPath, (String)rootPath) || !recursively && otherRecursively) continue;
                    iterator1.remove();
                }
                result.add(request);
            }
        }
        finally {
            this.WRITE_LOCK.unlock();
        }
        this.myCachedNormalizedRequests = result.toArray(new LocalFileSystem.WatchRequest[result.size()]);
        return this.myCachedNormalizedRequests;
    }

    private void storeRefreshStatusToFiles() {
        if (FileWatcher.getInstance().isOperational()) {
            this.markPathsDirty(FileWatcher.getInstance().getDirtyPaths());
            this.markFlatDirsDirty(FileWatcher.getInstance().getDirtyDirs());
            this.markRecursiveDirsDirty(FileWatcher.getInstance().getDirtyRecursivePaths());
        }
    }

    private void markPathsDirty(List<String> dirtyFiles) {
        for (String dirtyFile : dirtyFiles) {
            String path = dirtyFile.replace(File.separatorChar, '/');
            VirtualFile file = this.findFileByPathIfCached(path);
            if (!(file instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file).markDirty();
        }
    }

    private void markFlatDirsDirty(List<String> dirtyFiles) {
        for (String dirtyFile : dirtyFiles) {
            String path = dirtyFile.replace(File.separatorChar, '/');
            VirtualFile file = this.findFileByPathIfCached(path);
            if (!(file instanceof NewVirtualFile)) continue;
            NewVirtualFile nvf = (NewVirtualFile)file;
            nvf.markDirty();
            for (VirtualFile child : nvf.getCachedChildren()) {
                ((NewVirtualFile)child).markDirty();
            }
        }
    }

    private void markRecursiveDirsDirty(List<String> dirtyFiles) {
        for (String dirtyFile : dirtyFiles) {
            String path = dirtyFile.replace(File.separatorChar, '/');
            VirtualFile file = this.findFileByPathIfCached(path);
            if (!(file instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file).markDirtyRecursively();
        }
    }

    public void markSuspicousFilesDirty(List<VirtualFile> files) {
        this.storeRefreshStatusToFiles();
        if (this.myWatcher.isOperational()) {
            for (String root : this.myWatcher.getManualWatchRoots()) {
                VirtualFile suspicousRoot = this.findFileByPathIfCached(root);
                if (suspicousRoot == null) continue;
                ((NewVirtualFile)suspicousRoot).markDirtyRecursively();
            }
        } else {
            for (VirtualFile file : files) {
                if (file.getFileSystem() != this) continue;
                ((NewVirtualFile)file).markDirtyRecursively();
            }
        }
    }

    private void setUpFileWatcher() {
        Application application = ApplicationManager.getApplication();
        if (application.isDisposeInProgress()) {
            return;
        }
        if (this.myWatcher.isOperational()) {
            application.runReadAction(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LocalFileSystemImpl.this.WRITE_LOCK.lock();
                    try {
                        LocalFileSystem.WatchRequest[] watchRequests = LocalFileSystemImpl.this.normalizeRootsForRefresh();
                        ArrayList<String> myRecursiveRoots = new ArrayList<String>();
                        ArrayList<String> myFlatRoots = new ArrayList<String>();
                        for (LocalFileSystem.WatchRequest root : watchRequests) {
                            if (root.isToWatchRecursively()) {
                                myRecursiveRoots.add(root.getFileSystemRootPath());
                                continue;
                            }
                            myFlatRoots.add(root.getFileSystemRootPath());
                        }
                        LocalFileSystemImpl.this.myWatcher.setWatchRoots(myRecursiveRoots, myFlatRoots);
                    }
                    finally {
                        LocalFileSystemImpl.this.WRITE_LOCK.unlock();
                    }
                }
            });
        }
    }

    @NotNull
    public String getComponentName() {
        if ("LocalFileSystem" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl.getComponentName must not return null");
        }
        return "LocalFileSystem";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalFileSystem.WatchRequest addRootToWatch(@NotNull String rootPath, boolean toWatchRecursively) {
        if (rootPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl.addRootToWatch must not be null");
        }
        if (rootPath.length() == 0 || !FileWatcher.getInstance().isOperational()) {
            return null;
        }
        this.WRITE_LOCK.lock();
        try {
            WatchRequestImpl result = new WatchRequestImpl(rootPath, toWatchRecursively);
            VirtualFile existingFile = this.findFileByPathIfCached(rootPath);
            if (existingFile != null && !this.isAlreadyWatched(result)) {
                existingFile.refresh(true, toWatchRecursively);
                if (existingFile.isDirectory() && !toWatchRecursively && existingFile instanceof NewVirtualFile) {
                    for (VirtualFile child : ((NewVirtualFile)existingFile).getCachedChildren()) {
                        child.refresh(true, false);
                    }
                }
            }
            this.myRootsToWatch.add(result);
            this.myCachedNormalizedRequests = null;
            this.setUpFileWatcher();
            WatchRequestImpl watchRequestImpl = result;
            return watchRequestImpl;
        }
        finally {
            this.WRITE_LOCK.unlock();
        }
    }

    private boolean isAlreadyWatched(LocalFileSystem.WatchRequest request) {
        for (LocalFileSystem.WatchRequest current : this.normalizeRootsForRefresh()) {
            if (!current.dominates(request)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Set<LocalFileSystem.WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean toWatchRecursively) {
        HashSet hashSet;
        if (rootPaths == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl.addRootsToWatch must not be null");
        }
        if (!FileWatcher.getInstance().isOperational()) {
            hashSet = Collections.emptySet();
            if (hashSet == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl.addRootsToWatch must not return null");
            return hashSet;
        }
        HashSet result = new HashSet();
        HashSet filesToSynchronize = new HashSet();
        this.WRITE_LOCK.lock();
        try {
            for (String rootPath : rootPaths) {
                LOG.assertTrue(rootPath != null);
                if (rootPath.length() <= 0) continue;
                WatchRequestImpl request = new WatchRequestImpl(rootPath, toWatchRecursively);
                VirtualFile existingFile = this.findFileByPathIfCached(rootPath);
                if (existingFile != null && !this.isAlreadyWatched(request)) {
                    filesToSynchronize.add(existingFile);
                }
                result.add(request);
                this.myRootsToWatch.add(request);
            }
            this.myCachedNormalizedRequests = null;
            this.setUpFileWatcher();
        }
        finally {
            this.WRITE_LOCK.unlock();
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !filesToSynchronize.isEmpty()) {
            LocalFileSystemImpl.refreshFiles((Iterable<VirtualFile>)filesToSynchronize, toWatchRecursively, true);
        }
        if ((hashSet = result) != null) return hashSet;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl.addRootsToWatch must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWatchedRoot(@NotNull LocalFileSystem.WatchRequest watchRequest) {
        if (watchRequest == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl.removeWatchedRoot must not be null");
        }
        this.WRITE_LOCK.lock();
        try {
            if (this.myRootsToWatch.remove(watchRequest)) {
                this.myCachedNormalizedRequests = null;
                this.setUpFileWatcher();
            }
        }
        finally {
            this.WRITE_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> rootsToWatch) {
        if (rootsToWatch == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl.removeWatchedRoots must not be null");
        }
        this.WRITE_LOCK.lock();
        try {
            if (this.myRootsToWatch.removeAll(rootsToWatch)) {
                this.myCachedNormalizedRequests = null;
                this.setUpFileWatcher();
            }
        }
        finally {
            this.WRITE_LOCK.unlock();
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    @NonNls
    public String toString() {
        return "LocalFileSystem";
    }

    public void refreshWithoutFileWatcher(final boolean asynchronous) {
        Runnable heavyRefresh = new Runnable(){

            @Override
            public void run() {
                for (VirtualFile root : ManagingFS.getInstance().getRoots((NewVirtualFileSystem)LocalFileSystemImpl.this)) {
                    ((NewVirtualFile)root).markDirtyRecursively();
                }
                LocalFileSystemImpl.this.refresh(asynchronous);
            }
        };
        if (asynchronous && this.myWatcher.isOperational()) {
            RefreshQueue.getInstance().refresh(true, true, heavyRefresh, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this));
        } else {
            heavyRefresh.run();
        }
    }

    private class StoreRefreshStatusThread
    extends Thread {
        private static final long PERIOD = 1000L;

        public StoreRefreshStatusThread() {
            super("StoreRefreshStatusThread");
            this.setPriority(1);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Application application;
            while ((application = ApplicationManager.getApplication()) != null && !application.isDisposed()) {
                LocalFileSystemImpl.this.storeRefreshStatusToFiles();
                try {
                    StoreRefreshStatusThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static class WatchRequestImpl
    implements LocalFileSystem.WatchRequest {
        public final String myRootPath;
        public String myFSRootPath;
        public final boolean myToWatchRecursively;

        public WatchRequestImpl(String rootPath, boolean toWatchRecursively) {
            File file;
            this.myToWatchRecursively = toWatchRecursively;
            int index = rootPath.indexOf("!/");
            if (index >= 0) {
                rootPath = rootPath.substring(0, index);
            }
            if (!(file = new File(rootPath.replace('/', File.separatorChar))).isDirectory()) {
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    if (SystemInfo.isFileSystemCaseSensitive) {
                        this.myFSRootPath = parentFile.getAbsolutePath();
                    } else {
                        try {
                            this.myFSRootPath = parentFile.getCanonicalPath();
                        }
                        catch (IOException e) {
                            this.myFSRootPath = rootPath;
                        }
                    }
                } else {
                    this.myFSRootPath = rootPath.replace('/', File.separatorChar);
                }
                this.myRootPath = this.myFSRootPath.replace(File.separatorChar, '/');
            } else {
                this.myRootPath = rootPath.replace(File.separatorChar, '/');
                this.myFSRootPath = rootPath.replace('/', File.separatorChar);
            }
        }

        @NotNull
        public String getRootPath() {
            String string = this.myRootPath;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl$WatchRequestImpl.getRootPath must not return null");
            }
            return string;
        }

        @NotNull
        public String getFileSystemRootPath() {
            String string = this.myFSRootPath;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl$WatchRequestImpl.getFileSystemRootPath must not return null");
            }
            return string;
        }

        public boolean isToWatchRecursively() {
            return this.myToWatchRecursively;
        }

        public boolean dominates(LocalFileSystem.WatchRequest other) {
            if (this.myToWatchRecursively) {
                return other.getRootPath().startsWith(this.myRootPath);
            }
            return !other.isToWatchRecursively() && this.myRootPath.equals(other.getRootPath());
        }
    }
}

