/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.win32;

import com.intellij.openapi.vfs.impl.win32.FileInfo;
import com.intellij.openapi.vfs.impl.win32.IdeaWin32;
import com.intellij.util.ArrayUtil;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Win32Kernel {
    public static final int FILE_ATTRIBUTE_DIRECTORY = 16;
    public static final int FILE_ATTRIBUTE_READONLY = 1;
    private IdeaWin32 myKernel = new IdeaWin32();
    private Map<String, FileInfo> myCache = new HashMap<String, FileInfo>();

    void clearCache() {
        this.myCache.clear();
    }

    public String[] list(String absolutePath) {
        FileInfo[] fileInfos = this.myKernel.listChildren(absolutePath.replace('/', '\\') + "\\*.*");
        if (fileInfos == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> names = new ArrayList<String>(fileInfos.length);
        for (FileInfo info : fileInfos) {
            if (info.name.equals(".")) {
                this.myCache.put(absolutePath, info);
                continue;
            }
            if (info.name.equals("..")) continue;
            this.myCache.put(absolutePath + "/" + info.name, info);
            names.add(info.name);
        }
        return ArrayUtil.toStringArray(names);
    }

    public void exists(String path) throws FileNotFoundException {
        this.getInfo(path);
    }

    public boolean isDirectory(String path) throws FileNotFoundException {
        FileInfo data = this.getInfo(path);
        return (data.attributes & 0x10) != 0;
    }

    public boolean isWritable(String path) throws FileNotFoundException {
        FileInfo fileInfo = this.getInfo(path);
        this.myCache.remove(path);
        return (fileInfo.attributes & 1) == 0;
    }

    public long getTimeStamp(String path) throws FileNotFoundException {
        long timestamp = this.getInfo((String)path).timestamp;
        return timestamp / 10000L - 11644473600000L;
    }

    private FileInfo getInfo(String path) throws FileNotFoundException {
        FileInfo info = this.myCache.get(path);
        if (info == null) {
            info = this.myKernel.getInfo(path.replace('/', '\\'));
            if (info == null) {
                throw new FileNotFoundException(path);
            }
            this.myCache.put(path, info);
        }
        return info;
    }
}

