/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.status.StatusBarPatch;
import com.intellij.openapi.wm.impl.status.StatusBarTooltipper;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class TogglePopupHintsPanel
extends JPanel
implements StatusBarPatch {
    private static final Icon INSPECTIONS_ICON = IconLoader.getIcon((String)"/objectBrowser/showGlobalInspections.png");
    private static final Icon INSPECTIONS_OFF_ICON = IconLoader.getIcon((String)"/general/inspectionsOff.png");
    private static final Icon EMPTY_ICON = new EmptyIcon(INSPECTIONS_ICON.getIconWidth(), INSPECTIONS_ICON.getIconHeight());
    private final JLabel myHectorLabel = new JLabel(EMPTY_ICON);

    public TogglePopupHintsPanel(StatusBar statusBar) {
        super(new GridBagLayout());
        this.myHectorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point point = new Point(0, 0);
                PsiFile file = TogglePopupHintsPanel.this.getCurrentFile();
                if (file != null) {
                    if (!DaemonCodeAnalyzer.getInstance((Project)file.getProject()).isHighlightingAvailable(file)) {
                        return;
                    }
                    HectorComponent component = new HectorComponent(file);
                    Dimension dimension = component.getPreferredSize();
                    point = new Point(point.x - dimension.width, point.y - dimension.height);
                    component.showComponent(new RelativePoint((Component)TogglePopupHintsPanel.this, point));
                }
            }
        });
        this.myHectorLabel.setIconTextGap(0);
        this.add((Component)this.myHectorLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        StatusBarTooltipper.install(this, this.myHectorLabel, statusBar);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String updateStatusBar(Editor selected, JComponent componentSelected) {
        this.updateStatus();
        String text = componentSelected == null ? null : componentSelected.getToolTipText();
        this.setCursor(Cursor.getPredefinedCursor(text == null ? 0 : 12));
        return text;
    }

    @Override
    public void clear() {
        this.myHectorLabel.setIcon(EMPTY_ICON);
        this.myHectorLabel.setToolTipText(null);
    }

    public void updateStatus() {
        this.updateStatus(this.getCurrentFile());
    }

    private void updateStatus(PsiFile file) {
        if (TogglePopupHintsPanel.isStateChangeable(file)) {
            String tooltip;
            if (HighlightLevelUtil.shouldInspect((PsiElement)file)) {
                this.myHectorLabel.setIcon(INSPECTIONS_ICON);
                tooltip = "Current inspection profile: " + InspectionProjectProfileManager.getInstance(file.getProject()).getInspectionProfile().getName() + ". ";
            } else {
                this.myHectorLabel.setIcon(INSPECTIONS_OFF_ICON);
                tooltip = "Inspections are off. ";
            }
            this.myHectorLabel.setToolTipText(tooltip + UIBundle.message((String)"popup.hints.panel.click.to.configure.highlighting.tooltip.text", (Object[])new Object[0]));
        } else {
            this.myHectorLabel.setIcon(EMPTY_ICON);
            this.myHectorLabel.setToolTipText(null);
        }
    }

    private static boolean isStateChangeable(PsiFile file) {
        return file != null && DaemonCodeAnalyzer.getInstance((Project)file.getProject()).isHighlightingAvailable(file);
    }

    @Nullable
    private PsiFile getCurrentFile() {
        Project project = this.getCurrentProject();
        if (project == null) {
            return null;
        }
        VirtualFile virtualFile = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)project)).getCurrentFile();
        if (virtualFile != null && virtualFile.isValid()) {
            return PsiManager.getInstance((Project)project).findFile(virtualFile);
        }
        return null;
    }

    @Nullable
    private Project getCurrentProject() {
        return (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this));
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        return new Point(0, -20);
    }
}

