/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class PanelProgressIndicator
extends ProgressIndicatorBase {
    private final MyProgressPanel myProgressPanel = new MyProgressPanel();
    private boolean myPaintInQueue;
    private final Consumer<JComponent> myComponentUpdater;

    public PanelProgressIndicator(Consumer<JComponent> componentUpdater) {
        this.myProgressPanel.myFractionProgress.setMaximum(100);
        this.myComponentUpdater = componentUpdater;
    }

    @Override
    public void start() {
        super.start();
        this.myComponentUpdater.consume((Object)this.myProgressPanel.myPanel);
    }

    @Override
    public void stop() {
        super.stop();
        if (this.isCanceled()) {
            JLabel label = new JLabel(AnalysisScopeBundle.message((String)"usage.view.canceled", (Object[])new Object[0]));
            label.setHorizontalAlignment(0);
            this.myComponentUpdater.consume((Object)label);
        }
    }

    @Override
    public void setText(String text) {
        if (!text.equals(this.getText())) {
            super.setText(text);
            this.update();
        }
    }

    @Override
    public void setFraction(double fraction) {
        if (fraction != this.getFraction()) {
            super.setFraction(fraction);
            this.update();
        }
    }

    @Override
    public void setIndeterminate(final boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanelProgressIndicator.this.myProgressPanel.myFractionProgress.setIndeterminate(indeterminate);
            }
        });
    }

    private void update() {
        if (this.myPaintInQueue) {
            return;
        }
        this.myPaintInQueue = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanelProgressIndicator.this.myPaintInQueue = false;
                ((PanelProgressIndicator)PanelProgressIndicator.this).myProgressPanel.myTextLabel.setText(PanelProgressIndicator.this.getText());
                int fraction = (int)(PanelProgressIndicator.this.getFraction() * 99.0 + 0.5);
                ((PanelProgressIndicator)PanelProgressIndicator.this).myProgressPanel.myFractionLabel.setText(fraction + "%");
                PanelProgressIndicator.this.myProgressPanel.myFractionProgress.setValue(fraction);
            }
        });
    }

    public void setBordersVisible(boolean visible) {
        this.myProgressPanel.myLeftPanel.setVisible(visible);
        this.myProgressPanel.myRightPanel.setVisible(visible);
    }

    private static class MyProgressPanel {
        public JLabel myFractionLabel;
        public JLabel myTextLabel;
        public JPanel myPanel;
        private JProgressBar myFractionProgress;
        private JPanel myLeftPanel;
        private JPanel myRightPanel;

        private MyProgressPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            JPanel jPanel2;
            JLabel jLabel;
            JProgressBar jProgressBar;
            JLabel jLabel2;
            JPanel jPanel3;
            this.myPanel = jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
            Spacer spacer = new Spacer();
            jPanel4.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myFractionLabel = jLabel2 = new JLabel();
            jLabel2.setHorizontalAlignment(4);
            jLabel2.setText("0%");
            jPanel5.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, new Dimension(30, -1), null, null));
            this.myFractionProgress = jProgressBar = new JProgressBar();
            jPanel5.add((Component)jProgressBar, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
            this.myTextLabel = jLabel = new JLabel();
            jLabel.setText("");
            jPanel4.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel4.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myLeftPanel = jPanel2 = new JPanel();
            jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(50, -1), null));
            this.myRightPanel = jPanel = new JPanel();
            jPanel3.add((Component)jPanel, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, new Dimension(50, -1), null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }
    }
}

