/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.extapi.psi.StubPath;
import com.intellij.extapi.psi.StubPathBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAnchor {
    @Nullable
    public abstract PsiElement retrieve();

    public abstract PsiFile getFile();

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    public static PsiAnchor create(PsiElement element) {
        StubBasedPsiElement elt;
        if (element instanceof PsiFile) {
            return new HardReference(element);
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return new HardReference(element);
        }
        if (element instanceof StubBasedPsiElement && element.isPhysical() && (element instanceof PsiCompiledElement || ((PsiFileImpl)file).getContentElementType() instanceof IStubFileElementType) && ((elt = (StubBasedPsiElement)element).getStub() != null || elt.getElementType().shouldCreateStub(element.getNode()))) {
            return new StubIndexReference(file, PsiAnchor.calcStubIndex((StubBasedPsiElement)element));
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null || element instanceof LightElement) {
            return new HardReference(element);
        }
        Language lang = null;
        FileViewProvider viewProvider = file.getViewProvider();
        Set languages = viewProvider.getLanguages();
        for (Language l : languages) {
            if (!PsiTreeUtil.isAncestor((PsiElement)viewProvider.getPsi(l), (PsiElement)element, (boolean)false)) continue;
            lang = l;
            break;
        }
        if (lang == null) {
            lang = element.getLanguage();
        }
        return new TreeRangeReference(file, textRange.getStartOffset(), textRange.getEndOffset(), element.getClass(), lang);
    }

    public static int calcStubIndex(StubBasedPsiElement psi) {
        if (psi instanceof PsiFile) {
            return 0;
        }
        StubElement liveStub = psi.getStub();
        if (liveStub != null) {
            return ((StubBase)liveStub).id;
        }
        PsiFileImpl file = (PsiFileImpl)psi.getContainingFile();
        StubTree stubTree = file.calcStubTree();
        for (StubElement<?> stb : stubTree.getPlainList()) {
            if (stb.getPsi() != psi) continue;
            return ((StubBase)stb).id;
        }
        throw new RuntimeException("Can't find stub index for this psi");
    }

    private static class StubPathReference
    extends PsiAnchor {
        private final PsiFile myFile;
        private final StubPath myPath;

        public StubPathReference(PsiFile file, StubPath path) {
            this.myFile = file;
            this.myPath = path;
        }

        @Override
        public PsiElement retrieve() {
            return (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

                public PsiElement compute() {
                    return StubPathBuilder.resolve(StubPathReference.this.myFile, StubPathReference.this.myPath);
                }
            });
        }

        @Override
        public PsiFile getFile() {
            return this.myFile;
        }

        @Override
        public int getStartOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null);
            }
            return resolved.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null);
            }
            return resolved.getTextRange().getEndOffset();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof StubPathReference) {
                StubPathReference that = (StubPathReference)o;
                return this.myFile.equals(that.myFile) && this.myPath.equals(that.myPath);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.myFile.hashCode() + this.myPath.hashCode();
        }
    }

    public static class StubIndexReference
    extends PsiAnchor {
        private final PsiFile myFile;
        private final int myIndex;

        public StubIndexReference(PsiFile file, int index) {
            this.myFile = file;
            this.myIndex = index;
        }

        @Override
        public PsiFile getFile() {
            return this.myFile;
        }

        @Override
        public PsiElement retrieve() {
            return (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<PsiElement>(){

                public PsiElement compute() {
                    boolean foreign;
                    PsiFileWithStubSupport fileImpl = (PsiFileWithStubSupport)StubIndexReference.this.myFile;
                    StubTree tree = fileImpl.getStubTree();
                    boolean bl = foreign = tree == null;
                    if (foreign) {
                        if (fileImpl instanceof PsiFileImpl) {
                            tree = ((PsiFileImpl)fileImpl).calcStubTree();
                        } else {
                            return null;
                        }
                    }
                    StubElement<?> stub = tree.getPlainList().get(StubIndexReference.this.myIndex);
                    if (foreign) {
                        PsiElement cachedPsi = ((StubBase)stub).getCachedPsi();
                        if (cachedPsi != null) {
                            return cachedPsi;
                        }
                        ASTNode ast = fileImpl.findTreeForStub(tree, stub);
                        return ast != null ? ast.getPsi() : null;
                    }
                    return stub != null ? stub.getPsi() : null;
                }
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StubIndexReference)) {
                return false;
            }
            StubIndexReference that = (StubIndexReference)o;
            return this.myIndex == that.myIndex && this.myFile.equals(that.myFile);
        }

        public int hashCode() {
            return 31 * this.myFile.hashCode() + this.myIndex;
        }

        @Override
        public int getStartOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null);
            }
            return resolved.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null);
            }
            return resolved.getTextRange().getEndOffset();
        }
    }

    private static class HardReference
    extends PsiAnchor {
        private final PsiElement myElement;

        private HardReference(PsiElement element) {
            this.myElement = element;
        }

        @Override
        public PsiElement retrieve() {
            return this.myElement;
        }

        @Override
        public PsiFile getFile() {
            return this.myElement.getContainingFile();
        }

        @Override
        public int getStartOffset() {
            return this.myElement.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.myElement.getTextRange().getEndOffset();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HardReference)) {
                return false;
            }
            HardReference that = (HardReference)o;
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }
    }

    private static class TreeRangeReference
    extends PsiAnchor {
        private final PsiFile myFile;
        private final Language myLanguage;
        private final int myStartOffset;
        private final int myEndOffset;
        private final Class myClass;

        private TreeRangeReference(PsiFile file, int startOffset, int endOffset, Class aClass, Language language) {
            this.myFile = file;
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myClass = aClass;
            this.myLanguage = language;
        }

        @Override
        @Nullable
        public PsiElement retrieve() {
            PsiElement element = this.myFile.getViewProvider().findElementAt(this.myStartOffset, this.myLanguage);
            if (element == null) {
                return null;
            }
            while (!element.getClass().equals(this.myClass) || element.getTextRange().getStartOffset() != this.myStartOffset || element.getTextRange().getEndOffset() != this.myEndOffset) {
                if ((element = element.getParent()) != null && element.getTextRange() != null) continue;
                return null;
            }
            return element;
        }

        @Override
        public PsiFile getFile() {
            return this.myFile;
        }

        @Override
        public int getStartOffset() {
            return this.myStartOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TreeRangeReference)) {
                return false;
            }
            TreeRangeReference that = (TreeRangeReference)o;
            if (this.myEndOffset != that.myEndOffset) {
                return false;
            }
            if (this.myStartOffset != that.myStartOffset) {
                return false;
            }
            if (this.myClass != null ? !this.myClass.equals(that.myClass) : that.myClass != null) {
                return false;
            }
            return !(this.myFile != null ? !this.myFile.equals(that.myFile) : that.myFile != null);
        }

        public int hashCode() {
            int result = this.myClass != null ? this.myClass.getName().hashCode() : 0;
            result = 31 * result + this.myStartOffset;
            result = 31 * result + this.myEndOffset;
            if (this.myFile != null) {
                result = 31 * result + this.myFile.getName().hashCode();
            }
            return result;
        }
    }
}

