/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.classes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.util.ReflectionCache;

public abstract class ClassAssignableFilter
implements ElementFilter {
    protected String myClassName = null;
    protected PsiClass myClass = null;
    private SoftReference myCachedClass = new SoftReference(null);

    public abstract boolean isAcceptable(Object var1, PsiElement var2);

    public abstract String toString();

    public boolean isClassAcceptable(Class hintClass) {
        return ReflectionCache.isAssignable(PsiClass.class, (Class)hintClass);
    }

    protected PsiClass getPsiClass(PsiManager manager, GlobalSearchScope scope) {
        if (this.myClass != null) {
            return this.myClass;
        }
        if (this.myCachedClass.get() == null && manager != null) {
            this.myCachedClass = new SoftReference((Object)JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(this.myClassName, scope));
        }
        return (PsiClass)this.myCachedClass.get();
    }
}

