/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeValueGetter
implements ContextGetter {
    @Override
    public Object[] get(PsiElement context, CompletionContext completionContext) {
        return this.getApplicableAttributeVariants(context, completionContext);
    }

    private Object[] getApplicableAttributeVariants(PsiElement _context, CompletionContext completionContext) {
        XmlAttributeDescriptor descriptor;
        PsiElement context = _context;
        if (context != null && (context = PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class)) == null) {
            context = PsiTreeUtil.getParentOfType((PsiElement)_context, XmlAttributeValue.class);
        }
        if (context instanceof XmlAttribute && (descriptor = ((XmlAttribute)context).getDescriptor()) != null) {
            if (descriptor.isFixed()) {
                Object[] objectArray;
                String defaultValue = descriptor.getDefaultValue();
                if (defaultValue == null) {
                    objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = defaultValue;
                }
                return objectArray;
            }
            Object[] values = descriptor instanceof BasicXmlAttributeDescriptor ? ((BasicXmlAttributeDescriptor)descriptor).getEnumeratedValues((XmlElement)context) : descriptor.getEnumeratedValues();
            Object[] strings = this.addSpecificCompletions(context);
            if (values == null || values.length == 0) {
                values = strings;
            } else if (strings != null) {
                values = (String[])ArrayUtil.mergeArrays((Object[])values, (Object[])strings, String.class);
            }
            return values == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : values;
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    protected String[] addSpecificCompletions(PsiElement context) {
        return null;
    }
}

