/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;

public class ExtendsListBlock
extends AbstractJavaBlock {
    public ExtendsListBlock(ASTNode node, Wrap wrap, Alignment alignment, CodeStyleSettings settings) {
        super(node, wrap, alignment, Indent.getNoneIndent(), settings);
    }

    @Override
    protected List<Block> buildChildren() {
        Alignment alignment;
        ArrayList<Block> result = new ArrayList<Block>();
        ArrayList<Object> elementsExceptKeyword = new ArrayList<Block>();
        this.myChildAlignment = this.createChildAlignment();
        this.myChildIndent = Indent.getContinuationIndent();
        this.myUseChildAttributes = true;
        Wrap childWrap = this.createChildWrap();
        Object object = alignment = this.alignList() ? Alignment.createAlignment() : null;
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly(child) || child.getTextLength() <= 0) continue;
            if (ElementType.KEYWORD_BIT_SET.contains(child.getElementType())) {
                if (!elementsExceptKeyword.isEmpty()) {
                    result.add(new SyntheticCodeBlock(elementsExceptKeyword, null, this.mySettings, Indent.getNoneIndent(), null));
                    elementsExceptKeyword = new ArrayList();
                }
                result.add(ExtendsListBlock.createJavaBlock(child, this.mySettings, this.myChildIndent, this.arrangeChildWrap(child, childWrap), alignment));
                continue;
            }
            this.processChild(elementsExceptKeyword, child, this.myChildAlignment, childWrap, this.myChildIndent);
        }
        if (!elementsExceptKeyword.isEmpty()) {
            result.add(new SyntheticCodeBlock(elementsExceptKeyword, alignment, this.mySettings, Indent.getNoneIndent(), null));
        }
        return result;
    }

    private boolean alignList() {
        if (this.myNode.getElementType() == ElementType.EXTENDS_LIST) {
            return this.mySettings.ALIGN_MULTILINE_EXTENDS_LIST;
        }
        if (this.myNode.getElementType() == ElementType.IMPLEMENTS_LIST) {
            return this.mySettings.ALIGN_MULTILINE_EXTENDS_LIST;
        }
        if (this.myNode.getElementType() == ElementType.THROWS_LIST) {
            return this.mySettings.ALIGN_MULTILINE_THROWS_LIST;
        }
        return false;
    }

    @Override
    protected Wrap getReservedWrap(IElementType elementType) {
        return null;
    }

    @Override
    protected void setReservedWrap(Wrap reservedWrap, IElementType operationType) {
    }
}

