/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.ReadOnlyBlockContainer;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AbstractSyntheticBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SyntheticBlock
extends AbstractSyntheticBlock
implements Block,
ReadOnlyBlockContainer {
    private final List<Block> mySubBlocks;
    private final Indent myChildIndent;

    public SyntheticBlock(List<Block> subBlocks, Block parent, Indent indent, XmlFormattingPolicy policy, Indent childIndent) {
        super(subBlocks, parent, policy, indent);
        this.mySubBlocks = subBlocks;
        this.myChildIndent = childIndent;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = SyntheticBlock.calculateTextRange(this.mySubBlocks);
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/SyntheticBlock.getTextRange must not return null");
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/SyntheticBlock.getSubBlocks must not return null");
        }
        return list;
    }

    public Spacing getSpacing(Block child1, Block child2) {
        boolean saveSpacesBetweenTagAndText;
        if (child1 instanceof ReadOnlyBlock || child2 instanceof ReadOnlyBlock) {
            return Spacing.getReadOnlySpacing();
        }
        if (!(child1 instanceof AbstractXmlBlock) || !(child2 instanceof AbstractXmlBlock)) {
            return null;
        }
        ASTNode node1 = ((AbstractBlock)child1).getNode();
        ASTNode node2 = ((AbstractBlock)child2).getNode();
        IElementType type1 = node1.getElementType();
        IElementType type2 = node2.getElementType();
        boolean firstIsText = this.isTextFragment(node1);
        boolean secondIsText = this.isTextFragment(node2);
        boolean firstIsTag = node1.getPsi() instanceof XmlTag && !firstIsText;
        boolean secondIsTag = node2.getPsi() instanceof XmlTag && !secondIsText;
        boolean firstIsEntityRef = this.isEntityRef(node1);
        boolean secondIsEntityRef = this.isEntityRef(node2);
        if (this.isSpaceInText(firstIsTag, secondIsTag, firstIsText, secondIsText) && this.keepWhiteSpaces()) {
            return Spacing.getReadOnlySpacing();
        }
        if (firstIsEntityRef || secondIsEntityRef) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (type2 == XmlElementType.XML_EMPTY_ELEMENT_END && this.myXmlFormattingPolicy.addSpaceIntoEmptyTag()) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (secondIsTag && this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag((XmlTag)node2.getPsi()) && node2.textContains('\n')) {
            return Spacing.getReadOnlySpacing();
        }
        if (SyntheticBlock.isXmlTagName(type1, type2)) {
            int spaces = this.shouldAddSpaceAroundTagName(node1, node2) ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (type2 == XmlElementType.XML_ATTRIBUTE) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (((AbstractXmlBlock)child1).isTextElement() && ((AbstractXmlBlock)child2).isTextElement()) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (firstIsTag && this.insertLineFeedAfter((XmlTag)node1.getPsi())) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if ((firstIsText || firstIsTag) && secondIsTag) {
            if (((AbstractXmlBlock)child2).insertLineBreakBeforeTag()) {
                return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)2, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            if (((AbstractXmlBlock)child2).removeLineBreakBeforeTag()) {
                return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
        }
        boolean bl = saveSpacesBetweenTagAndText = this.myXmlFormattingPolicy.shouldSaveSpacesBetweenTagAndText() && child1.getTextRange().getEndOffset() < child2.getTextRange().getStartOffset();
        if (firstIsTag && secondIsText) {
            if (((AbstractXmlBlock)child1).isTextElement() || saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (firstIsText && secondIsTag) {
            if (((AbstractXmlBlock)child2).isTextElement() || saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (firstIsTag && secondIsTag) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
    }

    private boolean isEntityRef(ASTNode node) {
        return node.getElementType() == XmlElementType.XML_ENTITY_REF;
    }

    private boolean shouldAddSpaceAroundTagName(ASTNode node1, ASTNode node2) {
        if (node1.getElementType() == XmlElementType.XML_START_TAG_START && node1.textContains('%')) {
            return true;
        }
        if (node2.getElementType() == XmlElementType.XML_EMPTY_ELEMENT_END && node2.textContains('%')) {
            return true;
        }
        return this.myXmlFormattingPolicy.getShouldAddSpaceAroundTagName();
    }

    private boolean isSpaceInText(boolean firstIsTag, boolean secondIsTag, boolean firstIsText, boolean secondIsText) {
        return firstIsText && secondIsText || firstIsTag && secondIsTag || firstIsTag && secondIsText || firstIsText && secondIsTag;
    }

    private boolean keepWhiteSpaces() {
        return this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(this.getTag()) || this.myXmlFormattingPolicy.getShouldKeepWhiteSpaces();
    }

    protected boolean isTextFragment(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        return parent != null && parent.getElementType() == XmlElementType.XML_TEXT || node.getElementType() == XmlElementType.XML_DATA_CHARACTERS;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Block prevBlock;
        ChildAttributes childAttributes;
        if (this.isOuterLanguageBlock()) {
            childAttributes = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/SyntheticBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        List<Block> subBlocks = this.getSubBlocks();
        int prevBlockIndex = newChildIndex - 1;
        if (prevBlockIndex >= 0 && prevBlockIndex < subBlocks.size() && this.isAttributeBlock(prevBlock = subBlocks.get(newChildIndex - 1))) {
            childAttributes = new ChildAttributes(this.myChildIndent, prevBlock.getAlignment());
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/SyntheticBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        childAttributes = new ChildAttributes(this.myChildIndent, null);
        if (childAttributes != null) return childAttributes;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/SyntheticBlock.getChildAttributes must not return null");
    }

    private boolean isAttributeBlock(Block block) {
        if (block instanceof XmlBlock) {
            return ((XmlBlock)block).getNode().getElementType() == XmlElementType.XML_ATTRIBUTE;
        }
        return false;
    }

    @Override
    public boolean isIncomplete() {
        return this.getSubBlocks().get(this.getSubBlocks().size() - 1).isIncomplete();
    }

    public boolean endsWithAttribute() {
        return this.isAttributeBlock(this.getSubBlocks().get(this.getSubBlocks().size() - 1));
    }
}

