/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class DebugUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.DebugUtil");
    public static boolean CHECK = false;
    public static final boolean CHECK_INSIDE_ATOMIC_ACTION_ENABLED = false;
    public static final Key<Boolean> TRACK_INVALIDATION_KEY = new Key("TRACK_INVALIDATION_KEY");

    public static boolean shouldTrackInvalidation() {
        return false;
    }

    public static String psiTreeToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiTreeToString must not be null");
        }
        return DebugUtil.treeToString(SourceTreeToPsiMap.psiElementToTree(element), skipWhitespaces);
    }

    public static String treeToString(@NotNull ASTNode root, boolean skipWhitespaces) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.treeToString must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, false, false);
        return buffer.toString();
    }

    public static String treeToString(@NotNull ASTNode root, boolean skipWhitespaces, boolean showRanges) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.treeToString must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, showRanges, false);
        return buffer.toString();
    }

    public static String treeToStringWithUserData(TreeElement root, boolean skipWhitespaces) {
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBufferWithUserData(buffer, root, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static String treeToStringWithUserData(PsiElement root, boolean skipWhitespaces) {
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBufferWithUserData(buffer, root, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static void treeToBuffer(@NotNull StringBuilder buffer, @NotNull ASTNode root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.treeToBuffer must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.treeToBuffer must not be null");
        }
        if (skipWhiteSpaces && root.getElementType() == TokenType.WHITE_SPACE) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        if (root instanceof CompositeElement) {
            PsiElement psiElement = root.getPsi();
            if (psiElement != null) {
                buffer.append(psiElement.toString());
            } else {
                buffer.append(root.getElementType().toString());
            }
        } else {
            String text = root.getText();
            text = StringUtil.replace((String)text, (String)"\n", (String)"\\n");
            text = StringUtil.replace((String)text, (String)"\r", (String)"\\r");
            text = StringUtil.replace((String)text, (String)"\t", (String)"\\t");
            buffer.append(root.toString()).append("('").append(text).append("')");
        }
        if (showRanges) {
            buffer.append(root.getTextRange());
        }
        buffer.append("\n");
        if (root instanceof CompositeElement) {
            ASTNode child = root.getFirstChildNode();
            if (child == null) {
                for (int i = 0; i < indent + 2; ++i) {
                    buffer.append(' ');
                }
                buffer.append("<empty list>\n");
            } else {
                while (child != null) {
                    DebugUtil.treeToBuffer(buffer, child, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges);
                    child = child.getTreeNext();
                }
            }
        }
    }

    private static void treeToBufferWithUserData(StringBuilder buffer, TreeElement root, int indent, boolean skipWhiteSpaces) {
        if (skipWhiteSpaces && root.getElementType() == TokenType.WHITE_SPACE) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        if (root instanceof CompositeElement) {
            buffer.append(SourceTreeToPsiMap.treeElementToPsi(root).toString());
        } else {
            String text = root.getText();
            text = StringUtil.replace((String)text, (String)"\n", (String)"\\n");
            text = StringUtil.replace((String)text, (String)"\r", (String)"\\r");
            text = StringUtil.replace((String)text, (String)"\t", (String)"\\t");
            buffer.append(root.toString()).append("('").append(text).append("')");
        }
        buffer.append(root.getUserDataString());
        buffer.append("\n");
        if (root instanceof CompositeElement) {
            PsiElement[] children;
            for (PsiElement child : children = SourceTreeToPsiMap.treeElementToPsi(root).getChildren()) {
                DebugUtil.treeToBufferWithUserData(buffer, (TreeElement)SourceTreeToPsiMap.psiElementToTree(child), indent + 2, skipWhiteSpaces);
            }
            if (children.length == 0) {
                for (int i = 0; i < indent + 2; ++i) {
                    buffer.append(' ');
                }
                buffer.append("<empty list>\n");
            }
        }
    }

    private static void treeToBufferWithUserData(StringBuilder buffer, PsiElement root, int indent, boolean skipWhiteSpaces) {
        PsiElement[] children;
        if (skipWhiteSpaces && root instanceof PsiWhiteSpace) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        if (root instanceof CompositeElement) {
            buffer.append(root);
        } else {
            String text = root.getText();
            text = StringUtil.replace((String)text, (String)"\n", (String)"\\n");
            text = StringUtil.replace((String)text, (String)"\r", (String)"\\r");
            text = StringUtil.replace((String)text, (String)"\t", (String)"\\t");
            buffer.append(root.toString()).append("('").append(text).append("')");
        }
        buffer.append(((UserDataHolderBase)root).getUserDataString());
        buffer.append("\n");
        for (PsiElement child : children = root.getChildren()) {
            DebugUtil.treeToBufferWithUserData(buffer, child, indent + 2, skipWhiteSpaces);
        }
        if (children.length == 0) {
            for (int i = 0; i < indent + 2; ++i) {
                buffer.append(' ');
            }
            buffer.append("<empty list>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkTreeStructure(@NotNull ASTNode anyElement) {
        if (anyElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.checkTreeStructure must not be null");
        }
        ASTNode root = anyElement;
        while (root.getTreeParent() != null) {
            root = root.getTreeParent();
        }
        if (root instanceof CompositeElement) {
            Object object = PsiLock.LOCK;
            synchronized (object) {
                DebugUtil.checkSubtree((CompositeElement)root);
            }
        }
    }

    private static void checkSubtree(CompositeElement root) {
        if (root.rawFirstChild() == null) {
            if (root.rawLastChild() != null) {
                throw new IncorrectTreeStructureException(root, "firstChild == null, but lastChild != null");
            }
        } else {
            for (TreeElement child = root.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child instanceof CompositeElement) {
                    DebugUtil.checkSubtree((CompositeElement)child);
                }
                if (child.getTreeParent() != root) {
                    throw new IncorrectTreeStructureException(child, "child has wrong parent value");
                }
                if (child == root.getFirstChildNode()) {
                    if (child.getTreePrev() != null) {
                        throw new IncorrectTreeStructureException(root, "firstChild.prev != null");
                    }
                } else {
                    if (child.getTreePrev() == null) {
                        throw new IncorrectTreeStructureException(child, "not first child has prev == null");
                    }
                    if (child.getTreePrev().getTreeNext() != child) {
                        throw new IncorrectTreeStructureException(child, "element.prev.next != element");
                    }
                }
                if (child.getTreeNext() != null || root.getLastChildNode() == child) continue;
                throw new IncorrectTreeStructureException(child, "not last child has next == null");
            }
        }
    }

    public static void checkParentChildConsistent(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.checkParentChildConsistent must not be null");
        }
        ASTNode treeParent = element.getTreeParent();
        if (treeParent == null) {
            return;
        }
        Object[] elements = treeParent.getChildren(null);
        if (ArrayUtil.find((Object[])elements, (Object)element) == -1) {
            throw new IncorrectTreeStructureException(element, "child cannot be found among parents children");
        }
    }

    public static void checkSameCharTabs(@NotNull ASTNode element1, @NotNull ASTNode element2) {
        CharTable toCharTab;
        if (element1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.checkSameCharTabs must not be null");
        }
        if (element2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.checkSameCharTabs must not be null");
        }
        CharTable fromCharTab = SharedImplUtil.findCharTableByTree(element1);
        LOG.assertTrue(fromCharTab == (toCharTab = SharedImplUtil.findCharTableByTree(element2)));
    }

    public static String psiToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiToString must not be null");
        }
        return DebugUtil.psiToString(element, skipWhitespaces, false);
    }

    public static String psiToString(@NotNull PsiElement root, boolean skipWhiteSpaces, boolean showRanges) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiToString must not be null");
        }
        StringBuilder result = new StringBuilder();
        if (root.getNode() == null) {
            DebugUtil.psiToBuffer(result, root, 0, skipWhiteSpaces, showRanges, showRanges);
        } else {
            DebugUtil.treeToBuffer(result, root.getNode(), 0, skipWhiteSpaces, showRanges, showRanges);
        }
        return result.toString();
    }

    public static void psiToBuffer(@NotNull StringBuilder buffer, @NotNull PsiElement root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiToBuffer must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiToBuffer must not be null");
        }
        if (skipWhiteSpaces && root instanceof PsiWhiteSpace) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        String rootStr = root.toString();
        buffer.append(rootStr);
        PsiElement child = root.getFirstChild();
        if (child == null) {
            String text = root.getText();
            assert (text != null) : "text is null for <" + root + ">";
            text = StringUtil.replace((String)text, (String)"\n", (String)"\\n");
            text = StringUtil.replace((String)text, (String)"\r", (String)"\\r");
            text = StringUtil.replace((String)text, (String)"\t", (String)"\\t");
            buffer.append("('");
            buffer.append(text);
            buffer.append("')");
        }
        if (showRanges) {
            buffer.append(root.getTextRange());
        }
        buffer.append("\n");
        while (child != null) {
            DebugUtil.psiToBuffer(buffer, child, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges);
            child = child.getNextSibling();
        }
    }

    public static void trackInvalidation(PsiElement element) {
        if (element == null) {
            return;
        }
        element.putUserData(TRACK_INVALIDATION_KEY, (Object)Boolean.TRUE);
        ASTNode node = element.getNode();
        if (node != null) {
            node.putUserData(TRACK_INVALIDATION_KEY, (Object)Boolean.TRUE);
        }
        DebugUtil.trackInvalidation(element.getParent());
    }

    public static class IncorrectTreeStructureException
    extends RuntimeException {
        private final ASTNode myElement;

        public IncorrectTreeStructureException(ASTNode element, String message) {
            super(message);
            this.myElement = element;
        }

        public ASTNode getElement() {
            return this.myElement;
        }
    }
}

