/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.source.HierarchicalMethodSignatureImpl;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSuperMethodImplUtil {
    private static final Key<CachedValue<Map<MethodSignature, HierarchicalMethodSignature>>> SIGNATURES_KEY = Key.create((String)"MAP_KEY");

    private PsiSuperMethodImplUtil() {
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(PsiMethod method) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(method, null);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiSuperMethodImplUtil.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiMethod[] findSuperMethods(PsiMethod method, boolean checkAccess) {
        PsiMethod[] psiMethodArray;
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, false)) {
            psiMethodArray = PsiMethod.EMPTY_ARRAY;
            if (PsiMethod.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiSuperMethodImplUtil.findSuperMethods must not return null");
            return psiMethodArray;
        }
        psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method, null);
        if (psiMethodArray != null) return psiMethodArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiSuperMethodImplUtil.findSuperMethods must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiMethod[] findSuperMethods(PsiMethod method, PsiClass parentClass) {
        PsiMethod[] psiMethodArray;
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            psiMethodArray = PsiMethod.EMPTY_ARRAY;
            if (PsiMethod.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiSuperMethodImplUtil.findSuperMethods must not return null");
            return psiMethodArray;
        }
        psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method, parentClass);
        if (psiMethodArray != null) return psiMethodArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiSuperMethodImplUtil.findSuperMethods must not return null");
    }

    @NotNull
    private static PsiMethod[] findSuperMethodsInternal(PsiMethod method, PsiClass parentClass) {
        List<MethodSignatureBackedByPsiMethod> outputMethods = PsiSuperMethodImplUtil.findSuperMethodSignatures(method, parentClass, false);
        PsiMethod[] psiMethodArray = MethodSignatureUtil.convertMethodSignaturesToMethods(outputMethods);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiSuperMethodImplUtil.findSuperMethodsInternal must not return null");
        }
        return psiMethodArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(PsiMethod method, boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list;
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, true)) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic must not return null");
            return list;
        }
        list = PsiSuperMethodImplUtil.findSuperMethodSignatures(method, null, true);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic must not return null");
    }

    @NotNull
    private static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignatures(PsiMethod method, PsiClass parentClass, boolean allowStaticMethod) {
        ArrayList<MethodSignatureBackedByPsiMethod> arrayList = new ArrayList<MethodSignatureBackedByPsiMethod>(SuperMethodsSearch.search((PsiMethod)method, (PsiClass)parentClass, (boolean)true, (boolean)allowStaticMethod).findAll());
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiSuperMethodImplUtil.findSuperMethodSignatures must not return null");
        }
        return arrayList;
    }

    private static boolean canHaveSuperMethod(PsiMethod method, boolean checkAccess, boolean allowStaticMethod) {
        if (method.isConstructor()) {
            return false;
        }
        if (!allowStaticMethod && method.hasModifierProperty("static")) {
            return false;
        }
        if (checkAccess && method.hasModifierProperty("private")) {
            return false;
        }
        PsiClass parentClass = method.getContainingClass();
        return parentClass != null && !"java.lang.Object".equals(parentClass.getQualifiedName());
    }

    @Nullable
    public static PsiMethod findDeepestSuperMethod(PsiMethod method) {
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return null;
        }
        return (PsiMethod)DeepestSuperMethodsSearch.search((PsiMethod)method).findFirst();
    }

    public static PsiMethod[] findDeepestSuperMethods(PsiMethod method) {
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return PsiMethod.EMPTY_ARRAY;
        }
        Collection collection = DeepestSuperMethodsSearch.search((PsiMethod)method).findAll();
        return collection.toArray(new PsiMethod[collection.size()]);
    }

    private static Map<MethodSignature, HierarchicalMethodSignature> buildMethodHierarchy(PsiClass aClass, PsiSubstitutor substitutor, boolean includePrivates, Set<PsiClass> visited, boolean isInRawContext) {
        LinkedHashMap<MethodSignature, HierarchicalMethodSignature> result = new LinkedHashMap<MethodSignature, HierarchicalMethodSignature>();
        THashMap sameParameterErasureMethods = new THashMap(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        THashMap map = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<MethodSignature>((Map)sameParameterErasureMethods){
            final /* synthetic */ Map val$sameParameterErasureMethods;
            {
                this.val$sameParameterErasureMethods = map;
            }

            public int computeHashCode(MethodSignature signature) {
                return MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.computeHashCode((Object)signature);
            }

            public boolean equals(MethodSignature o1, MethodSignature o2) {
                boolean toCheckReturnType;
                if (!MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)o1, (Object)o2)) {
                    return false;
                }
                List list = (List)this.val$sameParameterErasureMethods.get(o1);
                boolean bl = toCheckReturnType = list != null && list.size() > 1;
                if (!toCheckReturnType) {
                    return true;
                }
                PsiType returnType1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod().getReturnType();
                PsiType returnType2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod().getReturnType();
                if (returnType1 == null && returnType2 == null) {
                    return true;
                }
                if (returnType1 == null || returnType2 == null) {
                    return false;
                }
                PsiType erasure1 = TypeConversionUtil.erasure((PsiType)o1.getSubstitutor().substitute(returnType1));
                PsiType erasure2 = TypeConversionUtil.erasure((PsiType)o2.getSubstitutor().substitute(returnType2));
                return erasure1.equals(erasure2);
            }
        });
        for (PsiMethod psiMethod : aClass.getMethods()) {
            if (!includePrivates && psiMethod.hasModifierProperty("private")) continue;
            MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)psiMethod, (PsiSubstitutor)substitutor, (boolean)isInRawContext);
            HierarchicalMethodSignatureImpl newH = new HierarchicalMethodSignatureImpl(signature);
            List list = (List)sameParameterErasureMethods.get(signature);
            if (list == null) {
                list = new SmartList();
                sameParameterErasureMethods.put(signature, list);
            }
            list.add(psiMethod);
            result.put((MethodSignature)signature, newH);
            map.put(signature, newH);
        }
        for (PsiMethod psiMethod : aClass.getSuperTypes()) {
            PsiClassType.ClassResolveResult superTypeResolveResult = psiMethod.resolveGenerics();
            PsiClass superClass = superTypeResolveResult.getElement();
            if (superClass == null || !visited.add(superClass)) continue;
            PsiSubstitutor superSubstitutor = superTypeResolveResult.getSubstitutor();
            PsiSubstitutor finalSubstitutor = PsiSuperMethodImplUtil.obtainFinalSubstitutor(superClass, superSubstitutor, substitutor, isInRawContext);
            boolean isInRawContextSuper = (isInRawContext || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)superClass, (PsiSubstitutor)superSubstitutor)) && superClass.getTypeParameters().length != 0;
            Map<MethodSignature, HierarchicalMethodSignature> superResult = PsiSuperMethodImplUtil.buildMethodHierarchy(superClass, finalSubstitutor, false, visited, isInRawContextSuper);
            visited.remove(superClass);
            ArrayList<Pair> flattened = new ArrayList<Pair>();
            for (Map.Entry<MethodSignature, HierarchicalMethodSignature> entry : superResult.entrySet()) {
                HierarchicalMethodSignature hms = entry.getValue();
                MethodSignature signature = entry.getKey();
                PsiClass containingClass = hms.getMethod().getContainingClass();
                ArrayList supers = new ArrayList(hms.getSuperSignatures());
                for (HierarchicalMethodSignature aSuper : supers) {
                    PsiClass superContainingClass = aSuper.getMethod().getContainingClass();
                    if (containingClass == null || superContainingClass == null || containingClass.isInheritor(superContainingClass, true)) continue;
                    flattened.add(new Pair((Object)signature, (Object)aSuper));
                }
                PsiSuperMethodImplUtil.putInMap(aClass, result, (Map<MethodSignature, HierarchicalMethodSignatureImpl>)map, hms, signature);
            }
            for (Pair pair : flattened) {
                PsiSuperMethodImplUtil.putInMap(aClass, result, (Map<MethodSignature, HierarchicalMethodSignatureImpl>)map, (HierarchicalMethodSignature)pair.second, (MethodSignature)pair.first);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            HierarchicalMethodSignatureImpl hierarchicalMethodSignature = (HierarchicalMethodSignatureImpl)((Object)entry.getValue());
            MethodSignature methodSignature = (MethodSignature)entry.getKey();
            if (result.get(methodSignature) != null || !PsiUtil.isAccessible((PsiMember)hierarchicalMethodSignature.getMethod(), (PsiElement)aClass, (PsiClass)aClass)) continue;
            result.put(methodSignature, hierarchicalMethodSignature);
        }
        return result;
    }

    private static void putInMap(PsiClass aClass, Map<MethodSignature, HierarchicalMethodSignature> result, Map<MethodSignature, HierarchicalMethodSignatureImpl> map, HierarchicalMethodSignature hierarchicalMethodSignature, MethodSignature signature) {
        if (!PsiUtil.isAccessible((PsiMember)hierarchicalMethodSignature.getMethod(), (PsiElement)aClass, (PsiClass)aClass)) {
            return;
        }
        HierarchicalMethodSignatureImpl existing = map.get(signature);
        if (existing == null) {
            map.put(signature, PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature));
        } else if (PsiSuperMethodImplUtil.isReturnTypeIsMoreSpecificThan(hierarchicalMethodSignature, existing) && PsiSuperMethodImplUtil.isSuperMethod(aClass, hierarchicalMethodSignature, existing)) {
            HierarchicalMethodSignatureImpl newSuper = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            PsiSuperMethodImplUtil.mergeSupers(newSuper, existing);
            map.put(signature, newSuper);
        } else if (PsiSuperMethodImplUtil.isSuperMethod(aClass, existing, hierarchicalMethodSignature)) {
            PsiSuperMethodImplUtil.mergeSupers(existing, hierarchicalMethodSignature);
        } else if (!result.containsKey(signature)) {
            result.put(signature, hierarchicalMethodSignature);
        }
    }

    private static boolean isReturnTypeIsMoreSpecificThan(@NotNull HierarchicalMethodSignature thisSig, @NotNull HierarchicalMethodSignature thatSig) {
        if (thisSig == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiSuperMethodImplUtil.isReturnTypeIsMoreSpecificThan must not be null");
        }
        if (thatSig == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiSuperMethodImplUtil.isReturnTypeIsMoreSpecificThan must not be null");
        }
        PsiType thisRet = thisSig.getMethod().getReturnType();
        PsiType thatRet = thatSig.getMethod().getReturnType();
        return thatRet != null && thisRet != null && !thatRet.equals(thisRet) && TypeConversionUtil.isAssignable((PsiType)thatRet, (PsiType)thisRet);
    }

    private static void mergeSupers(HierarchicalMethodSignatureImpl existing, HierarchicalMethodSignature superSignature) {
        for (HierarchicalMethodSignature existingSuper : existing.getSuperSignatures()) {
            if (existingSuper.getMethod() != superSignature.getMethod()) continue;
            for (HierarchicalMethodSignature signature : superSignature.getSuperSignatures()) {
                PsiSuperMethodImplUtil.mergeSupers((HierarchicalMethodSignatureImpl)existingSuper, signature);
            }
            return;
        }
        if (existing.getMethod() == superSignature.getMethod()) {
            List<HierarchicalMethodSignature> existingSupers = existing.getSuperSignatures();
            for (HierarchicalMethodSignature supers : superSignature.getSuperSignatures()) {
                if (existingSupers.contains(supers)) continue;
                existing.addSuperSignature(PsiSuperMethodImplUtil.copy(supers));
            }
        } else {
            HierarchicalMethodSignatureImpl copy = PsiSuperMethodImplUtil.copy(superSignature);
            existing.addSuperSignature(copy);
        }
    }

    private static boolean isSuperMethod(PsiClass aClass, HierarchicalMethodSignature hierarchicalMethodSignature, HierarchicalMethodSignature superSignatureHierarchical) {
        PsiMethod superMethod = superSignatureHierarchical.getMethod();
        PsiClass superClass = superMethod.getContainingClass();
        PsiClass containingClass = hierarchicalMethodSignature.getMethod().getContainingClass();
        return !superMethod.isConstructor() && !aClass.equals(superClass) && PsiUtil.isAccessible((PsiMember)superMethod, (PsiElement)aClass, (PsiClass)aClass) && MethodSignatureUtil.isSubsignature((MethodSignature)superSignatureHierarchical, (MethodSignature)hierarchicalMethodSignature) && superClass != null && (containingClass != null && containingClass.isInterface() == superClass.isInterface() || superClass.isInterface() || "java.lang.Object".equals(superClass.getQualifiedName()));
    }

    private static HierarchicalMethodSignatureImpl copy(HierarchicalMethodSignature hi) {
        HierarchicalMethodSignatureImpl hierarchicalMethodSignature = new HierarchicalMethodSignatureImpl((MethodSignatureBackedByPsiMethod)hi);
        for (HierarchicalMethodSignature his : hi.getSuperSignatures()) {
            hierarchicalMethodSignature.addSuperSignature(PsiSuperMethodImplUtil.copy(his));
        }
        return hierarchicalMethodSignature;
    }

    private static PsiSubstitutor obtainFinalSubstitutor(PsiClass superClass, PsiSubstitutor superSubstitutor, PsiSubstitutor derivedSubstitutor, boolean inRawContext) {
        if (inRawContext) {
            superSubstitutor = JavaPsiFacadeEx.getElementFactory((Project)superClass.getProject()).createRawSubstitutor(derivedSubstitutor, superSubstitutor.getSubstitutionMap().keySet().toArray(PsiTypeParameter.EMPTY_ARRAY));
        }
        THashMap map = null;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)superClass)) {
            PsiType type = superSubstitutor.substitute(typeParameter);
            PsiType t = derivedSubstitutor.substitute(type);
            if (map == null) {
                map = new THashMap();
            }
            map.put(typeParameter, t);
        }
        return map == null ? PsiSubstitutor.EMPTY : JavaPsiFacade.getInstance((Project)superClass.getProject()).getElementFactory().createSubstitutor(map);
    }

    public static Collection<HierarchicalMethodSignature> getVisibleSignatures(PsiClass aClass) {
        Map<MethodSignature, HierarchicalMethodSignature> map = PsiSuperMethodImplUtil.getSignaturesMap(aClass);
        return map.values();
    }

    @NotNull
    public static HierarchicalMethodSignature getHierarchicalMethodSignature(PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        HierarchicalMethodSignature result = null;
        if (aClass != null) {
            result = PsiSuperMethodImplUtil.getSignaturesMap(aClass).get(method.getSignature(PsiSubstitutor.EMPTY));
        }
        if (result == null) {
            result = new HierarchicalMethodSignatureImpl((MethodSignatureBackedByPsiMethod)method.getSignature(PsiSubstitutor.EMPTY));
        }
        HierarchicalMethodSignature hierarchicalMethodSignature = result;
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiSuperMethodImplUtil.getHierarchicalMethodSignature must not return null");
        }
        return hierarchicalMethodSignature;
    }

    private static Map<MethodSignature, HierarchicalMethodSignature> getSignaturesMap(PsiClass aClass) {
        CachedValue value = (CachedValue)aClass.getUserData(SIGNATURES_KEY);
        if (value == null) {
            BySignaturesCachedValueProvider provider = new BySignaturesCachedValueProvider(aClass);
            value = CachedValuesManager.getManager((Project)aClass.getProject()).createCachedValue((CachedValueProvider)provider, false);
            if (aClass.isPhysical()) {
                UserDataHolderEx dataHolder = (UserDataHolderEx)aClass;
                value = (CachedValue)dataHolder.putUserDataIfAbsent(SIGNATURES_KEY, (Object)value);
            }
        }
        return (Map)value.getValue();
    }

    private static class BySignaturesCachedValueProvider
    implements CachedValueProvider<Map<MethodSignature, HierarchicalMethodSignature>> {
        private final PsiClass myClass;

        private BySignaturesCachedValueProvider(PsiClass aClass) {
            this.myClass = aClass;
        }

        public CachedValueProvider.Result<Map<MethodSignature, HierarchicalMethodSignature>> compute() {
            Map result = PsiSuperMethodImplUtil.buildMethodHierarchy(this.myClass, PsiSubstitutor.EMPTY, true, (Set)new THashSet(), false);
            assert (result != null);
            return new CachedValueProvider.Result((Object)result, new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        }
    }
}

