/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.parsing.ImportsTextParsing;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.Parsing;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PatchedSoftReference;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.Nullable;

public class PsiImportStatementStubImpl
extends StubBase<PsiImportStatementBase>
implements PsiImportStatementStub {
    private final byte myFlags;
    private final StringRef myText;
    private PatchedSoftReference<PsiJavaCodeReferenceElement> myReference = null;
    private static final int ON_DEMAND = 1;
    private static final int STATIC = 2;

    public PsiImportStatementStubImpl(StubElement parent, String text, byte flags) {
        this(parent, StringRef.fromString((String)text), flags);
    }

    public PsiImportStatementStubImpl(StubElement parent, StringRef text, byte flags) {
        super(parent, (IStubElementType)(PsiImportStatementStubImpl.isStatic(flags) ? JavaStubElementTypes.IMPORT_STATIC_STATEMENT : JavaStubElementTypes.IMPORT_STATEMENT));
        this.myText = text;
        this.myFlags = flags;
    }

    @Override
    public boolean isStatic() {
        return PsiImportStatementStubImpl.isStatic(this.myFlags);
    }

    private static boolean isStatic(byte flags) {
        return (flags & 2) != 0;
    }

    @Override
    public boolean isOnDemand() {
        return (this.myFlags & 1) != 0;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    public String getImportReferenceText() {
        return StringRef.toString((StringRef)this.myText);
    }

    @Override
    @Nullable
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement ref;
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ref = this.myReference != null ? (PsiJavaCodeReferenceElement)this.myReference.get() : null;
        if (ref == null) {
            ref = this.isStatic() ? this.getStaticReference() : this.getRegularReference();
            this.myReference = new PatchedSoftReference<PsiJavaCodeReferenceElement>(ref);
        }
        return ref;
    }

    public static byte packFlags(boolean isOnDemand, boolean isStatic) {
        byte flags = 0;
        if (isOnDemand) {
            flags = (byte)(flags | 1);
        }
        if (isStatic) {
            flags = (byte)(flags | 2);
        }
        return flags;
    }

    @Nullable
    public PsiJavaCodeReferenceElement getStaticReference() {
        PsiManager manager = PsiManager.getInstance((Project)this.getProject());
        FileElement holderElement = DummyHolderFactory.createHolder(manager, this.getPsi()).getTreeElement();
        JavaParsingContext context = new JavaParsingContext(holderElement.getCharTable(), PsiUtil.getLanguageLevel((PsiElement)this.getPsi()));
        String refText = this.getImportReferenceText();
        if (refText == null) {
            return null;
        }
        CompositeElement parsedRef = Parsing.parseJavaCodeReferenceText(manager, refText, context.getCharTable());
        PsiJavaCodeReferenceElement refElement = (PsiJavaCodeReferenceElement)parsedRef;
        if (refElement == null) {
            return null;
        }
        boolean onDemand = this.isOnDemand();
        if (onDemand) {
            holderElement.rawAddChildren((TreeElement)refElement);
            ((PsiJavaCodeReferenceElementImpl)refElement).setKindWhenDummy(4);
        } else {
            context.getImportsTextParsing();
            refElement = (PsiImportStaticReferenceElement)ImportsTextParsing.convertToImportStaticReference(parsedRef);
            holderElement.rawAddChildren((TreeElement)refElement);
        }
        return refElement;
    }

    @Nullable
    public PsiJavaCodeReferenceElement getRegularReference() {
        PsiManager manager = PsiManager.getInstance((Project)this.getProject());
        FileElement holderElement = DummyHolderFactory.createHolder(manager, this.getPsi()).getTreeElement();
        String refText = this.getImportReferenceText();
        if (refText == null) {
            return null;
        }
        PsiJavaCodeReferenceElementImpl refElement = (PsiJavaCodeReferenceElementImpl)Parsing.parseJavaCodeReferenceText(manager, refText, holderElement.getCharTable());
        if (refElement == null) {
            return null;
        }
        holderElement.rawAddChildren(refElement);
        refElement.setKindWhenDummy(this.isOnDemand() ? 5 : 4);
        return refElement;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiImportStatementStub[");
        if (this.isStatic()) {
            builder.append("static ");
        }
        builder.append(this.getImportReferenceText());
        if (this.isOnDemand()) {
            builder.append(".*");
        }
        builder.append("]");
        return builder.toString();
    }
}

