/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfoFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnchorElementInfoFactory
implements SmartPointerElementInfoFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.AnchorElementInfoFactory");

    @Override
    @Nullable
    public SmartPointerElementInfo createElementInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/AnchorElementInfoFactory.createElementInfo must not be null");
        }
        PsiElement anchor = AnchorElementInfoFactory.getAnchor(element);
        if (anchor != null) {
            return new AnchorElementInfo(anchor);
        }
        return null;
    }

    @Nullable
    static PsiElement getAnchor(PsiElement element) {
        LOG.assertTrue(element.isValid());
        Object anchor = null;
        if (element instanceof PsiClass) {
            anchor = element instanceof PsiAnonymousClass ? ((PsiAnonymousClass)element).getBaseClassReference().getReferenceNameElement() : ((PsiClass)element).getNameIdentifier();
        } else if (element instanceof PsiMethod) {
            anchor = ((PsiMethod)element).getNameIdentifier();
        } else if (element instanceof PsiVariable) {
            anchor = ((PsiVariable)element).getNameIdentifier();
        } else if (element instanceof XmlTag) {
            anchor = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)element));
        }
        if (anchor != null && !anchor.isPhysical()) {
            return null;
        }
        return anchor;
    }
}

