/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiJavaFileBaseImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiJavaFileImpl
extends PsiJavaFileBaseImpl {
    public PsiJavaFileImpl(FileViewProvider file) {
        super((IElementType)Constants.JAVA_FILE, (IElementType)Constants.JAVA_FILE, file);
    }

    public String toString() {
        return "PsiJavaFile:" + this.getName();
    }

    public Lexer createLexer() {
        return new JavaLexer(this.getLanguageLevel());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope;
        ProjectFileIndex index;
        VirtualFile file = this.getVirtualFile();
        if (!(file == null || file instanceof LightVirtualFile || (index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex()).isInSource(file) || index.isInLibraryClasses(file))) {
            globalSearchScope = GlobalSearchScope.fileScope((PsiFile)this);
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileImpl.getResolveScope must not return null");
            return globalSearchScope;
        }
        globalSearchScope = super.getResolveScope();
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileImpl.getResolveScope must not return null");
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.JAVA;
        if (languageFileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileImpl.getFileType must not return null");
        }
        return languageFileType;
    }

    public void setPackageName(String packageName) throws IncorrectOperationException {
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        if (packageStatement != null) {
            if (packageName.length() > 0) {
                packageStatement.replace((PsiElement)factory.createPackageStatement(packageName));
            } else {
                packageStatement.delete();
            }
        } else if (packageName.length() > 0) {
            this.add((PsiElement)factory.createPackageStatement(packageName));
        }
    }
}

