/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public final class PsiReferenceListImpl
extends JavaStubPsiElement<PsiClassReferenceListStub>
implements PsiReferenceList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiReferenceListImpl");
    private static final TokenSet REFERENCE_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{Constants.JAVA_CODE_REFERENCE});

    public PsiReferenceListImpl(PsiClassReferenceListStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public PsiReferenceListImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = (PsiJavaCodeReferenceElement[])this.calcTreeElement().getChildrenAsPsiElements(REFERENCE_BIT_SET, Constants.PSI_REFERENCE_ELEMENT_ARRAY_CONSTRUCTOR);
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiReferenceListImpl.getReferenceElements must not return null");
        }
        return psiJavaCodeReferenceElementArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiClassType[] getReferencedTypes() {
        PsiClassType[] psiClassTypeArray;
        PsiClassReferenceListStub stub = (PsiClassReferenceListStub)this.getStub();
        if (stub != null) {
            psiClassTypeArray = stub.getReferencedTypes();
            if (psiClassTypeArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiReferenceListImpl.getReferencedTypes must not return null");
            return psiClassTypeArray;
        }
        PsiJavaCodeReferenceElement[] refs = this.getReferenceElements();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        PsiClassType[] types = new PsiClassType[refs.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = factory.createType(refs[i]);
        }
        psiClassTypeArray = types;
        if (types != null) return psiClassTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiReferenceListImpl.getReferencedTypes must not return null");
    }

    public PsiReferenceList.Role getRole() {
        IStubElementType tt = this.getElementType();
        if (tt == JavaElementType.EXTENDS_LIST) {
            return PsiReferenceList.Role.EXTENDS_LIST;
        }
        if (tt == JavaElementType.IMPLEMENTS_LIST) {
            return PsiReferenceList.Role.IMPLEMENTS_LIST;
        }
        if (tt == JavaElementType.THROWS_LIST) {
            return PsiReferenceList.Role.THROWS_LIST;
        }
        if (tt == JavaElementType.EXTENDS_BOUND_LIST) {
            return PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
        }
        LOG.error("Unknown element type:" + tt);
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiReferenceListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceList((PsiReferenceList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiReferenceList";
    }
}

