/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class ScriptSupportUtil {
    private static final Key<XmlTag[]> CachedScriptTagsKey = Key.create((String)"script tags");
    private static final ThreadLocal<String> ProcessingDeclarationsFlag = new ThreadLocal();
    @NonNls
    private static final String SCRIPT_TAG = "script";

    private ScriptSupportUtil() {
    }

    public static void clearCaches(XmlFile element) {
        element.putUserData(CachedScriptTagsKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processDeclarations(XmlFile element, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        XmlTag[] myCachedScriptTags = (XmlTag[])element.getUserData(CachedScriptTagsKey);
        if (myCachedScriptTags == null) {
            final ArrayList scriptTags = new ArrayList();
            XmlDocument document = HtmlUtil.getRealXmlDocument(element.getDocument());
            if (document != null) {
                XmlUtil.processXmlElements((XmlElement)document, new PsiElementProcessor(){

                    public boolean execute(PsiElement element) {
                        XmlElementDescriptor descriptor;
                        XmlTag tag;
                        if (element instanceof XmlTag && ScriptSupportUtil.SCRIPT_TAG.equalsIgnoreCase((tag = (XmlTag)element).getName()) && (descriptor = tag.getDescriptor()) != null && ScriptSupportUtil.SCRIPT_TAG.equals(descriptor.getName())) {
                            scriptTags.add(tag);
                        }
                        return true;
                    }
                }, true);
            }
            myCachedScriptTags = scriptTags.toArray(new XmlTag[scriptTags.size()]);
            element.putUserData(CachedScriptTagsKey, (Object)myCachedScriptTags);
        }
        if (ProcessingDeclarationsFlag.get() != null) {
            return true;
        }
        try {
            ProcessingDeclarationsFlag.set("");
            for (XmlTag tag : myCachedScriptTags) {
                PsiElement psiElement;
                PsiReference[] references;
                XmlAttributeValue valueElement;
                XmlAttribute attribute;
                XmlTagChild[] children;
                for (XmlTagChild child : children = tag.getValue().getChildren()) {
                    if (child.processDeclarations(processor, state, null, place)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (tag.getAttributeValue("src") == null || (attribute = tag.getAttribute("src", null)) == null || (valueElement = attribute.getValueElement()) == null || (references = valueElement.getReferences()).length <= 0 || !((psiElement = references[references.length - 1].resolve()) instanceof PsiFile) || !psiElement.isValid() || psiElement.processDeclarations(processor, state, null, place)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            ProcessingDeclarationsFlag.set(null);
        }
        return true;
    }
}

