/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.parsing.DeclarationParsing;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.ParseUtil;
import com.intellij.psi.impl.source.parsing.Parsing;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;

public class ClassBodyParsing
extends Parsing {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.ClassBodyParsing");
    public static final int CLASS = 0;
    public static final int ANNOTATION = 1;
    public static final int ENUM = 2;

    public ClassBodyParsing(JavaParsingContext context) {
        super(context);
    }

    private void parseEnumConstants(Lexer lexer, CompositeElement dummyRoot) {
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenType() == JavaTokenType.SEMICOLON) {
                dummyRoot.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                return;
            }
            if (lexer.getTokenType() == JavaTokenType.PRIVATE_KEYWORD || lexer.getTokenType() == JavaTokenType.PROTECTED_KEYWORD) {
                dummyRoot.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.semicolon", new Object[0])));
                return;
            }
            TreeElement enumConstant = this.myContext.getDeclarationParsing().parseEnumConstant(lexer);
            if (enumConstant != null) {
                dummyRoot.rawAddChildren(enumConstant);
            } else {
                dummyRoot.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0])));
            }
            if (lexer.getTokenType() == JavaTokenType.COMMA) {
                dummyRoot.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                continue;
            }
            if (lexer.getTokenType() == null || lexer.getTokenType() == JavaTokenType.SEMICOLON) continue;
            dummyRoot.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.comma.or.semicolon", new Object[0])));
            return;
        }
    }

    private void parseClassBodyDeclarations(int context, Lexer filterLexer, CompositeElement dummyRoot) {
        IElementType tokenType;
        CompositeElement invalidElementsGroup = null;
        DeclarationParsing.Context declarationParsingContext = ClassBodyParsing.calcDeclarationContext(context);
        while ((tokenType = filterLexer.getTokenType()) != null && tokenType != JavaTokenType.RBRACE) {
            CompositeElement ref;
            if (tokenType == JavaTokenType.SEMICOLON) {
                dummyRoot.rawAddChildren(ParseUtil.createTokenElement(filterLexer, this.myContext.getCharTable()));
                filterLexer.advance();
                invalidElementsGroup = null;
                continue;
            }
            TreeElement declaration = this.myContext.getDeclarationParsing().parseDeclaration(filterLexer, declarationParsingContext);
            if (declaration != null) {
                dummyRoot.rawAddChildren(declaration);
                invalidElementsGroup = null;
                continue;
            }
            if (invalidElementsGroup == null) {
                invalidElementsGroup = Factory.createErrorElement(JavaErrorMessages.message("unexpected.token", new Object[0]));
                dummyRoot.rawAddChildren(invalidElementsGroup);
            }
            if ((ref = this.parseJavaCodeReference(filterLexer, true, true, false)) != null) {
                invalidElementsGroup.rawAddChildren(ref);
                continue;
            }
            invalidElementsGroup.rawAddChildren(ParseUtil.createTokenElement(filterLexer, this.myContext.getCharTable()));
            filterLexer.advance();
        }
    }

    private static DeclarationParsing.Context calcDeclarationContext(int context) {
        DeclarationParsing.Context declarationParsingContext = DeclarationParsing.Context.CLASS_CONTEXT;
        switch (context) {
            default: {
                LOG.assertTrue(false);
                break;
            }
            case 0: 
            case 2: {
                declarationParsingContext = DeclarationParsing.Context.CLASS_CONTEXT;
                break;
            }
            case 1: {
                declarationParsingContext = DeclarationParsing.Context.ANNOTATION_INTERFACE_CONTEXT;
            }
        }
        return declarationParsingContext;
    }

    public void parseClassBody(CompositeElement root, Lexer lexer, int context) {
        if (context == 2) {
            this.parseEnumConstants(lexer, root);
        }
        this.parseClassBodyDeclarations(context, lexer, root);
    }
}

