/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.ParseUtil;
import com.intellij.psi.impl.source.parsing.Parsing;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nullable;

public class ImportsTextParsing
extends Parsing {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.ImportsTextParsing");
    private static final TokenSet IMPORT_LIST_STOPPER_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.CLASS_KEYWORD, JavaTokenType.INTERFACE_KEYWORD, JavaTokenType.ENUM_KEYWORD, JavaTokenType.AT});

    public ImportsTextParsing(JavaParsingContext context) {
        super(context);
    }

    public void parseImportStatements(Lexer filterLexer, CompositeElement parentNode) {
        IElementType tt;
        CompositeElement invalidElementsGroup = null;
        while ((tt = filterLexer.getTokenType()) != null && !IMPORT_LIST_STOPPER_BIT_SET.contains(tt) && !ElementType.MODIFIER_BIT_SET.contains(tt)) {
            TreeElement element = (TreeElement)this.parseImportStatement(filterLexer);
            if (element != null) {
                parentNode.rawAddChildren(element);
                invalidElementsGroup = null;
                continue;
            }
            if (invalidElementsGroup == null) {
                invalidElementsGroup = Factory.createErrorElement(JavaErrorMessages.message("unexpected.token", new Object[0]));
                parentNode.rawAddChildren(invalidElementsGroup);
            }
            invalidElementsGroup.rawAddChildren(ParseUtil.createTokenElement(filterLexer, this.myContext.getCharTable()));
            filterLexer.advance();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private ASTNode parseImportStatement(Lexer lexer) {
        boolean isStatic;
        CompositeElement statement;
        if (lexer.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
            return null;
        }
        TreeElement importToken = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
        lexer.advance();
        if (lexer.getTokenType() != JavaTokenType.STATIC_KEYWORD) {
            statement = ASTFactory.composite(JavaElementType.IMPORT_STATEMENT);
            statement.rawAddChildren(importToken);
            isStatic = false;
        } else {
            statement = ASTFactory.composite(JavaElementType.IMPORT_STATIC_STATEMENT);
            statement.rawAddChildren(importToken);
            statement.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            isStatic = true;
        }
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            statement.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0])));
            return statement;
        }
        CompositeElement refElement = this.parseJavaCodeReference(lexer, true, false, false);
        TreeElement refParameterList = refElement.getLastChildNode();
        if (refParameterList.getTreePrev().getElementType() == TokenType.ERROR_ELEMENT) {
            ASTNode qualifier = refElement.findChildByRole(54);
            LOG.assertTrue(qualifier != null);
            refParameterList.getTreePrev().rawRemove();
            refParameterList.rawRemove();
            statement.rawAddChildren((TreeElement)qualifier);
            if (lexer.getTokenType() != JavaTokenType.ASTERISK) {
                statement.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("import.statement.identifier.or.asterisk.expected.", new Object[0])));
                return statement;
            }
            statement.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        } else {
            if (isStatic) {
                refElement = ImportsTextParsing.convertToImportStaticReference(refElement);
            }
            statement.rawAddChildren(refElement);
        }
        if (lexer.getTokenType() == JavaTokenType.SEMICOLON) {
            statement.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            return statement;
        }
        statement.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.semicolon", new Object[0])));
        return statement;
    }

    public static CompositeElement convertToImportStaticReference(CompositeElement refElement) {
        CompositeElement importStaticReference = ASTFactory.composite(JavaElementType.IMPORT_STATIC_REFERENCE);
        CompositeElement referenceParameterList = (CompositeElement)refElement.findChildByRole(246);
        importStaticReference.rawAddChildren(refElement.getFirstChildNode());
        if (referenceParameterList != null) {
            if (referenceParameterList.getFirstChildNode() == null) {
                referenceParameterList.rawRemove();
            } else {
                CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("unexpected.token", new Object[0]));
                referenceParameterList.rawReplaceWithList(errorElement);
                errorElement.rawAddChildren(referenceParameterList);
            }
        }
        refElement = importStaticReference;
        return refElement;
    }
}

