/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackagePrefixFileSystemItem;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FilePathReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(PsiElement element, String text, int offset, final boolean soft) {
        PsiReference[] psiReferenceArray = new FileReferenceSet(text, element, offset, this, true){

            @Override
            protected boolean isSoft() {
                return soft;
            }

            @Override
            public boolean isAbsolutePathReference() {
                return true;
            }

            @Override
            public boolean couldBeConvertedTo(boolean relative) {
                return !relative;
            }

            @Override
            public boolean absoluteUrlNeedsStartSlash() {
                String s = this.getPathString();
                return s != null && s.length() > 0 && s.charAt(0) == '/';
            }

            @Override
            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
                Collection<PsiFileSystemItem> collection = FilePathReferenceProvider.getRoots(module, true);
                if (collection == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider$1.computeDefaultContexts must not return null");
                }
                return collection;
            }

            @Override
            public FileReference createFileReference(TextRange range, int index, String text) {
                return FilePathReferenceProvider.this.createFileReference(this, range, index, text);
            }

            @Override
            protected Condition<PsiElement> createCondition() {
                return new Condition<PsiElement>(){

                    public boolean value(PsiElement element) {
                        return FilePathReferenceProvider.this.isPsiElementAccepted(element);
                    }
                };
            }
        }.getAllReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider.getReferencesByElement must not return null");
        }
        return psiReferenceArray;
    }

    protected boolean isPsiElementAccepted(PsiElement element) {
        return !(element instanceof PsiJavaFile) || !(element instanceof PsiCompiledElement);
    }

    protected FileReference createFileReference(FileReferenceSet referenceSet, TextRange range, int index, String text) {
        return new FileReference(referenceSet, range, index, text);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        Object value;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider.getReferencesByElement must not be null");
        }
        String text = null;
        if (element instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)element).getValue()) instanceof String) {
            text = (String)value;
        }
        if (text == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider.getReferencesByElement must not return null");
            return psiReferenceArray;
        }
        psiReferenceArray = this.getReferencesByElement(element, text, 1, true);
        if (psiReferenceArray != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider.getReferencesByElement must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Collection<PsiFileSystemItem> getRoots(Module thisModule, boolean includingClasses) {
        List<PsiFileSystemItem> list;
        if (thisModule == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider.getRoots must not return null");
            return list;
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(thisModule);
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)thisModule);
        modules.addAll(Arrays.asList(moduleRootManager.getDependencies()));
        ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
        PsiManager psiManager = PsiManager.getInstance((Project)thisModule.getProject());
        if (includingClasses) {
            VirtualFile[] libraryUrls;
            for (VirtualFile file : libraryUrls = moduleRootManager.getFiles(OrderRootType.CLASSES)) {
                PsiDirectory directory = psiManager.findDirectory(file);
                if (directory == null) continue;
                result.add((PsiFileSystemItem)directory);
            }
        }
        Iterator i$ = modules.iterator();
        block1: while (true) {
            VirtualFile[] sourceRoots;
            if (!i$.hasNext()) {
                list = result;
                if (list != null) return list;
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider.getRoots must not return null");
            }
            Module module = (Module)i$.next();
            moduleRootManager = ModuleRootManager.getInstance((Module)module);
            VirtualFile[] arr$ = sourceRoots = moduleRootManager.getSourceRoots();
            int len$ = arr$.length;
            int i$2 = 0;
            while (true) {
                if (i$2 >= len$) continue block1;
                VirtualFile root = arr$[i$2];
                PsiDirectory directory = psiManager.findDirectory(root);
                if (directory != null) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
                    if (aPackage != null && aPackage.getName() != null) {
                        result.add(PackagePrefixFileSystemItem.create(directory));
                    } else {
                        result.add((PsiFileSystemItem)directory);
                    }
                }
                ++i$2;
            }
            break;
        }
    }
}

