/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class OwnBufferLeafPsiElement
extends LeafElement
implements PsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.LeafPsiElement");

    public OwnBufferLeafPsiElement(IElementType type, CharSequence text) {
        super(type, text);
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.getChildren must not return null");
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement getFirstChild() {
        return null;
    }

    public PsiElement getLastChild() {
        return null;
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.acceptChildren must not be null");
        }
    }

    public PsiElement getParent() {
        return SharedImplUtil.getParent(this);
    }

    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this);
    }

    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this);
    }

    public PsiFile getContainingFile() {
        PsiFile file = SharedImplUtil.getContainingFile(this);
        if (file == null || !file.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return file;
    }

    public PsiElement findElementAt(int offset) {
        return this;
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    public PsiElement copy() {
        ASTNode elementCopy = this.copyElement();
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public boolean isValid() {
        return SharedImplUtil.isValid(this);
    }

    public boolean isWritable() {
        return SharedImplUtil.isWritable(this);
    }

    public PsiReference getReference() {
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.add must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.addBefore must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.addAfter must not be null");
        }
        throw new IncorrectOperationException();
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.checkAdd must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.addRangeBefore must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        LOG.assertTrue(this.getTreeParent() != null);
        CheckUtil.checkWritable(this);
        this.getTreeParent().deleteChildInternal(this);
        this.invalidate();
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.replace must not be null");
        }
        LOG.assertTrue(this.getTreeParent() != null);
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        this.getTreeParent().replaceChildInternal(this, elementCopy);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        PsiElement result = SourceTreeToPsiMap.treeElementToPsi(elementCopy);
        this.invalidate();
        return result;
    }

    @Override
    public String toString() {
        return "PsiElement(" + this.getElementType().toString() + ")";
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.accept must not be null");
        }
        visitor.visitElement((PsiElement)this);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.processDeclarations must not be null");
        }
        return true;
    }

    public PsiElement getContext() {
        return this.getParent();
    }

    public PsiElement getNavigationElement() {
        return this;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    public boolean isPhysical() {
        PsiFile file = this.getContainingFile();
        return file != null && file.isPhysical();
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.getManager().getFileManager().getResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = this.getManager().getFileManager().getUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/OwnBufferLeafPsiElement.getLanguage must not return null");
        }
        return language;
    }

    public ASTNode getNode() {
        return this;
    }

    @Override
    public PsiElement getPsi() {
        return this;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

