/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.LanguagePerFileConfigurable;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataLanguageConfigurable
extends LanguagePerFileConfigurable<Language> {
    public static TemplateDataLanguageConfigurable getInstance(Project project) {
        return (TemplateDataLanguageConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, TemplateDataLanguageConfigurable.class);
    }

    public TemplateDataLanguageConfigurable(Project project) {
        super(project, Language.class, TemplateDataLanguageMappings.getInstance(project), LangBundle.message("dialog.template.data.language.caption", new Object[0]), LangBundle.message("template.data.language.configurable.tree.table.title", new Object[0]), LangBundle.message("template.data.language.override.warning.text", new Object[0]), LangBundle.message("template.data.language.override.warning.title", new Object[0]));
    }

    @Override
    protected boolean handleDefaultValue(VirtualFile file, ColoredTableCellRenderer renderer) {
        Language language = TemplateDataLanguagePatterns.getInstance().getTemplateDataLanguageByFileName(file);
        if (language != null) {
            renderer.append(this.visualize(language), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            return true;
        }
        return false;
    }

    @Nls
    public String getDisplayName() {
        return LangBundle.message("template.data.language.configurable", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableFileTypes.png");
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.template.languages";
    }

    @Override
    protected String visualize(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/templateLanguages/TemplateDataLanguageConfigurable.visualize must not be null");
        }
        return language.getDisplayName();
    }
}

