/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.extapi.psi.MetadataPsiElementBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.WeighingComparable;
import com.intellij.psi.WeighingService;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityStatistician;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.containers.FactoryMap;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class PsiProximityComparator
implements Comparator<Object> {
    public static final Key<ProximityStatistician> STATISTICS_KEY = Key.create((String)"proximity");
    public static final Key<ProximityWeigher> WEIGHER_KEY = Key.create((String)"proximity");
    private final PsiElement myContext;
    private final FactoryMap<PsiElement, WeighingComparable<PsiElement, ProximityLocation>> myProximities = new FactoryMap<PsiElement, WeighingComparable<PsiElement, ProximityLocation>>(){

        protected WeighingComparable<PsiElement, ProximityLocation> create(PsiElement key) {
            return PsiProximityComparator.getProximity(key, PsiProximityComparator.this.myContext);
        }
    };

    public PsiProximityComparator(PsiElement context) {
        this.myContext = context;
    }

    @Override
    public int compare(Object o1, Object o2) {
        PsiElement element2;
        PsiElement element1 = o1 instanceof PsiElement ? (PsiElement)o1 : null;
        PsiElement psiElement = element2 = o2 instanceof PsiElement ? (PsiElement)o2 : null;
        if (element1 == null) {
            return element2 == null ? 0 : 1;
        }
        if (element2 == null) {
            return -1;
        }
        WeighingComparable proximity1 = (WeighingComparable)this.myProximities.get((Object)element1);
        WeighingComparable proximity2 = (WeighingComparable)this.myProximities.get((Object)element2);
        if (proximity1 == null || proximity2 == null) {
            return 0;
        }
        if (!proximity1.equals(proximity2)) {
            return -proximity1.compareTo(proximity2);
        }
        Module contextModule = ModuleUtil.findModuleForPsiElement((PsiElement)this.myContext);
        if (contextModule == null) {
            return 0;
        }
        StatisticsManager statisticsManager = StatisticsManager.getInstance();
        ProximityLocation location = new ProximityLocation(this.myContext, contextModule);
        int count1 = statisticsManager.getUseCount(STATISTICS_KEY, (Object)element1, (Object)location);
        int count2 = statisticsManager.getUseCount(STATISTICS_KEY, (Object)element1, (Object)location);
        return count2 - count1;
    }

    @Nullable
    public static WeighingComparable<PsiElement, ProximityLocation> getProximity(PsiElement element, PsiElement context) {
        if (element == null) {
            return null;
        }
        if (element instanceof MetadataPsiElementBase) {
            return null;
        }
        if (context == null) {
            return null;
        }
        Module contextModule = ModuleUtil.findModuleForPsiElement((PsiElement)context);
        if (contextModule == null) {
            return null;
        }
        return WeighingService.weigh(WEIGHER_KEY, (Object)element, (Object)new ProximityLocation(context, contextModule));
    }
}

