/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractInterface.ExtractClassUtil;
import com.intellij.refactoring.extractInterface.ExtractInterfaceDialog;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPullUp.PullUpHelper;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ExtractInterfaceHandler
implements RefactoringActionHandler,
ElementsHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.extractInterface.ExtractInterfaceHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.interface.title");
    private Project myProject;
    private PsiClass myClass;
    private String myInterfaceName;
    private MemberInfo[] mySelectedMembers;
    private PsiDirectory myTargetDir;
    private DocCommentPolicy myJavaDocPolicy;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractInterface/ExtractInterfaceHandler.invoke must not be null");
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractInterface");
                return;
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractInterface/ExtractInterfaceHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/extractInterface/ExtractInterfaceHandler.invoke must not be null");
        }
        if (elements.length != 1) {
            return;
        }
        this.myProject = project;
        this.myClass = (PsiClass)elements[0];
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)this.myClass)) {
            return;
        }
        final ExtractInterfaceDialog dialog = new ExtractInterfaceDialog(this.myProject, this.myClass);
        dialog.show();
        if (!dialog.isOK() || !dialog.isExtractSuperclass()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ExtractInterfaceHandler.this.myInterfaceName = dialog.getExtractedSuperName();
                        ExtractInterfaceHandler.access$102(ExtractInterfaceHandler.this, dialog.getSelectedMembers());
                        ExtractInterfaceHandler.this.myTargetDir = dialog.getTargetDirectory();
                        ExtractInterfaceHandler.this.myJavaDocPolicy = new DocCommentPolicy(dialog.getJavaDocPolicy());
                        try {
                            ExtractInterfaceHandler.this.doRefactoring();
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, REFACTORING_NAME, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefactoring() throws IncorrectOperationException {
        LocalHistoryAction a = LocalHistory.startAction((Project)this.myProject, (String)this.getCommandName());
        PsiClass anInterface = null;
        try {
            anInterface = ExtractInterfaceHandler.extractInterface(this.myTargetDir, this.myClass, this.myInterfaceName, this.mySelectedMembers, this.myJavaDocPolicy);
        }
        finally {
            a.finish();
        }
        if (anInterface != null) {
            ExtractClassUtil.askAndTurnRefsToSuper(this.myProject, this.myClass, anInterface);
        }
    }

    static PsiClass extractInterface(PsiDirectory targetDir, PsiClass aClass, String interfaceName, MemberInfo[] selectedMembers, DocCommentPolicy javaDocPolicy) throws IncorrectOperationException {
        PsiReferenceList referenceList;
        PsiClass anInterface = JavaDirectoryService.getInstance().createInterface(targetDir, interfaceName);
        PsiJavaCodeReferenceElement ref = ExtractSuperClassUtil.createExtendingReference(anInterface, aClass, selectedMembers);
        PsiReferenceList psiReferenceList = referenceList = aClass.isInterface() ? aClass.getExtendsList() : aClass.getImplementsList();
        assert (referenceList != null);
        referenceList.add((PsiElement)ref);
        PullUpHelper pullUpHelper = new PullUpHelper(aClass, anInterface, selectedMembers, javaDocPolicy);
        pullUpHelper.moveMembersToBase();
        return anInterface;
    }

    private String getCommandName() {
        return RefactoringBundle.message((String)"extract.interface.command.name", (Object[])new Object[]{this.myInterfaceName, UsageViewUtil.getDescriptiveName((PsiElement)this.myClass)});
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }

    static /* synthetic */ MemberInfo[] access$102(ExtractInterfaceHandler x0, MemberInfo[] x1) {
        x0.mySelectedMembers = x1;
        return x1;
    }
}

