/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseProcessor;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.IncorrectOperationException;

public class ExtractSuperClassProcessor
extends ExtractSuperBaseProcessor {
    public ExtractSuperClassProcessor(Project project, PsiDirectory targetDirectory, String newClassName, PsiClass aClass, MemberInfo[] memberInfos, boolean replaceInstanceOf, DocCommentPolicy javaDocPolicy) {
        super(project, replaceInstanceOf, targetDirectory, newClassName, aClass, memberInfos, javaDocPolicy);
    }

    @Override
    protected PsiClass extractSuper(String superClassName) throws IncorrectOperationException {
        return ExtractSuperClassUtil.extractSuperClass(this.myProject, this.myTargetDirectory, superClassName, this.myClass, this.myMemberInfos, this.myJavaDocPolicy);
    }

    @Override
    protected boolean isSuperInheritor(PsiClass aClass) {
        if (!aClass.isInterface()) {
            return this.myClass.isInheritor(aClass, true);
        }
        return this.doesAnyExtractedInterfaceExtends(aClass);
    }

    @Override
    protected boolean isInSuper(PsiElement member) {
        if (member instanceof PsiField) {
            PsiClass containingClass = ((PsiField)member).getContainingClass();
            if (this.myClass.isInheritor(containingClass, true)) {
                return true;
            }
            PsiField field = (PsiField)member;
            return this.doMemberInfosContain(field);
        }
        if (member instanceof PsiMethod) {
            PsiMethod methodBySignature;
            PsiMethod method = (PsiMethod)member;
            PsiClass currentSuperClass = this.myClass.getSuperClass();
            if (currentSuperClass != null && (methodBySignature = currentSuperClass.findMethodBySignature(method, true)) != null) {
                return true;
            }
            return this.doMemberInfosContain(method);
        }
        return false;
    }
}

