/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.JavaRefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.JavaRefactoringListenerManagerImpl;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PullUpHelper
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.memberPullUp.PullUpHelper");
    private final PsiClass mySourceClass;
    private final PsiClass myTargetSuperClass;
    private final boolean myIsTargetInterface;
    private final MemberInfo[] myMembersToMove;
    private final DocCommentPolicy myJavaDocPolicy;
    private HashSet<PsiMember> myMembersAfterMove = null;
    private final PsiManager myManager;

    public PullUpHelper(PsiClass sourceClass, PsiClass targetSuperClass, MemberInfo[] membersToMove, DocCommentPolicy javaDocPolicy) {
        super(sourceClass.getProject());
        this.mySourceClass = sourceClass;
        this.myTargetSuperClass = targetSuperClass;
        this.myMembersToMove = membersToMove;
        this.myJavaDocPolicy = javaDocPolicy;
        this.myIsTargetInterface = targetSuperClass.isInterface();
        this.myManager = this.mySourceClass.getManager();
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new PullUpUsageViewDescriptor();
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray = new UsageInfo[]{};
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/memberPullUp/PullUpHelper.findUsages must not return null");
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        this.moveMembersToBase();
        this.moveFieldInitializations();
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"pullUp.command", (Object[])new Object[]{UsageViewUtil.getDescriptiveName((PsiElement)this.mySourceClass)});
    }

    public void moveMembersToBase() throws IncorrectOperationException {
        HashSet<PsiMember> movedMembers = new HashSet<PsiMember>();
        this.myMembersAfterMove = new HashSet();
        for (MemberInfo info : this.myMembersToMove) {
            movedMembers.add((PsiMember)info.getMember());
        }
        for (MemberInfo info : this.myMembersToMove) {
            if (info.getMember() instanceof PsiClass && info.getOverrides() != null) continue;
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)info.getMember();
            if (this.myIsTargetInterface) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)modifierListOwner, (String)"public", (boolean)true);
            } else if (modifierListOwner.hasModifierProperty("private") && (info.isToAbstract() || PullUpHelper.willBeUsedInSubclass((PsiElement)modifierListOwner, movedMembers, this.myTargetSuperClass, this.mySourceClass))) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)modifierListOwner, (String)"protected", (boolean)true);
            }
            ChangeContextUtil.encodeContextInfo(info.getMember(), true);
        }
        for (MemberInfo info : this.myMembersToMove) {
            if (info.getMember() instanceof PsiMethod) {
                PsiMember movedElement;
                PsiMethod method = (PsiMethod)info.getMember();
                boolean isOriginalMethodAbstract = method.hasModifierProperty("abstract");
                if (this.myIsTargetInterface || info.isToAbstract()) {
                    PsiMethod methodCopy = (PsiMethod)method.copy();
                    ChangeContextUtil.clearContextInfo((PsiElement)method);
                    RefactoringUtil.abstractizeMethod(this.myTargetSuperClass, methodCopy);
                    if (method.findDeepestSuperMethods().length == 0 || this.myTargetSuperClass.isInterface() && !PsiUtil.isLanguageLevel6OrHigher((PsiElement)this.mySourceClass)) {
                        PullUpHelper.deleteOverrideAnnotationIfFound(methodCopy);
                    }
                    this.myJavaDocPolicy.processCopiedJavaDoc(methodCopy.getDocComment(), method.getDocComment(), isOriginalMethodAbstract);
                    movedElement = (PsiMember)this.myTargetSuperClass.add((PsiElement)methodCopy);
                    CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)method.getProject());
                    if (styleSettings.INSERT_OVERRIDE_ANNOTATION && (PsiUtil.isLanguageLevel5OrHigher((PsiElement)this.mySourceClass) && !this.myTargetSuperClass.isInterface() || PsiUtil.isLanguageLevel6OrHigher((PsiElement)this.mySourceClass))) {
                        new AddAnnotationFix(Override.class.getName(), (PsiModifierListOwner)method, new String[0]).invoke(method.getProject(), null, this.mySourceClass.getContainingFile());
                    }
                    if (!PsiUtil.isLanguageLevel6OrHigher((PsiElement)this.mySourceClass) && this.myTargetSuperClass.isInterface()) {
                        if (isOriginalMethodAbstract) {
                            for (PsiMethod oMethod : OverridingMethodsSearch.search((PsiMethod)method)) {
                                PullUpHelper.deleteOverrideAnnotationIfFound(oMethod);
                            }
                        }
                        PullUpHelper.deleteOverrideAnnotationIfFound(method);
                    }
                    this.myMembersAfterMove.add(movedElement);
                    if (!isOriginalMethodAbstract) continue;
                    method.delete();
                    continue;
                }
                if (isOriginalMethodAbstract) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)this.myTargetSuperClass, (String)"abstract", (boolean)true);
                }
                this.fixReferencesToStatic((PsiElement)method, movedMembers);
                PsiMethod superClassMethod = this.myTargetSuperClass.findMethodBySignature(method, false);
                if (superClassMethod != null && superClassMethod.hasModifierProperty("abstract")) {
                    superClassMethod.replace((PsiElement)method);
                } else {
                    movedElement = (PsiMember)this.myTargetSuperClass.add((PsiElement)method);
                    this.myMembersAfterMove.add(movedElement);
                }
                method.delete();
                continue;
            }
            if (info.getMember() instanceof PsiField) {
                PsiField field = (PsiField)info.getMember();
                field.normalizeDeclaration();
                this.fixReferencesToStatic((PsiElement)field, movedMembers);
                if (this.myIsTargetInterface) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"public", (boolean)true);
                }
                PsiMember movedElement = (PsiMember)this.myTargetSuperClass.add((PsiElement)field);
                this.myMembersAfterMove.add(movedElement);
                field.delete();
                continue;
            }
            if (!(info.getMember() instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)info.getMember();
            if (Boolean.FALSE.equals(info.getOverrides())) {
                PsiReferenceList referenceList;
                PsiJavaCodeReferenceElement ref;
                PsiReferenceList sourceReferenceList = info.getSourceReferenceList();
                LOG.assertTrue(sourceReferenceList != null);
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ref = this.mySourceClass.equals(sourceReferenceList.getParent()) ? RefactoringUtil.removeFromReferenceList(sourceReferenceList, aClass) : RefactoringUtil.findReferenceToClass(sourceReferenceList, aClass);
                if (ref == null) continue;
                PsiReferenceList psiReferenceList = referenceList = this.myTargetSuperClass.isInterface() ? this.myTargetSuperClass.getExtendsList() : this.myTargetSuperClass.getImplementsList();
                assert (referenceList != null);
                referenceList.add((PsiElement)ref);
                continue;
            }
            this.fixReferencesToStatic((PsiElement)aClass, movedMembers);
            PsiMember movedElement = (PsiMember)this.myTargetSuperClass.add((PsiElement)aClass);
            this.myMembersAfterMove.add(movedElement);
            aClass.delete();
        }
        ExplicitSuperDeleter explicitSuperDeleter = new ExplicitSuperDeleter();
        for (PsiMember member : this.myMembersAfterMove) {
            member.accept((PsiElementVisitor)explicitSuperDeleter);
        }
        explicitSuperDeleter.fixSupers();
        QualifiedThisSuperAdjuster qualifiedThisSuperAdjuster = new QualifiedThisSuperAdjuster();
        for (PsiMember member : this.myMembersAfterMove) {
            member.accept((PsiElementVisitor)qualifiedThisSuperAdjuster);
        }
        ChangeContextUtil.decodeContextInfo((PsiElement)this.myTargetSuperClass, null, null);
        for (PsiMember movedMember : this.myMembersAfterMove) {
            JavaRefactoringListenerManager listenerManager = JavaRefactoringListenerManager.getInstance((Project)movedMember.getProject());
            ((JavaRefactoringListenerManagerImpl)listenerManager).fireMemberMoved(this.mySourceClass, movedMember);
        }
    }

    private static void deleteOverrideAnnotationIfFound(PsiMethod oMethod) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)oMethod, (String[])new String[]{Override.class.getName()});
        if (annotation != null) {
            annotation.delete();
        }
    }

    public void moveFieldInitializations() throws IncorrectOperationException {
        LOG.assertTrue(this.myMembersAfterMove != null);
        LinkedHashSet<PsiField> movedFields = new LinkedHashSet<PsiField>();
        for (PsiMember member : this.myMembersAfterMove) {
            if (!(member instanceof PsiField)) continue;
            movedFields.add((PsiField)member);
        }
        if (movedFields.isEmpty()) {
            return;
        }
        PsiMethod[] constructors = this.myTargetSuperClass.getConstructors();
        if (constructors.length == 0) {
            constructors = new PsiMethod[]{null};
        }
        HashMap<PsiMethod, HashSet<PsiMethod>> constructorsToSubConstructors = this.buildConstructorsToSubConstructorsMap(constructors);
        for (PsiMethod constructor : constructors) {
            HashSet subConstructors = (HashSet)constructorsToSubConstructors.get((Object)constructor);
            this.tryToMoveInitializers(constructor, subConstructors, movedFields);
        }
    }

    private void tryToMoveInitializers(PsiMethod constructor, HashSet<PsiMethod> subConstructors, LinkedHashSet<PsiField> movedFields) throws IncorrectOperationException {
        final LinkedHashMap<PsiField, Initializer> fieldsToInitializers = new LinkedHashMap<PsiField, Initializer>();
        boolean anyFound = false;
        for (PsiField field : movedFields) {
            PsiMethod subConstructor;
            PsiStatement commonInitializer = null;
            ArrayList<PsiElement> fieldInitializersToRemove = new ArrayList<PsiElement>();
            Iterator<PsiMethod> i$ = subConstructors.iterator();
            while (i$.hasNext() && (commonInitializer = this.hasCommonInitializer(commonInitializer, subConstructor = i$.next(), field, fieldInitializersToRemove)) != null) {
            }
            if (commonInitializer == null) continue;
            ParametersAndMovedFieldsUsedCollector visitor = new ParametersAndMovedFieldsUsedCollector(movedFields);
            commonInitializer.accept((PsiElementVisitor)visitor);
            fieldsToInitializers.put(field, new Initializer(commonInitializer, visitor.getUsedFields(), visitor.getUsedParameters(), fieldInitializersToRemove));
            anyFound = true;
        }
        if (!anyFound) {
            return;
        }
        final Set initializedFields = fieldsToInitializers.keySet();
        Set<PsiField> unmovable = RefactoringUtil.transitiveClosure(new RefactoringUtil.Graph<PsiField>(){

            @Override
            public Set<PsiField> getVertices() {
                return initializedFields;
            }

            @Override
            public Set<PsiField> getTargets(PsiField source) {
                return ((Initializer)fieldsToInitializers.get((Object)source)).movedFieldsUsed;
            }
        }, new Condition<PsiField>(){

            public boolean value(PsiField object) {
                return !initializedFields.contains(object);
            }
        });
        for (PsiField psiField : unmovable) {
            fieldsToInitializers.remove(psiField);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        if (constructor == null) {
            constructor = (PsiMethod)this.myTargetSuperClass.add((PsiElement)factory.createConstructor());
            String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myTargetSuperClass.getModifierList());
            PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)visibilityModifier, (boolean)true);
        }
        ArrayList initializedFields2 = new ArrayList(fieldsToInitializers.keySet());
        Collections.sort(initializedFields2, new Comparator<PsiField>(){

            @Override
            public int compare(PsiField field1, PsiField field2) {
                Initializer i1 = (Initializer)fieldsToInitializers.get(field1);
                Initializer i2 = (Initializer)fieldsToInitializers.get(field2);
                if (i1.movedFieldsUsed.contains(field2)) {
                    return 1;
                }
                if (i2.movedFieldsUsed.contains(field1)) {
                    return -1;
                }
                return 0;
            }
        });
        for (PsiField initializedField : initializedFields2) {
            Initializer initializer = (Initializer)fieldsToInitializers.get(initializedField);
            PsiParameterList parameterList = constructor.getParameterList();
            for (PsiParameter parameter : initializer.usedParameters) {
                parameterList.add((PsiElement)parameter);
            }
            for (PsiMethod subConstructor : subConstructors) {
                PullUpHelper.modifySuperCall(subConstructor, initializer.usedParameters);
            }
            PsiStatement assignmentStatement = (PsiStatement)constructor.getBody().add((PsiElement)initializer.initializer);
            ChangeContextUtil.decodeContextInfo((PsiElement)assignmentStatement, this.myTargetSuperClass, (PsiExpression)RefactoringUtil.createThisExpression(this.myManager, null));
            for (PsiElement psiElement : initializer.statementsToRemove) {
                psiElement.delete();
            }
        }
    }

    private static void modifySuperCall(PsiMethod subConstructor, Set<PsiParameter> parametersToPassToSuper) {
        PsiCodeBlock body = subConstructor.getBody();
        if (body != null) {
            PsiMethodCallExpression methodCall;
            PsiExpression expression;
            PsiMethodCallExpression superCall = null;
            PsiStatement[] statements = body.getStatements();
            if (statements.length > 0 && statements[0] instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && "super".equals((methodCall = (PsiMethodCallExpression)expression).getMethodExpression().getText())) {
                superCall = methodCall;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)subConstructor.getProject()).getElementFactory();
            try {
                if (superCall == null) {
                    PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText("super();", null);
                    statement = (PsiExpressionStatement)body.addAfter((PsiElement)statement, null);
                    superCall = (PsiMethodCallExpression)statement.getExpression();
                }
                PsiExpressionList argList = superCall.getArgumentList();
                for (PsiParameter parameter : parametersToPassToSuper) {
                    argList.add((PsiElement)factory.createExpressionFromText(parameter.getName(), null));
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    private PsiStatement hasCommonInitializer(PsiStatement commonInitializer, PsiMethod subConstructor, PsiField field, ArrayList<PsiElement> statementsToRemove) {
        PsiCodeBlock body = subConstructor.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        PsiStatement commonInitializerCandidate = null;
        for (PsiStatement statement : statements) {
            HashSet<PsiStatement> collectedStatements = new HashSet<PsiStatement>();
            PullUpHelper.collectPsiStatements((PsiElement)statement, collectedStatements);
            boolean doLookup = true;
            for (PsiStatement collectedStatement : collectedStatements) {
                PsiElement resolved;
                PsiReferenceExpression lRef;
                PsiAssignmentExpression assignmentExpression;
                PsiExpression lExpression;
                PsiExpression expression;
                if (!(collectedStatement instanceof PsiExpressionStatement) || !((expression = ((PsiExpressionStatement)collectedStatement).getExpression()) instanceof PsiAssignmentExpression) || !((lExpression = (assignmentExpression = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression) || (lRef = (PsiReferenceExpression)lExpression).getQualifierExpression() != null && !(lRef.getQualifierExpression() instanceof PsiThisExpression) || (resolved = lRef.resolve()) != field) continue;
                doLookup = false;
                if (commonInitializerCandidate == null) {
                    PsiExpression initializer = assignmentExpression.getRExpression();
                    if (initializer == null) {
                        return null;
                    }
                    if (commonInitializer == null) {
                        IsMovableInitializerVisitor visitor = new IsMovableInitializerVisitor();
                        statement.accept((PsiElementVisitor)visitor);
                        if (visitor.isMovable()) {
                            ChangeContextUtil.encodeContextInfo((PsiElement)statement, true);
                            PsiStatement statementCopy = (PsiStatement)statement.copy();
                            ChangeContextUtil.clearContextInfo((PsiElement)statement);
                            statementsToRemove.add((PsiElement)statement);
                            commonInitializerCandidate = statementCopy;
                            continue;
                        }
                        return null;
                    }
                    if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)commonInitializer, (PsiElement)statement)) {
                        statementsToRemove.add((PsiElement)statement);
                        commonInitializerCandidate = commonInitializer;
                        continue;
                    }
                    return null;
                }
                if (PsiEquivalenceUtil.areElementsEquivalent(commonInitializerCandidate, (PsiElement)statement)) continue;
                return null;
            }
            if (!doLookup) continue;
            PsiReference[] references = (PsiReference[])ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)statement), (boolean)false).toArray((Object[])new PsiReference[0]);
            if (commonInitializerCandidate == null && references.length > 0) {
                return null;
            }
            for (PsiReference reference : references) {
                if (!RefactoringUtil.isAssignmentLHS(reference.getElement())) continue;
                return null;
            }
        }
        return commonInitializerCandidate;
    }

    private static void collectPsiStatements(PsiElement root, Set<PsiStatement> collected) {
        if (root instanceof PsiStatement) {
            collected.add((PsiStatement)root);
        }
        for (PsiElement element : root.getChildren()) {
            PullUpHelper.collectPsiStatements(element, collected);
        }
    }

    private HashMap<PsiMethod, HashSet<PsiMethod>> buildConstructorsToSubConstructorsMap(PsiMethod[] constructors) {
        HashMap constructorsToSubConstructors = new HashMap();
        for (PsiMethod constructor : constructors) {
            final HashSet<PsiMethod> referencingSubConstructors = new HashSet<PsiMethod>();
            constructorsToSubConstructors.put((Object)constructor, referencingSubConstructors);
            if (constructor != null) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)constructor, (SearchScope)new LocalSearchScope((PsiElement)this.mySourceClass), (boolean)false)) {
                    PsiMethod parentMethod;
                    PsiElement element = reference.getElement();
                    if (element == null || !"super".equals(element.getText()) || (parentMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) == null || !parentMethod.isConstructor()) continue;
                    referencingSubConstructors.add(parentMethod);
                }
            }
            if (constructor != null && constructor.getParameterList().getParametersCount() != 0) continue;
            RefactoringUtil.visitImplicitSuperConstructorUsages(this.mySourceClass, new RefactoringUtil.ImplicitConstructorUsageVisitor(){

                @Override
                public void visitConstructor(PsiMethod constructor, PsiMethod baseConstructor) {
                    referencingSubConstructors.add(constructor);
                }

                @Override
                public void visitClassWithoutConstructors(PsiClass aClass) {
                }
            }, this.myTargetSuperClass);
        }
        return constructorsToSubConstructors;
    }

    private void fixReferencesToStatic(PsiElement classMember, Set<PsiMember> movedMembers) throws IncorrectOperationException {
        StaticReferencesCollector collector = new StaticReferencesCollector(movedMembers);
        classMember.accept((PsiElementVisitor)collector);
        ArrayList<PsiJavaCodeReferenceElement> refs = collector.getReferences();
        ArrayList<PsiElement> members = collector.getReferees();
        ArrayList<PsiClass> classes = collector.getRefereeClasses();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)classMember.getProject()).getElementFactory();
        for (int i = 0; i < refs.size(); ++i) {
            PsiJavaCodeReferenceElement ref = refs.get(i);
            PsiElement namedElement = members.get(i);
            PsiClass aClass = classes.get(i);
            if (!(namedElement instanceof PsiNamedElement)) continue;
            PsiReferenceExpression newRef = (PsiReferenceExpression)factory.createExpressionFromText("a." + ((PsiNamedElement)namedElement).getName(), null);
            PsiExpression qualifierExpression = newRef.getQualifierExpression();
            assert (qualifierExpression != null);
            qualifierExpression.replace((PsiElement)factory.createReferenceExpression(aClass));
            ref.replace((PsiElement)newRef);
        }
    }

    private static boolean willBeUsedInSubclass(PsiElement member, Set<PsiMember> movedMembers, PsiClass superclass, PsiClass subclass) {
        for (PsiReference ref : ReferencesSearch.search((PsiElement)member, (SearchScope)new LocalSearchScope((PsiElement)subclass), (boolean)false)) {
            PsiElement element = ref.getElement();
            if (RefactoringHierarchyUtil.willBeInTargetClass(element, movedMembers, superclass, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkedInterfacesContain(Collection<MemberInfo> memberInfos, PsiMethod psiMethod) {
        for (MemberInfo memberInfo : memberInfos) {
            if (!memberInfo.isChecked() || !(memberInfo.getMember() instanceof PsiClass) || !Boolean.FALSE.equals(memberInfo.getOverrides()) || ((PsiClass)memberInfo.getMember()).findMethodBySignature(psiMethod, true) == null) continue;
            return true;
        }
        return false;
    }

    private class PullUpUsageViewDescriptor
    implements UsageViewDescriptor {
        private PullUpUsageViewDescriptor() {
        }

        public String getProcessedElementsHeader() {
            return "Pull up members from";
        }

        @NotNull
        public PsiElement[] getElements() {
            PsiElement[] psiElementArray = new PsiElement[]{PullUpHelper.this.mySourceClass};
            if (psiElementArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/refactoring/memberPullUp/PullUpHelper$PullUpUsageViewDescriptor.getElements must not return null");
            }
            return psiElementArray;
        }

        public String getCodeReferencesText(int usagesCount, int filesCount) {
            return "Class to pull up members to \"" + RefactoringUIUtil.getDescription((PsiElement)PullUpHelper.this.myTargetSuperClass, true) + "\"";
        }

        public String getCommentReferencesText(int usagesCount, int filesCount) {
            return null;
        }
    }

    private class ExplicitSuperDeleter
    extends JavaRecursiveElementWalkingVisitor {
        private final ArrayList<PsiExpression> mySupersToDelete = new ArrayList();
        private final ArrayList<PsiSuperExpression> mySupersToChangeToThis = new ArrayList();

        private ExplicitSuperDeleter() {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiElement resolved;
            if (expression.getQualifierExpression() instanceof PsiSuperExpression && ((resolved = expression.resolve()) == null || resolved instanceof PsiMethod && this.shouldFixSuper((PsiMethod)resolved))) {
                this.mySupersToDelete.add(expression.getQualifierExpression());
            }
        }

        public void visitSuperExpression(PsiSuperExpression expression) {
            this.mySupersToChangeToThis.add(expression);
        }

        public void visitClass(PsiClass aClass) {
        }

        private boolean shouldFixSuper(PsiMethod method) {
            for (PsiMember element : PullUpHelper.this.myMembersAfterMove) {
                if (!(element instanceof PsiMethod)) continue;
                PsiMethod member = (PsiMethod)element;
                PsiManager manager = method.getManager();
                if (!manager.areElementsEquivalent((PsiElement)member.getContainingClass(), (PsiElement)method.getContainingClass()) || !MethodSignatureUtil.areSignaturesEqual((PsiMethod)member, (PsiMethod)method)) continue;
                return false;
            }
            PsiMethod methodFromSuper = PullUpHelper.this.myTargetSuperClass.findMethodBySignature(method, false);
            return methodFromSuper == null;
        }

        public void fixSupers() throws IncorrectOperationException {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)PullUpHelper.this.myManager.getProject()).getElementFactory();
            PsiThisExpression thisExpression = (PsiThisExpression)factory.createExpressionFromText("this", null);
            for (PsiExpression psiExpression : this.mySupersToDelete) {
                psiExpression.delete();
            }
            for (PsiSuperExpression psiSuperExpression : this.mySupersToChangeToThis) {
                psiSuperExpression.replace((PsiElement)thisExpression);
            }
        }
    }

    private class QualifiedThisSuperAdjuster
    extends JavaRecursiveElementVisitor {
        private QualifiedThisSuperAdjuster() {
        }

        public void visitThisExpression(PsiThisExpression expression) {
            super.visitThisExpression(expression);
            PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
            if (qualifier != null && qualifier.isReferenceTo((PsiElement)PullUpHelper.this.mySourceClass)) {
                try {
                    qualifier.bindToElement((PsiElement)PullUpHelper.this.myTargetSuperClass);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        public void visitSuperExpression(PsiSuperExpression expression) {
            super.visitSuperExpression(expression);
            PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
            if (qualifier != null && qualifier.isReferenceTo((PsiElement)PullUpHelper.this.mySourceClass)) {
                try {
                    expression.replace((PsiElement)JavaPsiFacade.getInstance((Project)PullUpHelper.this.myManager.getProject()).getElementFactory().createExpressionFromText(PullUpHelper.this.myTargetSuperClass.getName() + ".this", null));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    private class StaticReferencesCollector
    extends ClassMemberReferencesVisitor {
        ArrayList<PsiJavaCodeReferenceElement> myReferences;
        ArrayList<PsiElement> myReferees;
        ArrayList<PsiClass> myRefereeClasses;
        private final Set<PsiMember> myMovedMembers;

        private StaticReferencesCollector(Set<PsiMember> movedMembers) {
            super(PullUpHelper.this.mySourceClass);
            this.myMovedMembers = movedMembers;
            this.myReferees = new ArrayList();
            this.myRefereeClasses = new ArrayList();
            this.myReferences = new ArrayList();
        }

        public ArrayList<PsiElement> getReferees() {
            return this.myReferees;
        }

        public ArrayList<PsiClass> getRefereeClasses() {
            return this.myRefereeClasses;
        }

        public ArrayList<PsiJavaCodeReferenceElement> getReferences() {
            return this.myReferences;
        }

        @Override
        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            if (classMember instanceof PsiClass) {
                return;
            }
            if (classMember.hasModifierProperty("static")) {
                if (!this.myMovedMembers.contains(classMember) && RefactoringHierarchyUtil.isMemberBetween(PullUpHelper.this.myTargetSuperClass, PullUpHelper.this.mySourceClass, classMember)) {
                    this.myReferences.add(classMemberReference);
                    this.myReferees.add((PsiElement)classMember);
                    this.myRefereeClasses.add(classMember.getContainingClass());
                } else if ((this.myMovedMembers.contains(classMember) || PullUpHelper.this.myMembersAfterMove.contains(classMember)) && classMemberReference.isQualified()) {
                    this.myReferences.add(classMemberReference);
                    this.myReferees.add((PsiElement)classMember);
                    this.myRefereeClasses.add(PullUpHelper.this.myTargetSuperClass);
                }
            }
        }
    }

    private class IsMovableInitializerVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myIsMovable = true;

        private IsMovableInitializerVisitor() {
        }

        public boolean isMovable() {
            return this.myIsMovable;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement referenceElement) {
            if (!this.myIsMovable) {
                return;
            }
            PsiExpression qualifier = referenceElement instanceof PsiReferenceExpression ? ((PsiReferenceExpression)referenceElement).getQualifierExpression() : null;
            if (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
                PsiElement resolved = referenceElement.resolve();
                if (!(resolved instanceof PsiParameter)) {
                    if (resolved instanceof PsiClass && (((PsiClass)resolved).hasModifierProperty("static") || ((PsiClass)resolved).getContainingClass() == null)) {
                        return;
                    }
                    PsiClass containingClass = null;
                    if (resolved instanceof PsiMember && !((PsiMember)resolved).hasModifierProperty("static")) {
                        containingClass = ((PsiMember)resolved).getContainingClass();
                    }
                    this.myIsMovable = containingClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)PullUpHelper.this.myTargetSuperClass, (PsiClass)containingClass, (boolean)true);
                }
            } else {
                qualifier.accept((PsiElementVisitor)this);
            }
        }

        public void visitElement(PsiElement element) {
            if (this.myIsMovable) {
                super.visitElement(element);
            }
        }
    }

    private static class ParametersAndMovedFieldsUsedCollector
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiField> myMovedFields;
        private final Set<PsiField> myUsedFields;
        private final Set<PsiParameter> myUsedParameters = new LinkedHashSet<PsiParameter>();

        private ParametersAndMovedFieldsUsedCollector(HashSet<PsiField> movedFields) {
            this.myMovedFields = movedFields;
            this.myUsedFields = new HashSet<PsiField>();
        }

        public Set<PsiParameter> getUsedParameters() {
            return this.myUsedParameters;
        }

        public Set<PsiField> getUsedFields() {
            return this.myUsedFields;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiExpression qualifierExpression = expression.getQualifierExpression();
            if (qualifierExpression != null && !(qualifierExpression instanceof PsiThisExpression)) {
                return;
            }
            PsiElement resolved = expression.resolve();
            if (resolved instanceof PsiParameter) {
                this.myUsedParameters.add((PsiParameter)resolved);
            } else if (this.myMovedFields.contains(resolved)) {
                this.myUsedFields.add((PsiField)resolved);
            }
        }
    }

    private static class Initializer {
        public final PsiStatement initializer;
        public final Set<PsiField> movedFieldsUsed;
        public final Set<PsiParameter> usedParameters;
        public final List<PsiElement> statementsToRemove;

        private Initializer(PsiStatement initializer, Set<PsiField> movedFieldsUsed, Set<PsiParameter> usedParameters, List<PsiElement> statementsToRemove) {
            this.initializer = initializer;
            this.movedFieldsUsed = movedFieldsUsed;
            this.statementsToRemove = statementsToRemove;
            this.usedParameters = usedParameters;
        }
    }
}

