/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.DirectoryChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.HelpID;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.rename.DirectoryAsPackageRenameHandler;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl");

    public static void doMove(Project project, PsiElement[] elements, PsiElement initialTargetElement, MoveCallback moveCallback) {
        PsiElement[] psiElements = MoveClassesOrPackagesImpl.adjustForMove(project, elements, initialTargetElement);
        if (psiElements == null) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(psiElements), (boolean)true)) {
            return;
        }
        String initialTargetPackageName = MoveClassesOrPackagesImpl.getInitialTargetPackageName(initialTargetElement, psiElements);
        PsiDirectory initialTargetDirectory = MoveClassesOrPackagesImpl.getInitialTargetDirectory(initialTargetElement, psiElements);
        boolean isTargetDirectoryFixed = initialTargetDirectory == null;
        boolean searchTextOccurences = false;
        for (int i = 0; i < psiElements.length && !searchTextOccurences; ++i) {
            PsiElement psiElement = psiElements[i];
            searchTextOccurences = TextOccurrencesUtil.isSearchTextOccurencesEnabled(psiElement);
        }
        MoveClassesOrPackagesDialog moveDialog = new MoveClassesOrPackagesDialog(project, searchTextOccurences, psiElements, initialTargetElement, moveCallback);
        boolean searchInComments = JavaRefactoringSettings.getInstance().MOVE_SEARCH_IN_COMMENTS;
        boolean searchForTextOccurences = JavaRefactoringSettings.getInstance().MOVE_SEARCH_FOR_TEXT;
        moveDialog.setData(psiElements, initialTargetPackageName, initialTargetDirectory, isTargetDirectoryFixed, searchInComments, searchForTextOccurences, HelpID.getMoveHelpID(psiElements[0]));
        moveDialog.show();
    }

    @Nullable
    public static PsiElement[] adjustForMove(Project project, PsiElement[] elements, PsiElement targetElement) {
        PsiElement[] psiElements = new PsiElement[elements.length];
        ArrayList<String> names = new ArrayList<String>();
        for (int idx = 0; idx < elements.length; ++idx) {
            String message;
            PsiElement element = elements[idx];
            if (element instanceof PsiDirectory) {
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
                LOG.assertTrue(aPackage != null);
                if (aPackage.getQualifiedName().length() == 0) {
                    message = RefactoringBundle.message((String)"move.package.refactoring.cannot.be.applied.to.default.package");
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message, (String)HelpID.getMoveHelpID(element), (Project)project);
                    return null;
                }
                if (!MoveClassesOrPackagesImpl.checkNesting(project, aPackage, targetElement)) {
                    return null;
                }
                if (!MoveClassesOrPackagesImpl.checkMovePackage(project, aPackage)) {
                    return null;
                }
                element = aPackage;
            } else if (element instanceof PsiPackage) {
                PsiPackage psiPackage = (PsiPackage)element;
                if (!MoveClassesOrPackagesImpl.checkNesting(project, psiPackage, targetElement)) {
                    return null;
                }
                if (!MoveClassesOrPackagesImpl.checkMovePackage(project, psiPackage)) {
                    return null;
                }
            } else if (element instanceof PsiClass) {
                MoveClassHandler nameProvider;
                PsiClass aClass = (PsiClass)element;
                if (aClass instanceof PsiAnonymousClass) {
                    message = RefactoringBundle.message((String)"move.class.refactoring.cannot.be.applied.to.anonymous.classes");
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message, (String)HelpID.getMoveHelpID(element), (Project)project);
                    return null;
                }
                if (!(aClass.getParent() instanceof PsiFile)) {
                    message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"moving.local.classes.is.not.supported"));
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message, (String)HelpID.getMoveHelpID(element), (Project)project);
                    return null;
                }
                String name = null;
                MoveClassHandler[] arr$ = (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (name = (nameProvider = arr$[i$]).getName(aClass)) == null; ++i$) {
                }
                if (name == null) {
                    name = aClass.getContainingFile().getName();
                }
                if (names.contains(name)) {
                    String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"there.are.going.to.be.multiple.destination.files.with.the.same.name"));
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message2, (String)HelpID.getMoveHelpID(element), (Project)project);
                    return null;
                }
                names.add(name);
            }
            psiElements[idx] = element;
        }
        return psiElements;
    }

    private static boolean checkMovePackage(Project project, PsiPackage aPackage) {
        PsiDirectory[] directories = aPackage.getDirectories();
        VirtualFile[] virtualFiles = aPackage.occursInPackagePrefixes();
        if (directories.length > 1 || virtualFiles.length > 0) {
            StringBuffer message = new StringBuffer();
            RenameUtil.buildPackagePrefixChangedMessage(virtualFiles, message, aPackage.getQualifiedName());
            if (directories.length > 1) {
                DirectoryAsPackageRenameHandler.buildMultipleDirectoriesInPackageMessage(message, aPackage, directories);
                message.append("\n\n");
                String report = RefactoringBundle.message((String)"all.these.directories.will.be.moved.and.all.references.to.0.will.be.changed", (Object[])new Object[]{aPackage.getQualifiedName()});
                message.append(report);
            }
            message.append("\n");
            message.append(RefactoringBundle.message((String)"do.you.wish.to.continue"));
            int ret = Messages.showYesNoDialog((Project)project, (String)message.toString(), (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getWarningIcon());
            if (ret != 0) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkNesting(Project project, PsiPackage srcPackage, PsiElement targetElement) {
        PsiPackage targetPackage;
        for (PsiPackage curPackage = targetPackage = targetElement instanceof PsiPackage ? (PsiPackage)targetElement : (targetElement instanceof PsiDirectory ? JavaDirectoryService.getInstance().getPackage((PsiDirectory)targetElement) : null); curPackage != null; curPackage = curPackage.getParentPackage()) {
            if (!curPackage.equals(srcPackage)) continue;
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)RefactoringBundle.message((String)"cannot.move.package.into.itself"), (String)HelpID.getMoveHelpID((PsiElement)srcPackage), (Project)project);
            return false;
        }
        return true;
    }

    public static String getInitialTargetPackageName(PsiElement initialTargetElement, PsiElement[] movedElements) {
        String name = MoveClassesOrPackagesImpl.getContainerPackageName(initialTargetElement);
        if (name == null) {
            PsiDirectory commonDirectory;
            if (movedElements != null) {
                name = MoveClassesOrPackagesImpl.getTargetPackageNameForMovedElement(movedElements[0]);
            }
            if (name == null && (commonDirectory = MoveClassesOrPackagesImpl.getCommonDirectory(movedElements)) != null && JavaDirectoryService.getInstance().getPackage(commonDirectory) != null) {
                name = JavaDirectoryService.getInstance().getPackage(commonDirectory).getQualifiedName();
            }
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    @Nullable
    private static PsiDirectory getCommonDirectory(PsiElement[] movedElements) {
        PsiDirectory commonDirectory = null;
        for (PsiElement movedElement : movedElements) {
            PsiDirectory containingDirectory;
            PsiFile containingFile = movedElement.getContainingFile();
            if (containingFile == null || (containingDirectory = containingFile.getContainingDirectory()) == null) continue;
            if (commonDirectory == null) {
                commonDirectory = containingDirectory;
                continue;
            }
            if (commonDirectory == containingDirectory) continue;
            return null;
        }
        if (commonDirectory != null) {
            return commonDirectory;
        }
        return null;
    }

    private static String getContainerPackageName(PsiElement psiElement) {
        if (psiElement instanceof PsiPackage) {
            return ((PsiPackage)psiElement).getQualifiedName();
        }
        if (psiElement instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement);
            return aPackage != null ? aPackage.getQualifiedName() : "";
        }
        if (psiElement != null) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(psiElement.getContainingFile().getContainingDirectory());
            return aPackage != null ? aPackage.getQualifiedName() : "";
        }
        return null;
    }

    private static String getTargetPackageNameForMovedElement(PsiElement psiElement) {
        if (psiElement instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)psiElement;
            PsiPackage parentPackage = psiPackage.getParentPackage();
            return parentPackage != null ? parentPackage.getQualifiedName() : "";
        }
        if (psiElement instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement);
            return aPackage != null ? MoveClassesOrPackagesImpl.getTargetPackageNameForMovedElement((PsiElement)aPackage) : "";
        }
        if (psiElement != null) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(psiElement.getContainingFile().getContainingDirectory());
            return aPackage != null ? aPackage.getQualifiedName() : "";
        }
        return null;
    }

    public static PsiDirectory getInitialTargetDirectory(PsiElement initialTargetElement, PsiElement[] movedElements) {
        PsiDirectory initialTargetDirectory = MoveClassesOrPackagesImpl.getContainerDirectory(initialTargetElement);
        if (initialTargetDirectory == null && movedElements != null) {
            PsiDirectory commonDirectory = MoveClassesOrPackagesImpl.getCommonDirectory(movedElements);
            initialTargetDirectory = commonDirectory != null ? commonDirectory : MoveClassesOrPackagesImpl.getContainerDirectory(movedElements[0]);
        }
        return initialTargetDirectory;
    }

    @Nullable
    public static PsiDirectory getContainerDirectory(PsiElement psiElement) {
        if (psiElement instanceof PsiPackage) {
            PsiDirectory[] directories = ((PsiPackage)psiElement).getDirectories();
            return directories.length == 1 ? directories[0] : null;
        }
        if (psiElement instanceof PsiDirectory) {
            return (PsiDirectory)psiElement;
        }
        if (psiElement != null) {
            return psiElement.getContainingFile().getContainingDirectory();
        }
        return null;
    }

    public static void doRearrangePackage(final Project project, final PsiDirectory[] directories) {
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(directories), (boolean)true)) {
            return;
        }
        List<PsiDirectory> sourceRootDirectories = MoveClassesOrPackagesImpl.buildRearrangeTargetsList(project, directories);
        DirectoryChooser chooser = new DirectoryChooser(project);
        chooser.setTitle(RefactoringBundle.message((String)"select.source.root.chooser.title"));
        chooser.fillList(sourceRootDirectories.toArray(new PsiDirectory[sourceRootDirectories.size()]), null, project, "");
        chooser.show();
        if (!chooser.isOK()) {
            return;
        }
        final PsiDirectory selectedTarget = chooser.getSelectedDirectory();
        if (selectedTarget == null) {
            return;
        }
        final Ref ex = Ref.create(null);
        final String commandDescription = RefactoringBundle.message((String)"moving.directories.command");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LocalHistoryAction a = LocalHistory.startAction((Project)project, (String)commandDescription);
                        try {
                            MoveClassesOrPackagesImpl.rearrangeDirectoriesToTarget(directories, selectedTarget);
                        }
                        catch (IncorrectOperationException e) {
                            ex.set((Object)e);
                        }
                        finally {
                            a.finish();
                        }
                    }
                });
            }
        };
        CommandProcessor.getInstance().executeCommand(project, runnable, commandDescription, null);
        if (ex.get() != null) {
            RefactoringUIUtil.processIncorrectOperation(project, (IncorrectOperationException)((Object)ex.get()));
        }
    }

    private static List<PsiDirectory> buildRearrangeTargetsList(Project project, PsiDirectory[] directories) {
        VirtualFile[] sourceRoots = ProjectRootManager.getInstance((Project)project).getContentSourceRoots();
        ArrayList<PsiDirectory> sourceRootDirectories = new ArrayList<PsiDirectory>();
        block0: for (VirtualFile sourceRoot : sourceRoots) {
            PsiPackage aPackage;
            PsiDirectory sourceRootDirectory = PsiManager.getInstance((Project)project).findDirectory(sourceRoot);
            if (sourceRootDirectory == null || (aPackage = JavaDirectoryService.getInstance().getPackage(sourceRootDirectory)) == null) continue;
            String packagePrefix = aPackage.getQualifiedName();
            for (PsiDirectory directory : directories) {
                String qualifiedName = JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName();
                if (!qualifiedName.startsWith(packagePrefix)) continue block0;
            }
            sourceRootDirectories.add(sourceRootDirectory);
        }
        return sourceRootDirectories;
    }

    private static void rearrangeDirectoriesToTarget(PsiDirectory[] directories, PsiDirectory selectedTarget) throws IncorrectOperationException {
        VirtualFile sourceRoot = selectedTarget.getVirtualFile();
        for (PsiDirectory directory : directories) {
            PsiPackage parentPackage = JavaDirectoryService.getInstance().getPackage(directory).getParentPackage();
            PackageWrapper wrapper = new PackageWrapper(parentPackage);
            PsiDirectory moveTarget = RefactoringUtil.createPackageDirectoryInSourceRoot(wrapper, sourceRoot);
            MoveClassesOrPackagesUtil.moveDirectoryRecursively(directory, moveTarget);
        }
    }
}

