/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.refactoring.openapi.impl.JavaRenameRefactoringImpl;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BeanPropertyRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        return false;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.getProperty(dataContext) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/BeanPropertyRenameHandler.invoke must not be null");
        }
        BeanProperty property = this.getProperty(dataContext);
        new PropertyRenameDialog(property, editor).show();
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/BeanPropertyRenameHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/rename/BeanPropertyRenameHandler.invoke must not be null");
        }
    }

    public static void doRename(@NotNull BeanProperty property, String newName, boolean searchInComments) {
        PsiMethod getter;
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/BeanPropertyRenameHandler.doRename must not be null");
        }
        PsiNamedElement psiElement = property.getPsiElement();
        JavaRenameRefactoringImpl rename = new JavaRenameRefactoringImpl(psiElement.getProject(), (PsiElement)psiElement, newName, searchInComments, false);
        PsiMethod setter = property.getSetter();
        if (setter != null) {
            String setterName = PropertyUtil.suggestSetterName((String)newName);
            rename.addElement((PsiElement)setter, setterName);
        }
        if ((getter = property.getGetter()) != null) {
            String getterName = PropertyUtil.suggestGetterName((String)newName, (PsiType)getter.getReturnType());
            rename.addElement((PsiElement)getter, getterName);
        }
        rename.run();
    }

    @Nullable
    protected abstract BeanProperty getProperty(DataContext var1);

    private static class PropertyRenameDialog
    extends RenameDialog {
        private final BeanProperty myProperty;

        protected PropertyRenameDialog(BeanProperty property, Editor editor) {
            super(property.getMethod().getProject(), (PsiElement)property.getPsiElement(), null, editor);
            this.myProperty = property;
        }

        @Override
        protected void doAction() {
            String newName = this.getNewName();
            boolean searchInComments = this.isSearchInComments();
            BeanPropertyRenameHandler.doRename(this.myProperty, newName, searchInComments);
            this.close(0);
        }
    }
}

