/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.ClassHidesImportedClassUsageInfo;
import com.intellij.refactoring.rename.ClassHidesUnqualifiableClassUsageInfo;
import com.intellij.refactoring.rename.CollidingClassImportUsageInfo;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.ResolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.SubmemberHidesMemberUsageInfo;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameJavaClassProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameJavaClassProcessor");
    @NonNls
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s");

    @Override
    public boolean canProcessElement(PsiElement element) {
        return element instanceof PsiClass;
    }

    @Override
    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, RefactoringElementListener listener) throws IncorrectOperationException {
        PsiClass aClass = (PsiClass)element;
        ArrayList<UsageInfo> postponedCollisions = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof ResolvableCollisionUsageInfo)) continue;
            if (usage instanceof CollidingClassImportUsageInfo) {
                ((CollidingClassImportUsageInfo)usage).getImportStatement().delete();
                continue;
            }
            postponedCollisions.add(usage);
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)aClass, true);
        aClass.setName(newName);
        for (UsageInfo usage : usages) {
            PsiReference ref;
            if (usage instanceof ResolvableCollisionUsageInfo || (ref = usage.getReference()) == null) continue;
            try {
                ref.bindToElement((PsiElement)aClass);
            }
            catch (IncorrectOperationException e) {
                ref.handleElementRename(newName);
            }
        }
        ChangeContextUtil.decodeContextInfo((PsiElement)aClass, null, null);
        for (UsageInfo postponedCollision : postponedCollisions) {
            ClassHidesImportedClassUsageInfo collision = (ClassHidesImportedClassUsageInfo)postponedCollision;
            collision.resolveCollision();
        }
        listener.elementRenamed((PsiElement)aClass);
    }

    @Override
    @Nullable
    public Pair<String, String> getTextOccurrenceSearchStrings(@NotNull PsiElement element, @NotNull String newName) {
        PsiClass aClass;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/RenameJavaClassProcessor.getTextOccurrenceSearchStrings must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/rename/RenameJavaClassProcessor.getTextOccurrenceSearchStrings must not be null");
        }
        if (element instanceof PsiClass && (aClass = (PsiClass)element).getParent() instanceof PsiClass) {
            String dollaredStringToReplace;
            String dollaredStringToSearch = ClassUtil.getJVMClassName((PsiClass)aClass);
            String string = dollaredStringToReplace = dollaredStringToSearch == null ? null : RefactoringUtil.getNewInnerClassName(aClass, dollaredStringToSearch, newName);
            if (dollaredStringToReplace != null) {
                return new Pair((Object)dollaredStringToSearch, (Object)dollaredStringToReplace);
            }
        }
        return null;
    }

    @Override
    public String getQualifiedNameAfterRename(PsiElement element, String newName, boolean nonJava) {
        if (nonJava) {
            PsiClass aClass = (PsiClass)element;
            return RenameUtil.getQualifiedNameAfterRename(aClass.getQualifiedName(), newName);
        }
        return newName;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = ((PsiClass)element).getConstructors()) {
            allRenames.put((PsiElement)constructor, newName);
        }
    }

    @Override
    public void findCollisions(PsiElement element, String newName, Map<? extends PsiElement, String> allRenames, List<UsageInfo> result) {
        PsiClass aClass = (PsiClass)element;
        ClassCollisionsDetector classCollisionsDetector = new ClassCollisionsDetector(aClass);
        ArrayList<UsageInfo> initialResults = new ArrayList<UsageInfo>(result);
        for (UsageInfo usageInfo : initialResults) {
            if (!(usageInfo instanceof MoveRenameUsageInfo)) continue;
            classCollisionsDetector.addClassCollisions(usageInfo.getElement(), newName, result);
        }
        RenameJavaClassProcessor.findSubmemberHidesMemberCollisions(aClass, newName, result);
    }

    public static void findSubmemberHidesMemberCollisions(PsiClass aClass, String newName, List<UsageInfo> result) {
        if (aClass.getParent() instanceof PsiClass) {
            PsiClass parent = (PsiClass)aClass.getParent();
            Collection inheritors = ClassInheritorsSearch.search((PsiClass)parent, (SearchScope)parent.getUseScope(), (boolean)true).findAll();
            for (PsiClass inheritor : inheritors) {
                PsiClass[] inners;
                for (PsiClass inner : inners = inheritor.getInnerClasses()) {
                    if (!newName.equals(inner.getName())) continue;
                    result.add((UsageInfo)new SubmemberHidesMemberUsageInfo((PsiElement)inner, (PsiElement)aClass));
                }
            }
        }
    }

    private static String removeSpaces(String s) {
        return WHITE_SPACE_PATTERN.matcher(s).replaceAll("");
    }

    @Override
    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts) {
        if (element instanceof PsiCompiledElement) {
            return;
        }
        PsiClass aClass = (PsiClass)element;
        if (newName.equals(aClass.getName())) {
            return;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass != null) {
            PsiClass[] innerClasses;
            for (PsiClass innerClass : innerClasses = containingClass.getInnerClasses()) {
                if (!newName.equals(innerClass.getName())) continue;
                conflicts.putValue((Object)innerClass, (Object)RefactoringBundle.message((String)"inner.class.0.is.already.defined.in.class.1", (Object[])new Object[]{newName, containingClass.getQualifiedName()}));
                break;
            }
        } else {
            String qualifiedNameAfterRename = RenameUtil.getQualifiedNameAfterRename(aClass.getQualifiedName(), newName);
            Project project = element.getProject();
            PsiClass conflictingClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedNameAfterRename, GlobalSearchScope.allScope((Project)project));
            if (conflictingClass != null) {
                conflicts.putValue((Object)conflictingClass, (Object)RefactoringBundle.message((String)"class.0.already.exists", (Object[])new Object[]{qualifiedNameAfterRename}));
            }
        }
    }

    @Override
    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renameClass";
    }

    @Override
    public boolean isToSearchInComments(PsiElement psiElement) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS = enabled;
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS = enabled;
    }

    private static class ClassCollisionsDetector {
        final HashSet<PsiFile> myProcessedFiles = new HashSet();
        final PsiClass myRenamedClass;
        private final String myRenamedClassQualifiedName;

        public ClassCollisionsDetector(PsiClass renamedClass) {
            this.myRenamedClass = renamedClass;
            this.myRenamedClassQualifiedName = this.myRenamedClass.getQualifiedName();
        }

        public void addClassCollisions(PsiElement referenceElement, String newName, List<UsageInfo> results) {
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)referenceElement.getProject()).getResolveHelper();
            PsiClass aClass = resolveHelper.resolveReferencedClass(newName, referenceElement);
            if (aClass == null) {
                return;
            }
            PsiFile containingFile = referenceElement.getContainingFile();
            String text = referenceElement.getText();
            if (Comparing.equal((String)this.myRenamedClassQualifiedName, (String)RenameJavaClassProcessor.removeSpaces(text))) {
                return;
            }
            if (this.myProcessedFiles.contains(containingFile)) {
                return;
            }
            for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)new LocalSearchScope((PsiElement)containingFile))) {
                PsiElement collisionReferenceElement = reference.getElement();
                if (!(collisionReferenceElement instanceof PsiJavaCodeReferenceElement)) continue;
                PsiElement parent = collisionReferenceElement.getParent();
                if (parent instanceof PsiImportStatement) {
                    results.add((UsageInfo)new CollidingClassImportUsageInfo((PsiImportStatement)parent, (PsiElement)this.myRenamedClass));
                    continue;
                }
                if (aClass.getQualifiedName() != null) {
                    results.add((UsageInfo)new ClassHidesImportedClassUsageInfo((PsiJavaCodeReferenceElement)collisionReferenceElement, this.myRenamedClass, aClass));
                    continue;
                }
                results.add((UsageInfo)new ClassHidesUnqualifiableClassUsageInfo((PsiJavaCodeReferenceElement)collisionReferenceElement, this.myRenamedClass, aClass));
            }
            this.myProcessedFiles.add(containingFile);
        }
    }
}

