/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.MemberHidesOuterMemberUsageInfo;
import com.intellij.refactoring.rename.MemberHidesStaticImportUsageInfo;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameJavaMemberProcessor;
import com.intellij.refactoring.rename.SubmemberHidesMemberUsageInfo;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameJavaMethodProcessor
extends RenameJavaMemberProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameJavaMethodProcessor");

    @Override
    public boolean canProcessElement(PsiElement element) {
        return element instanceof PsiMethod;
    }

    @Override
    public void renameElement(PsiElement psiElement, String newName, UsageInfo[] usages, RefactoringElementListener listener) throws IncorrectOperationException {
        PsiElement element;
        PsiMethod method = (PsiMethod)psiElement;
        HashSet methodAndOverriders = new HashSet();
        HashSet containingClasses = new HashSet();
        ArrayList<PsiElement> renamedReferences = new ArrayList<PsiElement>();
        ArrayList<MemberHidesOuterMemberUsageInfo> outerHides = new ArrayList<MemberHidesOuterMemberUsageInfo>();
        ArrayList<MemberHidesStaticImportUsageInfo> staticImportHides = new ArrayList<MemberHidesStaticImportUsageInfo>();
        methodAndOverriders.add(method);
        containingClasses.add(method.getContainingClass());
        RenameJavaMethodProcessor.findCollisionsAgainstNewName((PsiMember)method, newName, staticImportHides);
        for (UsageInfo usage : usages) {
            element = usage.getElement();
            if (element == null) continue;
            if (usage instanceof MemberHidesStaticImportUsageInfo) {
                staticImportHides.add((MemberHidesStaticImportUsageInfo)usage);
                continue;
            }
            if (usage instanceof MemberHidesOuterMemberUsageInfo) {
                PsiJavaCodeReferenceElement collidingRef = (PsiJavaCodeReferenceElement)element;
                PsiMethod resolved = (PsiMethod)collidingRef.resolve();
                outerHides.add(new MemberHidesOuterMemberUsageInfo(element, (PsiMember)resolved));
                continue;
            }
            if (!(element instanceof PsiMethod)) {
                PsiReference ref = usage instanceof MoveRenameUsageInfo ? usage.getReference() : element.getReference();
                if (ref == null) continue;
                renamedReferences.add(ref.handleElementRename(newName));
                continue;
            }
            PsiMethod overrider = (PsiMethod)element;
            methodAndOverriders.add(overrider);
            containingClasses.add(overrider.getContainingClass());
        }
        method.setName(newName);
        for (UsageInfo usage : usages) {
            element = usage.getElement();
            if (!(element instanceof PsiMethod)) continue;
            ((PsiMethod)element).setName(newName);
        }
        listener.elementRenamed((PsiElement)method);
        for (PsiElement element2 : renamedReferences) {
            RenameJavaMethodProcessor.fixNameCollisionsWithInnerClassMethod(element2, newName, (Set<PsiMethod>)methodAndOverriders, (Set<PsiClass>)containingClasses, method.hasModifierProperty("static"));
        }
        RenameJavaMethodProcessor.qualifyOuterMemberReferences(outerHides);
        RenameJavaMethodProcessor.qualifyStaticImportReferences(staticImportHides);
    }

    private static void fixNameCollisionsWithInnerClassMethod(PsiElement element, String newName, Set<PsiMethod> methodAndOverriders, Set<PsiClass> containingClasses, boolean isStatic) throws IncorrectOperationException {
        PsiMethod actualMethod;
        if (!(element instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement elem = ((PsiReferenceExpression)element).resolve();
        if (elem instanceof PsiMethod && !methodAndOverriders.contains(actualMethod = (PsiMethod)elem)) {
            for (PsiClass outerClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class); outerClass != null; outerClass = outerClass.getContainingClass()) {
                if (!containingClasses.contains(outerClass)) continue;
                RenameJavaMethodProcessor.qualifyMember(element, newName, outerClass, isStatic);
                break;
            }
        }
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)element.getProject());
        Collection collection = MethodReferencesSearch.search((PsiMethod)((PsiMethod)element), (SearchScope)projectScope, (boolean)true).findAll();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/rename/RenameJavaMethodProcessor.findReferences must not return null");
        }
        return collection;
    }

    @Override
    public void findCollisions(PsiElement element, String newName, Map<? extends PsiElement, String> allRenames, List<UsageInfo> result) {
        PsiMethod methodToRename = (PsiMethod)element;
        RenameJavaMethodProcessor.findSubmemberHidesMemberCollisions(methodToRename, newName, result);
        RenameJavaMethodProcessor.findMemberHidesOuterMemberCollisions((PsiMember)((PsiMethod)element), newName, result);
        RenameJavaMethodProcessor.findCollisionsAgainstNewName((PsiMember)methodToRename, newName, result);
    }

    @Override
    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts) {
        if (element instanceof PsiCompiledElement) {
            return;
        }
        PsiMethod refactoredMethod = (PsiMethod)element;
        if (newName.equals(refactoredMethod.getName())) {
            return;
        }
        PsiMethod prototype = (PsiMethod)refactoredMethod.copy();
        try {
            prototype.setName(newName);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        ConflictsUtil.checkMethodConflicts(refactoredMethod.getContainingClass(), refactoredMethod, prototype, conflicts);
    }

    @Override
    public void prepareRenaming(PsiElement element, final String newName, final Map<PsiElement, String> allRenames) {
        final PsiMethod method = (PsiMethod)element;
        OverridingMethodsSearch.search((PsiMethod)method, (boolean)true).forEach((Processor)new Processor<PsiMethod>(){

            public boolean process(PsiMethod overrider) {
                String baseName;
                String overriderName = overrider.getName();
                String newOverriderName = RefactoringUtil.suggestNewOverriderName(overriderName, baseName = method.getName(), newName);
                if (newOverriderName != null) {
                    allRenames.put(overrider, newOverriderName);
                }
                return true;
            }
        });
    }

    @Override
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renameMethod";
    }

    @Override
    public boolean isToSearchInComments(PsiElement psiElement) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD = enabled;
    }

    @Override
    @Nullable
    public PsiElement substituteElementToRename(PsiElement element, Editor editor) {
        PsiMethod psiMethod = (PsiMethod)element;
        if (psiMethod.isConstructor()) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            element = containingClass;
            if (!PsiElementRenameHandler.canRename(element.getProject(), editor, element)) {
                return null;
            }
            return element;
        }
        return SuperMethodWarningUtil.checkSuperMethod(psiMethod, RefactoringBundle.message((String)"to.rename"));
    }

    private static void findSubmemberHidesMemberCollisions(PsiMethod method, String newName, List<UsageInfo> result) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (method.hasModifierProperty("private")) {
            return;
        }
        Collection inheritors = ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)containingClass.getUseScope(), (boolean)true).findAll();
        MethodSignature oldSignature = method.getSignature(PsiSubstitutor.EMPTY);
        MethodSignature newSignature = MethodSignatureUtil.createMethodSignature((String)newName, (PsiType[])oldSignature.getParameterTypes(), (PsiTypeParameter[])oldSignature.getTypeParameters(), (PsiSubstitutor)oldSignature.getSubstitutor());
        block0: for (PsiClass inheritor : inheritors) {
            PsiMethod[] methodsByName;
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            for (PsiMethod conflictingMethod : methodsByName = inheritor.findMethodsByName(newName, false)) {
                if (!newSignature.equals(conflictingMethod.getSignature(superSubstitutor))) continue;
                result.add((UsageInfo)new SubmemberHidesMemberUsageInfo((PsiElement)conflictingMethod, (PsiElement)method));
                continue block0;
            }
        }
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD = enabled;
    }
}

