/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenamePsiPackageProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePsiDirectoryProcessor
extends RenamePsiElementProcessor {
    @Override
    public boolean canProcessElement(PsiElement element) {
        return element instanceof PsiDirectory;
    }

    @Override
    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, RefactoringElementListener listener) throws IncorrectOperationException {
        PsiDirectory aDirectory = (PsiDirectory)element;
        for (UsageInfo usage : usages) {
            if (PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiPackageStatement.class) != null) continue;
            RenameUtil.rename(usage, newName);
        }
        for (UsageInfo usage : usages) {
            if (PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiPackageStatement.class) == null) continue;
            RenameUtil.rename(usage, newName);
        }
        aDirectory.setName(newName);
        listener.elementRenamed((PsiElement)aDirectory);
    }

    @Override
    public String getQualifiedNameAfterRename(PsiElement element, String newName, boolean nonJava) {
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (psiPackage != null) {
            return RenamePsiPackageProcessor.getPackageQualifiedNameAfterRename(psiPackage, newName, nonJava);
        }
        return newName;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        Collection collection;
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (aPackage != null) {
            collection = ReferencesSearch.search((PsiElement)aPackage, (SearchScope)element.getUseScope()).findAll();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/rename/RenamePsiDirectoryProcessor.findReferences must not return null");
            return collection;
        }
        collection = ReferencesSearch.search((PsiElement)element).findAll();
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/refactoring/rename/RenamePsiDirectoryProcessor.findReferences must not return null");
    }

    @Override
    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(PsiElement element) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (aPackage != null) {
            return aPackage;
        }
        return null;
    }

    @Override
    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renameDirectory";
    }

    @Override
    public boolean isToSearchInComments(PsiElement element) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element == null) {
            return false;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element != null) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = enabled;
        }
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element == null) {
            return false;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element != null) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = enabled;
        }
    }
}

