/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public class NameSuggester {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.naming.NameSuggester");
    private final String[] myOldClassName;
    private final String[] myNewClassName;
    private final List<OriginalToNewChange> myChanges;
    private final String myOldClassNameAsGiven;
    private final String myNewClassNameAsGiven;

    public NameSuggester(String oldClassName, String newClassName) {
        this.myOldClassNameAsGiven = oldClassName;
        this.myNewClassNameAsGiven = newClassName;
        this.myOldClassName = NameUtil.splitNameIntoWords((String)oldClassName);
        this.myNewClassName = NameUtil.splitNameIntoWords((String)newClassName);
        this.myChanges = new ArrayList<OriginalToNewChange>();
        int oldIndex = this.myOldClassName.length - 1;
        int oldLastMatch = this.myOldClassName.length;
        int newLastMatch = this.myNewClassName.length;
        while (oldIndex >= 0) {
            String patternWord = this.myOldClassName[oldIndex];
            int matchingWordIndex = this.findInNewBackwardsFromIndex(patternWord, newLastMatch - 1);
            if (matchingWordIndex < 0) {
                --oldIndex;
                continue;
            }
            if (oldIndex + 1 <= oldLastMatch - 1 || matchingWordIndex + 1 <= newLastMatch - 1) {
                OriginalToNewChange change = new OriginalToNewChange(oldIndex + 1, oldLastMatch - 1, matchingWordIndex + 1, newLastMatch - 1);
                this.myChanges.add(change);
            }
            oldLastMatch = oldIndex--;
            newLastMatch = matchingWordIndex;
        }
        if (0 <= oldLastMatch - 1 || 0 <= newLastMatch - 1) {
            this.myChanges.add(new OriginalToNewChange(0, oldLastMatch - 1, 0, newLastMatch - 1));
        }
    }

    private int findInNewBackwardsFromIndex(String patternWord, int newIndex) {
        for (int i = newIndex; i >= 0; --i) {
            String s = this.myNewClassName[i];
            if (!s.equals(patternWord)) continue;
            return i;
        }
        return -1;
    }

    List<Pair<String, String>> getChanges() {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        for (int i = this.myChanges.size() - 1; i >= 0; --i) {
            OriginalToNewChange change = this.myChanges.get(i);
            result.add((Pair<String, String>)Pair.create((Object)change.getOldString(), (Object)change.getNewString()));
        }
        return result;
    }

    public String suggestName(String propertyName) {
        String[] propertyWords = NameUtil.splitNameIntoWords((String)propertyName);
        TIntIntHashMap matches = this.calculateMatches(propertyWords);
        if (matches.isEmpty()) {
            return propertyName;
        }
        TreeMap<Pair<Integer, Integer>, String> replacements = this.calculateReplacements(propertyWords, matches);
        if (replacements.isEmpty()) {
            return propertyName;
        }
        return NameSuggester.calculateNewName(replacements, propertyWords, propertyName);
    }

    private static Pair<int[], int[]> calculateWordPositions(String s, String[] words) {
        int[] starts = new int[words.length + 1];
        int[] prevEnds = new int[words.length + 1];
        prevEnds[0] = -1;
        int pos = 0;
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            int index = s.indexOf(word, pos);
            LOG.assertTrue(index >= 0);
            starts[i] = index;
            pos = index + word.length();
            prevEnds[i + 1] = pos - 1;
        }
        starts[words.length] = s.length();
        return Pair.create((Object)starts, (Object)prevEnds);
    }

    private static String calculateNewName(TreeMap<Pair<Integer, Integer>, String> replacements, String[] propertyWords, String propertyName) {
        StringBuffer resultingWords = new StringBuffer();
        int currentWord = 0;
        Pair<int[], int[]> wordIndicies = NameSuggester.calculateWordPositions(propertyName, propertyWords);
        for (Map.Entry<Pair<Integer, Integer>, String> entry : replacements.entrySet()) {
            int first = (Integer)entry.getKey().getFirst();
            int last = (Integer)entry.getKey().getSecond();
            for (int i = currentWord; i < first; ++i) {
                resultingWords.append(NameSuggester.calculateBetween(wordIndicies, i, propertyName));
                String propertyWord = propertyWords[i];
                NameSuggester.appendWord(resultingWords, propertyWord);
            }
            resultingWords.append(NameSuggester.calculateBetween(wordIndicies, first, propertyName));
            NameSuggester.appendWord(resultingWords, entry.getValue());
            currentWord = last + 1;
        }
        while (currentWord < propertyWords.length) {
            resultingWords.append(NameSuggester.calculateBetween(wordIndicies, currentWord, propertyName));
            NameSuggester.appendWord(resultingWords, propertyWords[currentWord]);
            ++currentWord;
        }
        resultingWords.append(NameSuggester.calculateBetween(wordIndicies, propertyWords.length, propertyName));
        if (resultingWords.length() == 0) {
            return propertyName;
        }
        return NameSuggester.decapitalizeProbably(resultingWords.toString(), propertyName);
    }

    private static void appendWord(StringBuffer resultingWords, String propertyWord) {
        char lastChar;
        if (resultingWords.length() > 0 && Character.isLetterOrDigit(lastChar = resultingWords.charAt(resultingWords.length() - 1))) {
            propertyWord = StringUtil.capitalize((String)propertyWord);
        }
        resultingWords.append(propertyWord);
    }

    private static String calculateBetween(Pair<int[], int[]> wordIndicies, int i, String propertyName) {
        int thisWordStart = ((int[])wordIndicies.getFirst())[i];
        int prevWordEnd = ((int[])wordIndicies.getSecond())[i];
        return propertyName.substring(prevWordEnd + 1, thisWordStart);
    }

    private TreeMap<Pair<Integer, Integer>, String> calculateReplacements(String[] propertyWords, TIntIntHashMap matches) {
        TreeMap<Pair<Integer, Integer>, String> replacements = new TreeMap<Pair<Integer, Integer>, String>(new Comparator<Pair<Integer, Integer>>(){

            @Override
            public int compare(Pair<Integer, Integer> pair, Pair<Integer, Integer> pair1) {
                return ((Integer)pair.getFirst()).compareTo((Integer)pair1.getFirst());
            }
        });
        for (OriginalToNewChange change : this.myChanges) {
            String newString;
            int first = change.oldFirst;
            int last = change.oldLast;
            if (change.getOldLength() > 0) {
                if (!NameSuggester.containsAllBetween(matches, first, last)) continue;
                newString = change.getNewString();
                int propertyWordFirst = matches.get(first);
                if (first >= this.myOldClassName.length || last >= this.myOldClassName.length) {
                    LOG.error("old class name = " + this.myOldClassNameAsGiven + ", new class name = " + this.myNewClassNameAsGiven + ", propertyWords = " + Arrays.asList(propertyWords).toString());
                }
                String replacement = NameSuggester.suggestReplacement(propertyWords[propertyWordFirst], newString);
                replacements.put((Pair<Integer, Integer>)Pair.create((Object)propertyWordFirst, (Object)matches.get(last)), replacement);
                continue;
            }
            newString = change.getNewString();
            int propertyWordToInsertBefore = matches.containsKey(first) ? matches.get(first) : (matches.contains(last) ? matches.get(last) + 1 : propertyWords.length);
            replacements.put((Pair<Integer, Integer>)Pair.create((Object)propertyWordToInsertBefore, (Object)(propertyWordToInsertBefore - 1)), newString);
        }
        return replacements;
    }

    private static String suggestReplacement(String propertyWord, String newClassNameWords) {
        return NameSuggester.decapitalizeProbably(newClassNameWords, propertyWord);
    }

    private static String decapitalizeProbably(String word, String originalWord) {
        if (originalWord.length() == 0) {
            return word;
        }
        if (Character.isLowerCase(originalWord.charAt(0))) {
            return StringUtil.decapitalize((String)word);
        }
        return word;
    }

    private static boolean containsAllBetween(TIntIntHashMap matches, int first, int last) {
        for (int i = first; i <= last; ++i) {
            if (matches.containsKey(i)) continue;
            return false;
        }
        return true;
    }

    private TIntIntHashMap calculateMatches(String[] propertyWords) {
        int classNameIndex = this.myOldClassName.length - 1;
        TIntIntHashMap matches = new TIntIntHashMap();
        for (int i = propertyWords.length - 1; i >= 0; --i) {
            String propertyWord = propertyWords[i];
            Match match = null;
            for (int j = classNameIndex; j >= 0 && match == null; --j) {
                match = this.checkMatch(j, i, propertyWord);
            }
            if (match == null) continue;
            matches.put(match.oldClassNameIndex, i);
            classNameIndex = match.oldClassNameIndex - 1;
        }
        return matches;
    }

    @Nullable
    private Match checkMatch(int oldClassNameIndex, int propertyNameIndex, String propertyWord) {
        if (propertyWord.equalsIgnoreCase(this.myOldClassName[oldClassNameIndex])) {
            return new Match(oldClassNameIndex, propertyNameIndex, propertyWord);
        }
        return null;
    }

    private static class Match {
        final int oldClassNameIndex;
        final int propertyNameIndex;
        final String propertyWord;

        public Match(int oldClassNameIndex, int propertyNameIndex, String propertyWord) {
            this.oldClassNameIndex = oldClassNameIndex;
            this.propertyNameIndex = propertyNameIndex;
            this.propertyWord = propertyWord;
        }
    }

    private class OriginalToNewChange {
        final int oldFirst;
        final int oldLast;
        final int newFirst;
        final int newLast;

        public OriginalToNewChange(int firstInOld, int lastInOld, int firstInNew, int lastInNew) {
            this.oldFirst = firstInOld;
            this.oldLast = lastInOld;
            this.newFirst = firstInNew;
            this.newLast = lastInNew;
        }

        int getOldLength() {
            return this.oldLast - this.oldFirst + 1;
        }

        String getOldString() {
            StringBuilder buffer = new StringBuilder();
            for (int i = this.oldFirst; i <= this.oldLast; ++i) {
                buffer.append(NameSuggester.this.myOldClassName[i]);
            }
            return buffer.toString();
        }

        String getNewString() {
            StringBuilder buffer = new StringBuilder();
            for (int i = this.newFirst; i <= this.newLast; ++i) {
                buffer.append(NameSuggester.this.myNewClassName[i]);
            }
            return buffer.toString();
        }
    }
}

