/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteUtil;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SafeDeleteDialog
extends DialogWrapper {
    private final PsiElement[] myElements;
    private final Callback myCallback;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurrences;

    public SafeDeleteDialog(Project project, PsiElement[] elements, Callback callback) {
        super(project, true);
        this.myElements = elements;
        this.myCallback = callback;
        this.setTitle(SafeDeleteHandler.REFACTORING_NAME);
        this.init();
    }

    public boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    public boolean isSearchForTextOccurences() {
        if (this.myCbSearchTextOccurrences != null) {
            return this.myCbSearchTextOccurrences.isSelected();
        }
        return false;
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.safeDelete");
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        String warningMessage = DeleteUtil.generateWarningMessage(IdeBundle.message((String)"search.for.usages.and.delete.elements", (Object[])new Object[0]), this.myElements);
        gbc.insets = new Insets(4, 8, 4, 8);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 17;
        panel.add((Component)new JLabel(warningMessage), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        this.myCbSearchInComments = new JCheckBox();
        this.myCbSearchInComments.setText(RefactoringBundle.getSearchInCommentsAndStringsText());
        panel.add((Component)this.myCbSearchInComments, gbc);
        if (this.needSearchForTextOccurrences()) {
            ++gbc.gridx;
            this.myCbSearchTextOccurrences = new JCheckBox();
            this.myCbSearchTextOccurrences.setText(RefactoringBundle.getSearchForTextOccurrencesText());
            panel.add((Component)this.myCbSearchTextOccurrences, gbc);
        }
        RefactoringSettings refactoringSettings = RefactoringSettings.getInstance();
        this.myCbSearchInComments.setSelected(refactoringSettings.SAFE_DELETE_SEARCH_IN_COMMENTS);
        if (this.myCbSearchTextOccurrences != null) {
            this.myCbSearchTextOccurrences.setSelected(refactoringSettings.SAFE_DELETE_SEARCH_IN_NON_JAVA);
        }
        return panel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    private boolean needSearchForTextOccurrences() {
        for (PsiElement element : this.myElements) {
            if (!TextOccurrencesUtil.isSearchTextOccurencesEnabled(element)) continue;
            return true;
        }
        return false;
    }

    protected void doOKAction() {
        if (this.myCallback != null) {
            this.myCallback.run(this);
        } else {
            super.doOKAction();
        }
        RefactoringSettings refactoringSettings = RefactoringSettings.getInstance();
        refactoringSettings.SAFE_DELETE_SEARCH_IN_COMMENTS = this.isSearchInComments();
        if (this.myCbSearchTextOccurrences != null) {
            refactoringSettings.SAFE_DELETE_SEARCH_IN_NON_JAVA = this.isSearchForTextOccurences();
        }
    }

    public static interface Callback {
        public void run(SafeDeleteDialog var1);
    }
}

