/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.usageView.UsageInfo;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;

public class DuplicateMap {
    private static final TObjectHashingStrategy<SliceUsage> USAGEINFO_EQUALITY = new TObjectHashingStrategy<SliceUsage>(){

        public int computeHashCode(SliceUsage object) {
            UsageInfo info = object.getUsageInfo();
            return info.startOffset + info.endOffset * 31;
        }

        public boolean equals(SliceUsage o1, SliceUsage o2) {
            return o1.getUsageInfo().equals((Object)o2.getUsageInfo());
        }
    };
    private final Map<SliceUsage, SliceNode> myDuplicates = new THashMap(USAGEINFO_EQUALITY);

    public SliceNode putNodeCheckDupe(SliceNode node) {
        SliceUsage usage = (SliceUsage)((Object)node.getValue());
        SliceNode eq = this.myDuplicates.get((Object)usage);
        if (eq == null) {
            this.myDuplicates.put(usage, node);
        }
        return eq;
    }

    public void clear() {
        this.myDuplicates.clear();
    }
}

