/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.IdentitySmartPointer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.LightIdeaTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import junit.framework.Assert;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightTestFixtureImpl
extends BaseFixture
implements CodeInsightTestFixture {
    @NonNls
    private static final String PROFILE = "Configurable";
    private PsiManagerImpl myPsiManager;
    private PsiFile myFile;
    private Editor myEditor;
    private String myTestDataPath;
    private boolean myEmptyLookup;
    private InspectionProfileEntry[] myInspections;
    private final Map<String, InspectionProfileEntry> myAvailableTools = new THashMap();
    private final Map<String, InspectionTool> myAvailableLocalTools = new THashMap();
    private final TempDirTestFixture myTempDirFixture;
    protected final IdeaProjectTestFixture myProjectFixture;
    @NonNls
    private static final String XXX = "XXX";
    private PsiElement myFileContext;
    private final FileTreeAccessFilter myJavaFilesFilter = new FileTreeAccessFilter();

    public CodeInsightTestFixtureImpl(IdeaProjectTestFixture projectFixture, TempDirTestFixture tempDirTestFixture) {
        this.myProjectFixture = projectFixture;
        this.myTempDirFixture = tempDirTestFixture;
    }

    @Override
    public void setTestDataPath(String dataPath) {
        this.myTestDataPath = dataPath;
    }

    @Override
    public String getTempDirPath() {
        return this.myTempDirFixture.getTempDirPath();
    }

    @Override
    public TempDirTestFixture getTempDirFixture() {
        return this.myTempDirFixture;
    }

    @Override
    public VirtualFile copyFileToProject(@NonNls String sourceFilePath, @NonNls String targetPath) throws IOException {
        File fromFile = new File(this.getTestDataPath() + "/" + sourceFilePath);
        if (!fromFile.exists()) {
            fromFile = new File(sourceFilePath);
        }
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            VirtualFile fromVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(fromFile);
            if (fromVFile == null) {
                fromVFile = this.myTempDirFixture.getFile(sourceFilePath);
            }
            assert (fromVFile != null) : "can't find testdata file " + sourceFilePath;
            return this.myTempDirFixture.copyFile(fromVFile, targetPath);
        }
        File destFile = new File(this.getTempDirPath() + "/" + targetPath);
        if (!destFile.exists()) {
            if (fromFile.isDirectory()) {
                destFile.mkdirs();
            } else {
                FileUtil.copy((File)fromFile, (File)destFile);
            }
        }
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(destFile);
        Assert.assertNotNull((Object)file);
        return file;
    }

    @Override
    public VirtualFile copyDirectoryToProject(@NonNls String sourceFilePath, @NonNls String targetPath) throws IOException {
        assert (this.getTestDataPath() != null) : "test data path not specified";
        File fromFile = new File(this.getTestDataPath() + "/" + sourceFilePath);
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.copyAll(fromFile.getPath(), targetPath);
        }
        File destFile = new File(this.getTempDirPath() + "/" + targetPath);
        FileUtil.copyDir((File)fromFile, (File)destFile);
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(destFile);
        Assert.assertNotNull((Object)file);
        file.refresh(false, true);
        return file;
    }

    @Override
    public VirtualFile copyFileToProject(@NonNls String sourceFilePath) throws IOException {
        return this.copyFileToProject(sourceFilePath, sourceFilePath);
    }

    @Override
    public void enableInspections(InspectionProfileEntry ... inspections) {
        this.myInspections = inspections;
        if (this.isInitialized()) {
            this.configureInspections(this.myInspections);
        }
    }

    private boolean isInitialized() {
        return this.myPsiManager != null;
    }

    @Override
    public void enableInspections(Class<? extends LocalInspectionTool> ... inspections) {
        ArrayList<LocalInspectionTool> tools = new ArrayList<LocalInspectionTool>();
        for (Class<? extends LocalInspectionTool> clazz : inspections) {
            try {
                LocalInspectionTool inspection = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                tools.add(inspection);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instantiate " + clazz);
            }
        }
        this.enableInspections((InspectionProfileEntry[])tools.toArray(new LocalInspectionTool[tools.size()]));
    }

    @Override
    public void disableInspections(InspectionProfileEntry ... inspections) {
        this.myAvailableTools.clear();
        this.myAvailableLocalTools.clear();
        ArrayList<InspectionProfileEntry> tools = new ArrayList<InspectionProfileEntry>(Arrays.asList(this.myInspections));
        Iterator<InspectionProfileEntry> i = tools.iterator();
        block0: while (i.hasNext()) {
            InspectionProfileEntry tool = i.next();
            for (InspectionProfileEntry toRemove : inspections) {
                if (!tool.getShortName().equals(toRemove.getShortName())) continue;
                i.remove();
                continue block0;
            }
        }
        this.myInspections = tools.toArray(new InspectionProfileEntry[tools.size()]);
        this.configureInspections(this.myInspections);
    }

    @Override
    public void enableInspections(InspectionToolProvider ... providers) {
        ArrayList<LocalInspectionTool> tools = new ArrayList<LocalInspectionTool>();
        for (InspectionToolProvider provider : providers) {
            for (Class clazz : provider.getInspectionClasses()) {
                try {
                    Object o = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!(o instanceof LocalInspectionTool)) continue;
                    LocalInspectionTool inspection = (LocalInspectionTool)o;
                    tools.add(inspection);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate " + clazz, e);
                }
            }
        }
        this.myInspections = (InspectionProfileEntry[])tools.toArray(new LocalInspectionTool[tools.size()]);
        this.configureInspections(this.myInspections);
    }

    @Override
    public long testHighlighting(final boolean checkWarnings, final boolean checkInfos, final boolean checkWeakWarnings, final String ... filePaths) throws Exception {
        final Ref duration = new Ref();
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Exception {
                if (filePaths.length > 0) {
                    CodeInsightTestFixtureImpl.this.configureByFilesInner(filePaths);
                }
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlightings(checkWarnings, checkInfos, checkWeakWarnings, (Ref<Long>)duration);
            }
        }.execute().throwException();
        return (Long)duration.get();
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) throws Exception {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String path : filePaths) {
            files.add(this.copyFileToProject(path));
        }
        return this.testHighlightingAllFiles(checkWarnings, checkInfos, checkWeakWarnings, VfsUtil.toVirtualFileArray(files));
    }

    @Override
    public long testHighlightingAllFiles(final boolean checkWarnings, final boolean checkInfos, final boolean checkWeakWarnings, final VirtualFile ... files) throws Exception {
        final Ref duration = new Ref();
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Exception {
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlightings(checkWarnings, checkInfos, checkWeakWarnings, (Ref<Long>)duration, files);
            }
        }.execute().throwException();
        return (Long)duration.get();
    }

    private void collectAndCheckHighlightings(final boolean checkWarnings, final boolean checkInfos, final boolean checkWeakWarnings, Ref<Long> duration, VirtualFile[] files) {
        List datas = ContainerUtil.map2List((Object[])files, (Function)new Function<VirtualFile, Trinity<PsiFile, Editor, ExpectedHighlightingData>>(){

            public Trinity<PsiFile, Editor, ExpectedHighlightingData> fun(VirtualFile file) {
                PsiFile psiFile = CodeInsightTestFixtureImpl.this.myPsiManager.findFile(file);
                Assert.assertNotNull((Object)psiFile);
                Document document = PsiDocumentManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject()).getDocument(psiFile);
                Assert.assertNotNull((Object)document);
                return Trinity.create((Object)psiFile, (Object)CodeInsightTestFixtureImpl.this.createEditor(file), (Object)new ExpectedHighlightingData(document, checkWarnings, checkWeakWarnings, checkInfos, psiFile));
            }
        });
        for (Trinity trinity : datas) {
            this.myEditor = (Editor)trinity.second;
            this.myFile = (PsiFile)trinity.first;
            this.collectAndCheckHighlightings((ExpectedHighlightingData)trinity.third, duration);
        }
    }

    @Override
    public long checkHighlighting(final boolean checkWarnings, final boolean checkInfos, final boolean checkWeakWarnings) throws Exception {
        final Ref duration = new Ref();
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Exception {
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlightings(checkWarnings, checkInfos, checkWeakWarnings, (Ref<Long>)duration);
            }
        }.execute().throwException();
        return (Long)duration.get();
    }

    @Override
    public long checkHighlighting() throws Exception {
        return this.checkHighlighting(true, true, true);
    }

    @Override
    public long testHighlighting(String ... filePaths) throws Exception {
        return this.testHighlighting(true, true, true, filePaths);
    }

    @Override
    public long testHighlighting(final boolean checkWarnings, final boolean checkInfos, final boolean checkWeakWarnings, final VirtualFile file) throws Exception {
        final Ref duration = new Ref();
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Exception {
                CodeInsightTestFixtureImpl.this.openFileInEditor(file);
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlightings(checkWarnings, checkInfos, checkWeakWarnings, (Ref<Long>)duration);
            }
        }.execute().throwException();
        return (Long)duration.get();
    }

    public void openFileInEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.openFileInEditor must not be null");
        }
        this.myFile = this.myPsiManager.findFile(file);
        this.myEditor = this.createEditor(file);
    }

    @Override
    public void testInspection(String testDir, InspectionTool tool) throws Exception {
        VirtualFile sourceDir = this.copyDirectoryToProject(new File(testDir, "src").getPath(), "src");
        AnalysisScope scope = new AnalysisScope(this.getPsiManager().findDirectory(sourceDir));
        InspectionManagerEx inspectionManager = (InspectionManagerEx)InspectionManager.getInstance((Project)this.getProject());
        GlobalInspectionContextImpl globalContext = inspectionManager.createNewGlobalContext(!(this.myProjectFixture instanceof LightIdeaTestFixture));
        globalContext.setCurrentScope(scope);
        scope.invalidate();
        InspectionTestUtil.runTool(tool, scope, globalContext, inspectionManager);
        InspectionTestUtil.compareToolResults(tool, false, new File(this.getTestDataPath(), testDir).getPath());
    }

    @Override
    @Nullable
    public PsiReference getReferenceAtCaretPosition(final String ... filePaths) throws Exception {
        new WriteCommandAction<PsiReference>(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run(Result<PsiReference> result) throws Exception {
                CodeInsightTestFixtureImpl.this.configureByFilesInner(filePaths);
            }
        }.execute().throwException();
        return this.getFile().findReferenceAt(this.myEditor.getCaretModel().getOffset());
    }

    @Override
    @NotNull
    public PsiReference getReferenceAtCaretPositionWithAssertion(String ... filePaths) throws Exception {
        PsiReference reference = this.getReferenceAtCaretPosition(filePaths);
        assert (reference != null) : "no reference found at " + this.myEditor.getCaretModel().getLogicalPosition();
        PsiReference psiReference = reference;
        if (psiReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.getReferenceAtCaretPositionWithAssertion must not return null");
        }
        return psiReference;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions(final String ... filePaths) throws Exception {
        List list = (List)new WriteCommandAction<List<IntentionAction>>(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run(Result<List<IntentionAction>> result) throws Exception {
                CodeInsightTestFixtureImpl.this.configureByFilesInner(filePaths);
                result.setResult(CodeInsightTestFixtureImpl.this.getAvailableIntentions());
            }
        }.execute().getResultObject();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.getAvailableIntentions must not return null");
        }
        return list;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAllQuickFixes(final String ... filePaths) {
        List list = (List)new WriteCommandAction<List<IntentionAction>>(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run(Result<List<IntentionAction>> result) throws Exception {
                CodeInsightTestFixtureImpl.this.configureByFilesInner(filePaths);
                List<HighlightInfo> infos = CodeInsightTestFixtureImpl.this.doHighlighting();
                ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
                for (HighlightInfo info : infos) {
                    for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                        actions.add(((HighlightInfo.IntentionActionDescriptor)pair.getFirst()).getAction());
                    }
                }
                result.setResult(actions);
            }
        }.execute().getResultObject();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.getAllQuickFixes must not return null");
        }
        return list;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions() {
        this.doHighlighting();
        List<IntentionAction> list = CodeInsightTestFixtureImpl.getAvailableIntentions(this.myEditor, this.myFile);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.getAvailableIntentions must not return null");
        }
        return list;
    }

    @Override
    public List<IntentionAction> filterAvailableIntentions(final @NotNull String hint) throws Exception {
        if (hint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.filterAvailableIntentions must not be null");
        }
        List<IntentionAction> availableIntentions = this.getAvailableIntentions();
        return ContainerUtil.findAll(availableIntentions, (Condition)new Condition<IntentionAction>(){

            public boolean value(IntentionAction intentionAction) {
                return intentionAction.getText().startsWith(hint);
            }
        });
    }

    @Override
    public IntentionAction findSingleIntention(@NotNull String hint) throws Exception {
        if (hint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.findSingleIntention must not be null");
        }
        List<IntentionAction> list = this.filterAvailableIntentions(hint);
        if (list.size() != 1) {
            Assert.fail((String)StringUtil.join(this.getAvailableIntentions(), (Function)new Function<IntentionAction, String>(){

                public String fun(IntentionAction intentionAction) {
                    return intentionAction.getText();
                }
            }, (String)", "));
        }
        return UsefulTestCase.assertOneElement(list);
    }

    @Override
    public IntentionAction getAvailableIntention(String intentionName, String ... filePaths) throws Exception {
        List<IntentionAction> intentions = this.getAvailableIntentions(filePaths);
        return CodeInsightTestUtil.findIntentionByText(intentions, intentionName);
    }

    @Override
    public void launchAction(final @NotNull IntentionAction action) throws Exception {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.launchAction must not be null");
        }
        new WriteCommandAction(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Exception {
                ShowIntentionActionsHandler.chooseActionAndInvoke(CodeInsightTestFixtureImpl.this.getFile(), CodeInsightTestFixtureImpl.this.getEditor(), action, action.getText());
            }
        }.execute().throwException();
    }

    @Override
    public void testCompletion(String[] filesBefore, String fileAfter) throws Exception {
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        Object[] items = this.complete(CompletionType.BASIC);
        if (items != null) {
            System.out.println("items = " + Arrays.toString(items));
        }
        this.checkResultByFile(fileAfter);
    }

    protected void assertInitialized() {
        Assert.assertNotNull((String)"setUp() hasn't been called", (Object)((Object)this.myPsiManager));
    }

    @Override
    public void testCompletion(String fileBefore, String fileAfter, String ... additionalFiles) throws Exception {
        this.testCompletion((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore)), fileAfter);
    }

    @Override
    public void testCompletionVariants(String fileBefore, String ... expectedItems) throws Exception {
        this.assertInitialized();
        List<String> result = this.getCompletionVariants(fileBefore);
        UsefulTestCase.assertSameElements(result, expectedItems);
    }

    @Override
    public List<String> getCompletionVariants(String ... filesBefore) throws Exception {
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        LookupElement[] items = this.complete(CompletionType.BASIC);
        Assert.assertNotNull((String)"No lookup was shown, probably there was only one lookup element that was inserted automatically", (Object)items);
        return this.getLookupElementStrings();
    }

    @Override
    @Nullable
    public List<String> getLookupElementStrings() {
        this.assertInitialized();
        Object[] elements = this.getLookupElements();
        if (elements == null) {
            return null;
        }
        return ContainerUtil.map((Object[])elements, (Function)new Function<LookupElement, String>(){

            public String fun(LookupElement lookupItem) {
                return lookupItem.getLookupString();
            }
        });
    }

    @Override
    public void testRename(String fileBefore, String fileAfter, String newName, String ... additionalFiles) throws Exception {
        this.assertInitialized();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore)));
        this.testRename(fileAfter, newName);
    }

    @Override
    public void testRename(String fileAfter, String newName) throws Exception {
        this.renameElementAtCaret(newName);
        this.checkResultByFile(fileAfter);
    }

    @Override
    @NotNull
    public PsiElement getElementAtCaret() {
        this.assertInitialized();
        PsiElement element = TargetElementUtilBase.findTargetElement(this.getCompletionEditor(), 3);
        assert (element != null) : "element not found in file " + this.myFile.getName() + " at caret position, offset " + this.myEditor.getCaretModel().getOffset();
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.getElementAtCaret must not return null");
        }
        return psiElement;
    }

    @Override
    public void renameElementAtCaret(String newName) throws Exception {
        this.assertInitialized();
        PsiElement element = TargetElementUtilBase.findTargetElement(this.getCompletionEditor(), 3);
        assert (element != null) : "element not found in file " + this.myFile.getName() + " at caret position, offset " + this.myEditor.getCaretModel().getOffset();
        this.renameElement(element, newName);
    }

    @Override
    public void renameElement(PsiElement element, String newName) throws Exception {
        boolean searchInComments = false;
        boolean searchTextOccurrences = false;
        this.renameElement(element, newName, false, false);
    }

    @Override
    public void renameElement(final PsiElement element, final String newName, final boolean searchInComments, final boolean searchTextOccurrences) throws Exception {
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Exception {
                PsiElement substitution = RenamePsiElementProcessor.forElement(element).substituteElementToRename(element, CodeInsightTestFixtureImpl.this.myEditor);
                new RenameProcessor(CodeInsightTestFixtureImpl.this.myProjectFixture.getProject(), substitution, newName, searchInComments, searchTextOccurrences).run();
            }
        }.execute().throwException();
    }

    @Override
    public void type(final char c) {
        this.assertInitialized();
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Exception {
                EditorActionManager actionManager = EditorActionManager.getInstance();
                DataContext dataContext = DataManager.getInstance().getDataContext();
                if (c == '\b') {
                    CodeInsightTestFixtureImpl.this.performEditorAction("EditorBackSpace");
                    return;
                }
                if (c == '\n') {
                    if (LookupManager.getActiveLookup(CodeInsightTestFixtureImpl.this.getEditor()) != null) {
                        CodeInsightTestFixtureImpl.this.performEditorAction("EditorChooseLookupItem");
                        return;
                    }
                    CodeInsightTestFixtureImpl.this.performEditorAction("EditorEnter");
                    return;
                }
                if (c == '\t' && LookupManager.getInstance(this.getProject()).getActiveLookup() != null) {
                    CodeInsightTestFixtureImpl.this.performEditorAction("EditorChooseLookupItemReplace");
                    return;
                }
                actionManager.getTypedAction().actionPerformed(CodeInsightTestFixtureImpl.this.getEditor(), c, dataContext);
            }
        }.execute();
    }

    @Override
    public void performEditorAction(String actionId) {
        this.assertInitialized();
        DataContext dataContext = DataManager.getInstance().getDataContext();
        EditorActionManager actionManager = EditorActionManager.getInstance();
        actionManager.getActionHandler(actionId).execute(this.getEditor(), dataContext);
    }

    @Override
    public Collection<UsageInfo> testFindUsages(String ... fileNames) throws Exception {
        this.assertInitialized();
        this.configureByFiles(fileNames);
        PsiElement targetElement = TargetElementUtilBase.findTargetElement(this.getEditor(), 3);
        assert (targetElement != null) : "Cannot find referenced element";
        return this.findUsages(targetElement);
    }

    @Override
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement) {
        if (targetElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.findUsages must not be null");
        }
        Project project = this.getProject();
        FindUsagesHandler handler = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager().getFindUsagesHandler(targetElement, false);
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        assert (handler != null) : "Cannot find handler for: " + targetElement;
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler.getPrimaryElements(), (Object[])handler.getSecondaryElements(), PsiElement.class);
        FindUsagesOptions options = handler.getFindUsagesOptions();
        for (PsiElement psiElement : psiElements) {
            handler.processElementUsages(psiElement, (Processor<UsageInfo>)processor, options);
        }
        return processor.getResults();
    }

    @Override
    public RangeHighlighter[] testHighlightUsages(String ... files) {
        this.configureByFiles(files);
        Editor editor = this.getEditor();
        HighlightUsagesHandler.invoke(this.getProject(), editor, this.getFile());
        return editor.getMarkupModel().getAllHighlighters();
    }

    @Override
    public void moveFile(final @NonNls String filePath, final @NonNls String to, final String ... additionalFiles) throws Exception {
        this.assertInitialized();
        final Project project = this.myProjectFixture.getProject();
        new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Exception {
                CodeInsightTestFixtureImpl.this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)filePath)));
                VirtualFile file = CodeInsightTestFixtureImpl.this.findFileInTempDir(to);
                assert (file.isDirectory()) : to + " is not a directory";
                PsiDirectory directory = CodeInsightTestFixtureImpl.this.myPsiManager.findDirectory(file);
                new MoveFilesOrDirectoriesProcessor(project, new PsiElement[]{CodeInsightTestFixtureImpl.this.myFile}, directory, false, false, null, null).run();
            }
        }.execute().throwException();
    }

    @Override
    @Nullable
    public GutterIconRenderer findGutter(final String filePath) throws Exception {
        this.assertInitialized();
        Project project = this.myProjectFixture.getProject();
        final Ref result = new Ref();
        new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Exception {
                int offset = CodeInsightTestFixtureImpl.this.configureByFilesInner(new String[]{filePath});
                List<HighlightInfo> infos = CodeInsightTestFixtureImpl.this.doHighlighting();
                for (HighlightInfo info : infos) {
                    GutterIconRenderer renderer;
                    if (info.endOffset < offset || info.startOffset > offset || (renderer = info.getGutterIconRenderer()) == null) continue;
                    result.set((Object)renderer);
                    return;
                }
            }
        }.execute().throwException();
        return (GutterIconRenderer)result.get();
    }

    @Override
    @NotNull
    public Collection<GutterIconRenderer> findAllGutters(final String filePath) throws Exception {
        this.assertInitialized();
        final Project project = this.myProjectFixture.getProject();
        final TreeMap result = new TreeMap();
        new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Exception {
                CodeInsightTestFixtureImpl.this.configureByFilesInner(new String[]{filePath});
                for (HighlightInfo info : CodeInsightTestFixtureImpl.this.doHighlighting()) {
                    this.addGutterIconRenderer(info.getGutterIconRenderer(), info.startOffset);
                }
                for (RangeHighlighter highlighter : CodeInsightTestFixtureImpl.this.myEditor.getDocument().getMarkupModel(project).getAllHighlighters()) {
                    this.addGutterIconRenderer(highlighter.getGutterIconRenderer(), highlighter.getStartOffset());
                }
            }

            private void addGutterIconRenderer(GutterIconRenderer renderer, int offset) {
                if (renderer == null) {
                    return;
                }
                List renderers = (List)result.get(offset);
                if (renderers == null) {
                    renderers = new SmartList();
                    result.put(offset, renderers);
                }
                renderers.add(renderer);
            }
        }.execute().throwException();
        List list = ContainerUtil.concat(result.values());
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.findAllGutters must not return null");
        }
        return list;
    }

    @Override
    public PsiFile addFileToProject(@NonNls String relativePath, @NonNls String fileText) throws IOException {
        this.assertInitialized();
        return this.addFileToProject(this.getTempDirPath(), relativePath, fileText);
    }

    protected PsiFile addFileToProject(String rootPath, String relativePath, String fileText) throws IOException {
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            VirtualFile file = this.myTempDirFixture.createFile(relativePath, fileText);
            return PsiManager.getInstance((Project)this.getProject()).findFile(file);
        }
        return ((HeavyIdeaTestFixture)this.myProjectFixture).addFileToProject(rootPath, relativePath, fileText);
    }

    public <T> void registerExtension(ExtensionsArea area, ExtensionPointName<T> epName, final T extension) {
        this.assertInitialized();
        final ExtensionPoint extensionPoint = area.getExtensionPoint(epName);
        extensionPoint.registerExtension(extension);
        this.disposeOnTearDown(new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    @Override
    public PsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @Override
    public LookupElement[] complete(final CompletionType type) {
        this.assertInitialized();
        this.myEmptyLookup = false;
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Exception {
                CodeCompletionHandlerBase handler = new CodeCompletionHandlerBase(type){

                    @Override
                    protected PsiFile createFileCopy(PsiFile file) {
                        PsiFile copy = super.createFileCopy(file);
                        if (CodeInsightTestFixtureImpl.this.myFileContext != null) {
                            PsiElement contextCopy = CodeInsightTestFixtureImpl.this.myFileContext.copy();
                            PsiFile containingFile = contextCopy.getContainingFile();
                            if (containingFile instanceof PsiFileImpl) {
                                ((PsiFileImpl)containingFile).setOriginalFile(CodeInsightTestFixtureImpl.this.myFileContext.getContainingFile());
                            }
                            CodeInsightTestFixtureImpl.setContext(copy, contextCopy);
                        }
                        return copy;
                    }

                    @Override
                    protected void completionFinished(int offset1, int offset2, CompletionContext context, CompletionProgressIndicator indicator, LookupElement[] items) {
                        CodeInsightTestFixtureImpl.this.myEmptyLookup = items.length == 0;
                        super.completionFinished(offset1, offset2, context, indicator, items);
                    }
                };
                Editor editor = CodeInsightTestFixtureImpl.this.getCompletionEditor();
                handler.invoke(this.getProject(), editor, PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)this.getProject()));
            }
        }.execute();
        return this.getLookupElements();
    }

    @Nullable
    protected Editor getCompletionEditor() {
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.myFile);
    }

    @Override
    @Nullable
    public LookupElement[] completeBasic() {
        return this.complete(CompletionType.BASIC);
    }

    @Override
    @Nullable
    public LookupElement[] getLookupElements() {
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
        if (lookup == null) {
            return this.myEmptyLookup ? LookupElement.EMPTY_ARRAY : null;
        }
        List<LookupElement> list = lookup.getItems();
        return list.toArray(new LookupElement[list.size()]);
    }

    @Override
    public void checkResult(String text) {
        this.checkResult(text, false);
    }

    @Override
    public void checkResult(String text, boolean stripTrailingSpaces) {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        EditorUtil.fillVirtualSpaceUntilCaret(this.myEditor);
        this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(text, this.getProject()), this.myFile.getText());
    }

    @Override
    public void checkResultByFile(String expectedFile) throws Exception {
        this.checkResultByFile(expectedFile, false);
    }

    @Override
    public void checkResultByFile(final String expectedFile, final boolean ignoreTrailingWhitespaces) throws Exception {
        this.assertInitialized();
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Exception {
                CodeInsightTestFixtureImpl.this.checkResultByFile(expectedFile, CodeInsightTestFixtureImpl.this.myFile, ignoreTrailingWhitespaces);
            }
        }.execute().throwException();
    }

    @Override
    public void checkResultByFile(final String filePath, final String expectedFile, final boolean ignoreTrailingWhitespaces) throws Exception {
        this.assertInitialized();
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Exception {
                VirtualFile copy = CodeInsightTestFixtureImpl.this.findFileInTempDir(filePath.replace(File.separatorChar, '/'));
                PsiFile psiFile = CodeInsightTestFixtureImpl.this.myPsiManager.findFile(copy);
                assert (psiFile != null);
                CodeInsightTestFixtureImpl.this.checkResultByFile(expectedFile, psiFile, ignoreTrailingWhitespaces);
            }
        }.execute().throwException();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.myProjectFixture.setUp();
        this.myTempDirFixture.setUp();
        this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance((Project)this.getProject());
        this.configureInspections((InspectionProfileEntry[])(this.myInspections == null ? new LocalInspectionTool[]{} : this.myInspections));
        DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
    }

    private void enableInspectionTool(InspectionProfileEntry tool) {
        String shortName = tool.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        if (key == null) {
            String id = tool instanceof LocalInspectionTool ? ((LocalInspectionTool)tool).getID() : shortName;
            HighlightDisplayKey.register((String)shortName, (String)tool.getDisplayName(), (String)id);
        }
        this.myAvailableTools.put(shortName, tool);
        this.myAvailableLocalTools.put(shortName, tool instanceof LocalInspectionTool ? new LocalInspectionToolWrapper((LocalInspectionTool)tool) : (InspectionTool)tool);
    }

    private void configureInspections(InspectionProfileEntry[] tools) {
        for (InspectionProfileEntry tool : tools) {
            this.enableInspectionTool(tool);
        }
        InspectionProfileImpl profile = new InspectionProfileImpl(PROFILE){

            @Override
            @NotNull
            public ModifiableModel getModifiableModel() {
                this.mySource = this;
                22 v0 = this;
                if (v0 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$22.getModifiableModel must not return null");
                }
                return v0;
            }

            @Override
            @NotNull
            public InspectionProfileEntry[] getInspectionTools(PsiElement element) {
                Collection tools = CodeInsightTestFixtureImpl.this.myAvailableLocalTools.values();
                InspectionProfileEntry[] inspectionProfileEntryArray = tools.toArray(new InspectionTool[tools.size()]);
                if (inspectionProfileEntryArray == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$22.getInspectionTools must not return null");
                }
                return inspectionProfileEntryArray;
            }

            @Override
            public List<ToolsImpl> getAllEnabledInspectionTools() {
                ArrayList<ToolsImpl> result = new ArrayList<ToolsImpl>();
                for (InspectionProfileEntry entry : this.getInspectionTools(null)) {
                    result.add(new ToolsImpl(entry, entry.getDefaultLevel(), true));
                }
                return result;
            }

            @Override
            public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
                return key != null && key.toString() != null && CodeInsightTestFixtureImpl.this.myAvailableTools.containsKey(key.toString());
            }

            @Override
            public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, PsiElement element) {
                if (key == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$22.getErrorLevel must not be null");
                }
                InspectionProfileEntry entry = (InspectionProfileEntry)CodeInsightTestFixtureImpl.this.myAvailableTools.get(key.toString());
                return entry != null ? entry.getDefaultLevel() : HighlightDisplayLevel.WARNING;
            }

            @Override
            public InspectionTool getInspectionTool(@NotNull String shortName, @NotNull PsiElement element) {
                if (shortName == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$22.getInspectionTool must not be null");
                }
                if (element == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$22.getInspectionTool must not be null");
                }
                return (InspectionTool)((Object)CodeInsightTestFixtureImpl.this.myAvailableLocalTools.get(shortName));
            }
        };
        final InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        inspectionProfileManager.addProfile((Profile)profile);
        Disposer.register((Disposable)this.getProject(), (Disposable)new Disposable(){

            public void dispose() {
                inspectionProfileManager.deleteProfile(CodeInsightTestFixtureImpl.PROFILE);
            }
        });
        inspectionProfileManager.setRootProfile(profile.getName());
        InspectionProjectProfileManager.getInstance(this.getProject()).updateProfile((Profile)profile);
        InspectionProjectProfileManager.getInstance(this.getProject()).setProjectProfile(profile.getName());
    }

    @Override
    public void tearDown() throws Exception {
        VirtualFile[] openFiles;
        if (SwingUtilities.isEventDispatchThread()) {
            LookupManager.getInstance(this.getProject()).hideActiveLookup();
        } else {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LookupManager.getInstance(CodeInsightTestFixtureImpl.this.getProject()).hideActiveLookup();
                }
            }, ModalityState.NON_MODAL);
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.getProject());
        for (VirtualFile openFile : openFiles = editorManager.getOpenFiles()) {
            editorManager.closeFile(openFile);
        }
        this.myProjectFixture.tearDown();
        this.myTempDirFixture.tearDown();
        super.tearDown();
    }

    private int configureByFilesInner(String ... filePaths) throws IOException {
        this.assertInitialized();
        this.myFile = null;
        this.myEditor = null;
        for (int i = filePaths.length - 1; i > 0; --i) {
            this.configureByFileInner(filePaths[i]);
        }
        return this.configureByFileInner(filePaths[0]);
    }

    @Override
    public void configureByFile(final String file) {
        this.assertInitialized();
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Exception {
                CodeInsightTestFixtureImpl.this.configureByFilesInner(new String[]{file});
            }
        }.execute();
    }

    @Override
    public void configureByFiles(final String ... files) {
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Exception {
                CodeInsightTestFixtureImpl.this.configureByFilesInner(files);
            }
        }.execute();
    }

    @Override
    public PsiFile configureByText(final FileType fileType, @NonNls String text) throws IOException {
        VirtualFile vFile;
        this.assertInitialized();
        final String extension = fileType.getDefaultExtension();
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager.getFileTypeByExtension(extension) != fileType) {
            new WriteCommandAction(this.getProject(), new PsiFile[0]){

                protected void run(Result result) throws Exception {
                    fileTypeManager.associateExtension(fileType, extension);
                }
            }.execute();
        }
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            VirtualFile root = LightPlatformTestCase.getSourceRoot();
            root.refresh(false, false);
            vFile = root.findOrCreateChildData((Object)this, "aaa." + extension);
        } else {
            File tempFile = File.createTempFile("aaa", "." + extension, new File(this.getTempDirPath()));
            vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
        }
        VfsUtil.saveText((VirtualFile)vFile, (String)text);
        this.configureInner(vFile, SelectionAndCaretMarkupLoader.fromFile(vFile, this.getProject()));
        return this.myFile;
    }

    @Override
    public PsiFile configureByText(String fileName, @NonNls String text) throws IOException {
        return this.configureByText(FileTypeManager.getInstance().getFileTypeByFileName(fileName), text);
    }

    @Override
    public Document getDocument(PsiFile file) {
        this.assertInitialized();
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
    }

    @Override
    public void setFileContext(@Nullable PsiElement context) {
        this.myFileContext = context;
        CodeInsightTestFixtureImpl.setContext(this.myFile, context);
    }

    private int configureByFileInner(@NonNls String filePath) throws IOException {
        this.assertInitialized();
        VirtualFile file = this.copyFileToProject(filePath);
        return this.configureByFileInner(file);
    }

    @Override
    public int configureFromTempProjectFile(String filePath) throws IOException {
        return this.configureByFileInner(this.findFileInTempDir(filePath));
    }

    @Override
    public void configureFromExistingVirtualFile(VirtualFile f) throws IOException {
        this.configureByFileInner(f);
    }

    private int configureByFileInner(VirtualFile copy) throws IOException {
        return this.configureInner(copy, SelectionAndCaretMarkupLoader.fromFile(copy, this.getProject()));
    }

    private int configureInner(@NotNull VirtualFile copy, SelectionAndCaretMarkupLoader loader) {
        Module module;
        if (copy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.configureInner must not be null");
        }
        this.assertInitialized();
        try {
            OutputStream outputStream = copy.getOutputStream(null, 0L, 0L);
            outputStream.write(loader.newFileText.getBytes(copy.getCharset().name()));
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.myFile = this.myPsiManager.findFile(copy);
        CodeInsightTestFixtureImpl.setContext(this.myFile, this.myFileContext);
        this.myEditor = this.createEditor(copy);
        assert (this.myEditor != null) : "Editor couldn't be created for file: " + copy.getPath() + ", use copyFileToProject(..) method for this file instead of configureByFile(..)";
        int offset = -1;
        if (loader.caretMarker != null) {
            offset = loader.caretMarker.getStartOffset();
            this.myEditor.getCaretModel().moveToOffset(offset);
        }
        if (loader.selStartMarker != null && loader.selEndMarker != null) {
            this.myEditor.getSelectionModel().setSelection(loader.selStartMarker.getStartOffset(), loader.selEndMarker.getStartOffset());
        }
        if ((module = this.getModule()) != null) {
            for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
                ((FacetManagerListener)module.getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged(facet);
            }
        }
        return offset;
    }

    private static void setContext(PsiFile file, PsiElement context) {
        if (file != null && context != null) {
            file.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, (Object)new IdentitySmartPointer(context));
        }
    }

    @Override
    public VirtualFile findFileInTempDir(String filePath) {
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.getFile(filePath);
        }
        String fullPath = this.getTempDirPath() + "/" + filePath;
        VirtualFile copy = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath.replace(File.separatorChar, '/'));
        assert (copy != null) : "file " + fullPath + " not found";
        return copy;
    }

    @Nullable
    private Editor createEditor(VirtualFile file) {
        Project project = this.getProject();
        FileEditorManager instance = FileEditorManager.getInstance((Project)project);
        if (file.getFileType().isBinary()) {
            return null;
        }
        return instance.openTextEditor(new OpenFileDescriptor(project, file, 0), false);
    }

    private void collectAndCheckHighlightings(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, Ref<Long> duration) throws Exception {
        ExpectedHighlightingData data = new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos, this.myFile);
        this.collectAndCheckHighlightings(data, duration);
    }

    private void collectAndCheckHighlightings(ExpectedHighlightingData data, Ref<Long> duration) {
        Project project = this.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ((PsiFileImpl)this.myFile).calcTreeElement();
        this.myPsiManager.getCacheManager().getFilesWithWord(XXX, (short)2, GlobalSearchScope.allScope((Project)project), true);
        ((PsiManagerImpl)PsiManager.getInstance((Project)project)).setAssertOnFileLoadingFilter(this.myJavaFilesFilter);
        long start = System.currentTimeMillis();
        List<HighlightInfo> infos = this.doHighlighting();
        CodeInsightTestFixtureImpl.removeDuplicatedRangesForInjected(infos);
        long elapsed = System.currentTimeMillis() - start;
        duration.set((Object)(duration.isNull() ? elapsed : (Long)duration.get() + elapsed));
        ((PsiManagerImpl)PsiManager.getInstance((Project)project)).setAssertOnFileLoadingFilter(VirtualFileFilter.NONE);
        data.checkResult(infos, this.myEditor.getDocument().getText());
    }

    private static void removeDuplicatedRangesForInjected(List<HighlightInfo> infos) {
        Collections.sort(infos, new Comparator<HighlightInfo>(){

            @Override
            public int compare(HighlightInfo o1, HighlightInfo o2) {
                int i = o2.startOffset - o1.startOffset;
                return i != 0 ? i : o1.getSeverity().myVal - o2.getSeverity().myVal;
            }
        });
        HighlightInfo prevInfo = null;
        Iterator<HighlightInfo> it = infos.iterator();
        while (it.hasNext()) {
            HighlightInfo info = it.next();
            if (prevInfo != null && info.getSeverity() == HighlightSeverity.INFORMATION && info.description == null && info.startOffset == prevInfo.startOffset && info.endOffset == prevInfo.endOffset) {
                it.remove();
            }
            prevInfo = info.getSeverity() == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY ? info : null;
        }
    }

    @NotNull
    public List<HighlightInfo> doHighlighting() {
        Project project = this.myProjectFixture.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<HighlightInfo>>(){

            public List<HighlightInfo> compute() {
                return CodeInsightTestFixtureImpl.instantiateAndRun(CodeInsightTestFixtureImpl.this.getFile(), CodeInsightTestFixtureImpl.this.getEditor(), ArrayUtil.EMPTY_INT_ARRAY, false);
            }
        });
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.doHighlighting must not return null");
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<HighlightInfo> instantiateAndRun(PsiFile file, Editor editor, int[] toIgnore, boolean allowDirt) {
        Project project = file.getProject();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project);
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        FileStatusMap fileStatusMap = codeAnalyzer.getFileStatusMap();
        for (int ignoreId : toIgnore) {
            fileStatusMap.markFileUpToDate(editor.getDocument(), file, ignoreId);
        }
        fileStatusMap.allowDirt(allowDirt);
        TextEditorBackgroundHighlighter highlighter = (TextEditorBackgroundHighlighter)TextEditorProvider.getInstance().getTextEditor(editor).getBackgroundHighlighter();
        final List<TextEditorHighlightingPass> passes = highlighter.getPasses(toIgnore);
        final DaemonProgressIndicator progress = new DaemonProgressIndicator();
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                for (TextEditorHighlightingPass pass : passes) {
                    pass.collectInformation(progress);
                    pass.applyInformationToEditor();
                }
            }
        }, (ProgressIndicator)progress);
        List<HighlightInfo> infos = DaemonCodeAnalyzerImpl.getHighlights(editor.getDocument(), project);
        ArrayList<HighlightInfo> arrayList = infos == null ? Collections.emptyList() : new ArrayList<HighlightInfo>(infos);
        ArrayList<HighlightInfo> arrayList2 = arrayList;
        if (arrayList2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.instantiateAndRun must not return null");
        }
        return arrayList2;
        finally {
            fileStatusMap.allowDirt(true);
            codeAnalyzer.clearPasses();
        }
    }

    private static void ensureIndexesUpToDate(Project project) {
        FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, null);
        FileBasedIndex.getInstance().ensureUpToDate(TodoIndex.NAME, project, null);
        CodeInsightTestFixtureImpl.assertTrue((!DumbServiceImpl.getInstance(project).isDumb() ? 1 : 0) != 0);
    }

    @Override
    public String getTestDataPath() {
        return this.myTestDataPath;
    }

    @Override
    public Project getProject() {
        return this.myProjectFixture.getProject();
    }

    @Override
    public Module getModule() {
        return this.myProjectFixture.getModule();
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public PsiFile getFile() {
        return this.myFile;
    }

    public static List<IntentionAction> getAvailableIntentions(final Editor editor, final PsiFile file) {
        return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<IntentionAction>>(){

            public List<IntentionAction> compute() {
                return CodeInsightTestFixtureImpl.doGetAvailableIntentions(editor, file);
            }
        });
    }

    private static List<IntentionAction> doGetAvailableIntentions(Editor editor, PsiFile file) {
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(editor, file, intentions, -1);
        ArrayList<HighlightInfo.IntentionActionDescriptor> descriptors = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        descriptors.addAll(intentions.intentionsToShow);
        descriptors.addAll(intentions.errorFixesToShow);
        descriptors.addAll(intentions.inspectionFixesToShow);
        descriptors.addAll(intentions.guttersToShow);
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        List<HighlightInfo> infos = DaemonCodeAnalyzerImpl.getFileLevelHighlights(file.getProject(), file);
        for (HighlightInfo info : infos) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
                if (!actionInGroup.getAction().isAvailable(file.getProject(), editor, file)) continue;
                descriptors.add(actionInGroup);
            }
        }
        for (HighlightInfo.IntentionActionDescriptor descriptor : descriptors) {
            result.add(descriptor.getAction());
            List<IntentionAction> options = descriptor.getOptions(element);
            if (options == null) continue;
            for (IntentionAction option : options) {
                if (!option.isAvailable(file.getProject(), editor, file)) continue;
                result.add(option);
            }
        }
        return result;
    }

    @Override
    public void allowTreeAccessForFile(VirtualFile file) {
        this.myJavaFilesFilter.allowTreeAccessForFile(file);
    }

    @Override
    public void allowTreeAccessForAllFiles() {
        this.myJavaFilesFilter.allowTreeAccessForAllFiles();
    }

    private void checkResultByFile(@NonNls String expectedFile, @NotNull PsiFile originalFile, boolean stripTrailingSpaces) throws IOException {
        if (originalFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.checkResultByFile must not be null");
        }
        if (!stripTrailingSpaces) {
            EditorUtil.fillVirtualSpaceUntilCaret(this.myEditor);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        this.checkResult(expectedFile, stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromFile(this.getTestDataPath() + "/" + expectedFile, this.getProject()), originalFile.getText());
    }

    private void checkResult(String expectedFile, boolean stripTrailingSpaces, SelectionAndCaretMarkupLoader loader, String actualText) {
        this.assertInitialized();
        Project project = this.myProjectFixture.getProject();
        ((PostprocessReformattingAspect)project.getComponent(PostprocessReformattingAspect.class)).doPostponedFormatting();
        if (stripTrailingSpaces) {
            actualText = CodeInsightTestFixtureImpl.stripTrailingSpaces(actualText);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        String newFileText1 = loader.newFileText;
        if (stripTrailingSpaces) {
            newFileText1 = CodeInsightTestFixtureImpl.stripTrailingSpaces(newFileText1);
        }
        actualText = StringUtil.convertLineSeparators((String)actualText);
        Assert.assertEquals((String)("Text mismatch in file " + expectedFile), (String)newFileText1, (String)actualText);
        if (loader.caretMarker != null) {
            int caretLine = StringUtil.offsetToLineNumber((CharSequence)loader.newFileText, (int)loader.caretMarker.getStartOffset());
            int caretCol = loader.caretMarker.getStartOffset() - StringUtil.lineColToOffset((CharSequence)loader.newFileText, (int)caretLine, (int)0);
            Assert.assertEquals((String)"caretLine", (int)(caretLine + 1), (int)(this.myEditor.getCaretModel().getLogicalPosition().line + 1));
            Assert.assertEquals((String)"caretColumn", (int)(caretCol + 1), (int)(this.myEditor.getCaretModel().getLogicalPosition().column + 1));
        }
        if (loader.selStartMarker != null && loader.selEndMarker != null) {
            int selStartLine = StringUtil.offsetToLineNumber((CharSequence)loader.newFileText, (int)loader.selStartMarker.getStartOffset());
            int selStartCol = loader.selStartMarker.getStartOffset() - StringUtil.lineColToOffset((CharSequence)loader.newFileText, (int)selStartLine, (int)0);
            int selEndLine = StringUtil.offsetToLineNumber((CharSequence)loader.newFileText, (int)loader.selEndMarker.getEndOffset());
            int selEndCol = loader.selEndMarker.getEndOffset() - StringUtil.lineColToOffset((CharSequence)loader.newFileText, (int)selEndLine, (int)0);
            Assert.assertEquals((String)"selectionStartLine", (int)(selStartLine + 1), (int)(StringUtil.offsetToLineNumber((CharSequence)loader.newFileText, (int)this.myEditor.getSelectionModel().getSelectionStart()) + 1));
            Assert.assertEquals((String)"selectionStartCol", (int)(selStartCol + 1), (int)(this.myEditor.getSelectionModel().getSelectionStart() - StringUtil.lineColToOffset((CharSequence)loader.newFileText, (int)selStartLine, (int)0) + 1));
            Assert.assertEquals((String)"selectionEndLine", (int)(selEndLine + 1), (int)(StringUtil.offsetToLineNumber((CharSequence)loader.newFileText, (int)this.myEditor.getSelectionModel().getSelectionEnd()) + 1));
            Assert.assertEquals((String)"selectionEndCol", (int)(selEndCol + 1), (int)(this.myEditor.getSelectionModel().getSelectionEnd() - StringUtil.lineColToOffset((CharSequence)loader.newFileText, (int)selEndLine, (int)0) + 1));
        } else if (this.myEditor != null) {
            Assert.assertTrue((String)"has no selection", (!this.myEditor.getSelectionModel().hasSelection() ? 1 : 0) != 0);
        }
    }

    private static String stripTrailingSpaces(String actualText) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)actualText);
        ((DocumentEx)document).stripTrailingSpaces(false);
        actualText = document.getText();
        return actualText;
    }

    static class SelectionAndCaretMarkupLoader {
        final String newFileText;
        final RangeMarker caretMarker;
        final RangeMarker selStartMarker;
        final RangeMarker selEndMarker;

        static SelectionAndCaretMarkupLoader fromFile(String path, Project project) throws IOException {
            return new SelectionAndCaretMarkupLoader(StringUtil.convertLineSeparators((String)new String(FileUtil.loadFileText((File)new File(path)))), project);
        }

        static SelectionAndCaretMarkupLoader fromFile(VirtualFile file, Project project) throws IOException {
            return new SelectionAndCaretMarkupLoader(StringUtil.convertLineSeparators((String)VfsUtil.loadText((VirtualFile)file)), project);
        }

        static SelectionAndCaretMarkupLoader fromText(String text, Project project) {
            return new SelectionAndCaretMarkupLoader(text, project);
        }

        private SelectionAndCaretMarkupLoader(String fileText, Project project) {
            final Document document = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            int caretIndex = fileText.indexOf("<caret>");
            int selStartIndex = fileText.indexOf("<selection>");
            int selEndIndex = fileText.indexOf("</selection>");
            this.caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
            this.selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
            this.selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(Result result) throws Exception {
                    if (SelectionAndCaretMarkupLoader.this.caretMarker != null) {
                        document.deleteString(SelectionAndCaretMarkupLoader.this.caretMarker.getStartOffset(), SelectionAndCaretMarkupLoader.this.caretMarker.getStartOffset() + "<caret>".length());
                    }
                    if (SelectionAndCaretMarkupLoader.this.selStartMarker != null) {
                        document.deleteString(SelectionAndCaretMarkupLoader.this.selStartMarker.getStartOffset(), SelectionAndCaretMarkupLoader.this.selStartMarker.getStartOffset() + "<selection>".length());
                    }
                    if (SelectionAndCaretMarkupLoader.this.selEndMarker != null) {
                        document.deleteString(SelectionAndCaretMarkupLoader.this.selEndMarker.getStartOffset(), SelectionAndCaretMarkupLoader.this.selEndMarker.getStartOffset() + "</selection>".length());
                    }
                }
            }.execute();
            this.newFileText = document.getText();
        }
    }
}

